/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.reflect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ClassUtils;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.logger.LoggerType;
import org.slf4j.Logger;

public final class ReflectUtil {
    private static final Logger LOGGER = LoggerType.DUODUO.getLogger();
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Map<Class<?>, Field[]> declaredFieldsCache = new ConcurrentHashMap(256);
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    public static final Predicate<Method> USER_DECLARED_METHODS = method -> !method.isBridge() && !method.isSynthetic();
    private static final Map<Class<?>, Method[]> declaredMethodsCache = new ConcurrentHashMap(256);

    private ReflectUtil() {
    }

    public static List<Field> findFieldList(Class<?> clazz, Predicate<Field> filter) {
        ArrayList list = Lists.newArrayListWithCapacity((int)5);
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ReflectUtil.getDeclaredFields(searchType)) {
                if (!filter.test(field)) continue;
                list.add(field);
            }
        }
        return list;
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectUtil.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        Preconditions.checkNotNull(clazz, (Object)"Class must not be null");
        Preconditions.checkState((name != null || type != null ? 1 : 0) != 0, (Object)"Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ReflectUtil.getDeclaredFields(searchType)) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static Object getField(Object t, String name) {
        Field field = ReflectUtil.findField(t.getClass(), name);
        if (field == null) {
            return null;
        }
        return ReflectUtil.getField(field, t);
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static void setField(Object declaringObj, String name, Object value) {
        Field field = ReflectUtil.findField(declaringObj.getClass(), name);
        if (field == null) {
            return;
        }
        ReflectUtil.setField(declaringObj, field, value);
    }

    public static void setField(Object declaringObj, Field field, Object value) {
        ReflectUtil.makeAccessible(field);
        try {
            field.set(declaringObj, value);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Object getField(Field field, Object obj) {
        if (field == null) {
            return null;
        }
        ReflectUtil.makeAccessible(field);
        try {
            return field.get(obj);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) {
        Constructor<T> constructor = ReflectUtil.getMatchConstructor(clazz, params);
        return ReflectUtil.newInstance(constructor, params);
    }

    public static <T> Constructor<T> getMatchConstructor(Class<T> clazz, Object ... params) {
        Constructor<?>[] constructors;
        Class[] classes = ClassUtils.toClass((Object[])params);
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            boolean allMatch;
            if (constructor.getParameterCount() != classes.length || !(allMatch = IntStream.range(0, classes.length).mapToObj(i -> classes[i] == constructor.getParameterTypes()[i]).allMatch(Boolean::booleanValue))) continue;
            constructor.setAccessible(true);
            return constructor;
        }
        return null;
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... params) {
        if (constructor == null) {
            return null;
        }
        constructor.setAccessible(true);
        try {
            return constructor.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void doWithFields(Class<?> clazz, Consumer<Field> consumer) {
        ReflectUtil.doWithFields(clazz, consumer, null);
    }

    public static void doWithFields(Class<?> clazz, Consumer<Field> consumer, Predicate<Field> predicate) {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = ReflectUtil.getDeclaredFields(targetClass)) {
                if (predicate != null && !predicate.test(field)) continue;
                try {
                    ReflectUtil.makeAccessible(field);
                    consumer.accept(field);
                }
                catch (Exception ex) {
                    throw new CustomException(ex, "Not allowed to access field '{}'! ", field.getName());
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Class must not be null");
        return declaredFieldsCache.computeIfAbsent(clazz, key -> {
            Field[] declaredFields = key.getDeclaredFields();
            return declaredFields.length == 0 ? EMPTY_FIELD_ARRAY : declaredFields;
        });
    }

    public static void doWithMethods(Class<?> clazz, Consumer<Method> mc) {
        ReflectUtil.doWithMethods(clazz, mc, null);
    }

    public static void doWithMethods(Class<?> clazz, Consumer<Method> mc, Predicate<Method> mf) {
        Method[] methods = ReflectUtil.getDeclaredMethods(clazz, false);
        for (Method method : methods) {
            if (mf != null && !mf.test(method)) continue;
            try {
                ReflectUtil.makeAccessible(method);
                mc.accept(method);
            }
            catch (Exception ex) {
                throw new CustomException(ex, "Not allowed to access method [{}]", method.getName());
            }
        }
        if (clazz.getSuperclass() != null && (mf != USER_DECLARED_METHODS || clazz.getSuperclass() != Object.class)) {
            ReflectUtil.doWithMethods(clazz.getSuperclass(), mc, mf);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectUtil.doWithMethods(genericDeclaration, mc, mf);
            }
        }
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) {
        ArrayList methods = new ArrayList(32);
        ReflectUtil.doWithMethods(leafClass, methods::add);
        return methods.toArray(EMPTY_METHOD_ARRAY);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectUtil.getDeclaredMethods(clazz, true);
    }

    private static Method[] getDeclaredMethods(Class<?> clazz, boolean defensive) {
        Preconditions.checkNotNull(clazz, (Object)"Class must not be null");
        Method[] result = declaredMethodsCache.get(clazz);
        if (result == null) {
            try {
                Method[] declaredMethods = clazz.getDeclaredMethods();
                List<Method> defaultMethods = ReflectUtil.findConcreteMethodsOnInterfaces(clazz);
                if (defaultMethods != null) {
                    result = new Method[declaredMethods.length + defaultMethods.size()];
                    System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                    int index = declaredMethods.length;
                    Iterator<Method> iterator = defaultMethods.iterator();
                    while (iterator.hasNext()) {
                        Method defaultMethod;
                        result[index] = defaultMethod = iterator.next();
                        ++index;
                    }
                } else {
                    result = declaredMethods;
                }
                declaredMethodsCache.put(clazz, result.length == 0 ? EMPTY_METHOD_ARRAY : result);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return result.length == 0 || !defensive ? result : (Method[])result.clone();
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new ArrayList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    public static Class<?> findGenericParameterizedType(Class<?> oriClazz, Predicate<Class<?>> filter) {
        return ReflectUtil.findGenericParameterizedType(oriClazz, (Class<?> c1, Class<?> c2) -> filter == null || filter.test((Class<?>)c2));
    }

    public static Class<?> findGenericParameterizedType(Class<?> oriClazz, BiPredicate<Class<?>, Class<?>> filter) {
        Class<?> clazz = oriClazz;
        do {
            Type[] types;
            if (!(clazz.getGenericSuperclass() instanceof ParameterizedType)) {
                clazz = clazz.getSuperclass();
                continue;
            }
            for (Type type : types = ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()) {
                if (!(type instanceof Class) || !filter.test(clazz, (Class)type)) continue;
                return (Class)type;
            }
            clazz = clazz.getSuperclass();
        } while (clazz != Object.class);
        return null;
    }

    public static Class<?> getListGenericParameterizedType(Field field) {
        if (!List.class.isAssignableFrom(field.getType())) {
            throw new CustomException("Field {}.{} not list type field!", field.getDeclaringClass().getName(), field.getName());
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            throw new CustomException("Field {}.{} not have generic type field!", field.getDeclaringClass().getName(), field.getName());
        }
        ParameterizedType ptype = (ParameterizedType)genericType;
        Type[] actualTypeArguments = ptype.getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }

    public static void modifyAnnotationValue(Annotation annotation, String key, Object value) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
        try {
            Field memberValues = invocationHandler.getClass().getDeclaredField("memberValues");
            ReflectUtil.makeAccessible(memberValues);
            Map obj = (Map)memberValues.get(invocationHandler);
            obj.put(key, value);
        }
        catch (Exception e) {
            LoggerType.DUODUO.error("modifyAnnotationValue error", e);
        }
    }
}

