/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.scanner;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.qiunet.utils.args.ArgsContainer;
import org.qiunet.utils.async.LazyLoader;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.reflect.ReflectUtil;
import org.qiunet.utils.scanner.IApplicationContext;
import org.qiunet.utils.scanner.IApplicationContextAware;
import org.qiunet.utils.scanner.ScannerType;
import org.qiunet.utils.scanner.anno.AutoWired;
import org.qiunet.utils.scanner.anno.IgnoreEmptyWired;
import org.qiunet.utils.scanner.event.AutoWireCompleteEventData;

enum AutoWiredHandler implements IApplicationContextAware
{
    instance;

    private IApplicationContext context;
    private static final LazyLoader<Class<?>> cfgWrapperClass;

    @Override
    public void setApplicationContext(IApplicationContext context, ArgsContainer argsContainer) throws Exception {
        this.context = context;
        Set<Field> fields = context.getFieldsAnnotatedWith(AutoWired.class);
        for (Field field : fields) {
            Class fieldType;
            if (this.handlerCfgAutoWire(field)) continue;
            Class type = fieldType = field.getType();
            if (Modifier.isAbstract(fieldType.getModifiers()) || Modifier.isInterface(fieldType.getModifiers())) {
                Set<Class<?>> classes = context.getSubTypesOf(fieldType);
                if (classes.isEmpty()) {
                    if (fieldType.isAnnotationPresent(IgnoreEmptyWired.class)) continue;
                    throw new CustomException("Field type {} have none subType class, Do not know how to wired", fieldType.getName());
                }
                if (classes.size() > 1) {
                    throw new CustomException("Field type {} have much subType class, Do not know how to wired", fieldType.getName());
                }
                type = (Class)Lists.newArrayList(classes).get(0);
            }
            Object autoWiredObj = context.getInstanceOfClass(type, new Object[0]);
            Object declaringObj = null;
            if (!Modifier.isStatic(field.getModifiers())) {
                declaringObj = context.getInstanceOfClass(field.getDeclaringClass(), new Object[0]);
            }
            ReflectUtil.setField(declaringObj, field, autoWiredObj);
        }
        AutoWireCompleteEventData.instance.fireEventHandler();
    }

    private boolean handlerCfgAutoWire(Field field) {
        if (cfgWrapperClass.get() == null) {
            return false;
        }
        return cfgWrapperClass.get().isAssignableFrom(field.getType());
    }

    @Override
    public int order() {
        return 11;
    }

    @Override
    public ScannerType scannerType() {
        return ScannerType.AUTO_WIRE;
    }

    static {
        cfgWrapperClass = new LazyLoader<Class>(() -> {
            String cfgAutoWireClass = "org.qiunet.cfg.wrapper.ICfgWrapper";
            try {
                return Class.forName(cfgAutoWireClass);
            }
            catch (Exception e) {
                return null;
            }
        });
    }
}

