/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.scanner;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qiunet.utils.args.ArgsContainer;
import org.qiunet.utils.args.ArgumentKey;
import org.qiunet.utils.async.future.DFuture;
import org.qiunet.utils.date.DateUtil;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.logger.LoggerType;
import org.qiunet.utils.reflect.ReflectUtil;
import org.qiunet.utils.scanner.IApplicationContext;
import org.qiunet.utils.scanner.IApplicationContextAware;
import org.qiunet.utils.scanner.ScannerType;
import org.qiunet.utils.timer.TimerManager;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.slf4j.Logger;

public final class ClassScanner
implements IApplicationContext {
    private static final Scanner[] scanners = new Scanner[]{Scanners.FieldsAnnotated, Scanners.MethodsAnnotated, Scanners.TypesAnnotated, Scanners.SubTypes};
    private final ConcurrentHashMap<Class, Object> beanInstances = new ConcurrentHashMap();
    private static final Logger logger = LoggerType.DUODUO.getLogger();
    private final ArgsContainer argsContainer = new ArgsContainer();
    private static ClassScanner instance;
    private Reflections reflections;
    private final int scannerTypes;
    private boolean recycled;
    private final AtomicBoolean scannered = new AtomicBoolean();
    private Set<String> scannerClassNames;

    private ClassScanner(ScannerType ... scannerTypes) {
        if (instance != null) {
            throw new CustomException("Instance Duplication!", new Object[0]);
        }
        this.reflections = new Reflections("org.qiunet", scanners);
        int scannerType = 0;
        for (ScannerType type : scannerTypes) {
            scannerType |= type.getStatus();
        }
        this.scannerTypes = scannerType;
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClassScanner getInstance(ScannerType ... scannerType) {
        if (instance != null) return instance;
        Class<ClassScanner> clazz = ClassScanner.class;
        synchronized (ClassScanner.class) {
            if (instance != null) return instance;
            new ClassScanner(scannerType);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void scanner(String ... packetPrefix) {
        try {
            this.scanner0(packetPrefix);
        }
        catch (Exception e) {
            logger.error("Scanner Exception:", (Throwable)e);
            System.exit(1);
        }
        finally {
            this.reflections = null;
            this.recycled = true;
        }
    }

    private void scanner0(String ... packetPrefix) throws Exception {
        if (this.scannered.get() || !this.scannered.compareAndSet(false, true)) {
            logger.warn("ClassScanner was initialization , ignore this!");
            return;
        }
        if (packetPrefix != null && packetPrefix.length > 0) {
            this.reflections.merge(new Reflections(new Object[]{packetPrefix, scanners}));
        }
        Set subTypesOf = this.reflections.getSubTypesOf(IApplicationContextAware.class);
        List collect = subTypesOf.stream().map(aClass -> (IApplicationContextAware)this.getInstanceOfClass((Class)aClass, new Object[0])).sorted((o1, o2) -> ComparisonChain.start().compare(o2.order(), o1.order()).compare(o1.scannerType().ordinal(), o2.scannerType().ordinal()).result()).collect(Collectors.toList());
        AtomicReference reference = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(collect.size());
        HashSet futures = Sets.newHashSet();
        if (logger.isDebugEnabled()) {
            this.scannerClassNames = collect.stream().map(o -> o.getClass().getSimpleName()).collect(Collectors.toSet());
            logger.debug("scanner start count: {}, detail: {}", (Object)collect.size(), (Object)Arrays.toString(this.scannerClassNames.toArray()));
        }
        for (IApplicationContextAware instance : collect) {
            logger.debug("scanner start detail: {}", (Object)instance.getClass().getName());
            if (!this.isPrepare(instance.scannerType())) {
                this.countdown(latch, instance.getClass().getSimpleName());
                continue;
            }
            if (instance.order() > 0) {
                this.run(instance);
                this.countdown(latch, instance.getClass().getSimpleName());
                continue;
            }
            DFuture<String> future = TimerManager.executorNow(() -> {
                this.run(instance);
                return instance.getClass().getSimpleName();
            });
            futures.add(future);
            future.whenComplete((res, ex) -> {
                if (ex != null) {
                    logger.error("==scanner exception!==");
                    reference.compareAndSet(null, (Exception)ex);
                    futures.forEach(future0 -> future0.cancel(true));
                    long count = latch.getCount();
                    for (long i = 0L; i < count; ++i) {
                        this.countdown(latch, null);
                    }
                } else {
                    this.countdown(latch, (String)res);
                }
            });
        }
        latch.await();
        if (reference.get() != null) {
            throw (Exception)reference.get();
        }
    }

    private void countdown(CountDownLatch latch, String className) {
        latch.countDown();
        if (logger.isDebugEnabled() && className != null) {
            this.scannerClassNames.remove(className);
            logger.debug("countdown  {}, last scanner class {}", (Object)className, (Object)Arrays.toString(this.scannerClassNames.toArray()));
        }
    }

    public <T> ClassScanner addParam(ArgumentKey<T> argKey, T obj) {
        this.argsContainer.setVal(argKey, obj);
        return this;
    }

    private void run(IApplicationContextAware applicationContextAware) throws Exception {
        long millisSeconds = DateUtil.calConsumeMillisSeconds(() -> applicationContextAware.setApplicationContext(this, this.argsContainer));
        if (logger.isDebugEnabled()) {
            logger.debug("ApplicationContext [{}] consume [{}] ms", (Object)applicationContextAware.getClass().getSimpleName(), (Object)millisSeconds);
        }
    }

    @Override
    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        return this.reflections.getSubTypesOf(type);
    }

    @Override
    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        if (this.recycled) {
            throw new RuntimeException("Already recycled!");
        }
        return this.reflections.getTypesAnnotatedWith(annotation);
    }

    @Override
    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        if (this.recycled) {
            throw new RuntimeException("Already recycled!");
        }
        return this.reflections.getFieldsAnnotatedWith(annotation);
    }

    @Override
    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        if (this.recycled) {
            throw new RuntimeException("Already recycled!");
        }
        return this.reflections.getMethodsAnnotatedWith(annotation);
    }

    @Override
    public boolean isPrepare(ScannerType scannerType) {
        return scannerType.test(this.scannerTypes);
    }

    @Override
    public Object getInstanceOfClass(Class clazz, Object ... params) {
        return this.beanInstances.computeIfAbsent(clazz, key -> {
            Optional<Object> first = Stream.of(key.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> f.getType() == key).map(f -> ReflectUtil.getField(f, null)).filter(Objects::nonNull).findFirst();
            if (first.isPresent()) {
                return first.get();
            }
            Object ret = ReflectUtil.newInstance(key, params);
            if (ret != null) {
                return ret;
            }
            throw new NullPointerException("can not get instance for class [" + key.getName() + "]");
        });
    }
}

