/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.scanner;

public enum ScannerType {
    NONE(0),
    OBJ_CONVERT(2),
    EVENT(4),
    CONDITION(8),
    ROBOT_BEHAVIOR_BUILDER(16),
    CFG_SCANNER(32),
    AUTO_WIRE(64, OBJ_CONVERT, EVENT),
    FILE_CONFIG(128, OBJ_CONVERT),
    BEHAVIOR_ACTION(256, CONDITION),
    CREATE_AI_CONFIG(512),
    CREATE_TABLE(1024, FILE_CONFIG),
    CRON(2048),
    PLAYER_DATA_LOADER(4096, FILE_CONFIG),
    FORMULA(16384, AUTO_WIRE, EVENT),
    CHANNEL_DATA(32768),
    GM_COMMAND(65536),
    KEY_VAL_CFG(131072, CFG_SCANNER),
    GENERATOR_PROTO(262144, CHANNEL_DATA),
    GAME_TEST_RESPONSE(524288),
    SERVER_NODE(0x100000, EVENT),
    TARGET_HANDLER(0x200000, EVENT),
    TRANSACTION(0x400000),
    URL_REQUEST(0x800000),
    ATTR(0x1000000),
    FAKE_ENUM(0x2000000),
    LOG_RECORD(0x4000000, FILE_CONFIG),
    CFG(EVENT, CFG_SCANNER, KEY_VAL_CFG, AUTO_WIRE, OBJ_CONVERT),
    SERVER(CFG, ATTR, CRON, FORMULA, FAKE_ENUM, CONDITION, GM_COMMAND, FILE_CONFIG, CHANNEL_DATA, SERVER_NODE, LOG_RECORD, TRANSACTION, URL_REQUEST, CREATE_TABLE, TARGET_HANDLER, BEHAVIOR_ACTION, PLAYER_DATA_LOADER),
    CLIENT(CFG, FORMULA, CONDITION, CHANNEL_DATA),
    GAME_TEST(SERVER, GAME_TEST_RESPONSE, ROBOT_BEHAVIOR_BUILDER),
    ALL(Integer.MAX_VALUE);

    private final int originStatus;
    private final int complexStatus;

    private ScannerType(int status, ScannerType ... types) {
        int complexStatus = status;
        for (ScannerType type : types) {
            complexStatus |= type.complexStatus;
        }
        this.complexStatus = complexStatus;
        this.originStatus = status;
    }

    private ScannerType(ScannerType ... types) {
        this(0, types);
    }

    private ScannerType(int status) {
        this.originStatus = status;
        this.complexStatus = status;
    }

    public int getStatus() {
        return this.complexStatus;
    }

    public boolean test(int val) {
        return (this.originStatus | val) == val;
    }
}

