/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.secret;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.qiunet.utils.secret.SecretUtil;

public class MD5Util {
    private static final ThreadLocal<MessageDigest> MD5 = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("MD5 not supported on this platform - Outdated?");
        }
    });

    public static String encrypt(String source) {
        return MD5Util.encrypt(source, "utf8");
    }

    private static MessageDigest getMd5Digest() {
        MessageDigest digest = MD5.get();
        digest.reset();
        return digest;
    }

    public static String encrypt(String source, String charset) {
        String rt = "";
        try {
            MessageDigest digest = MD5Util.getMd5Digest();
            digest.update(source.getBytes(charset));
            byte[] md = digest.digest();
            char[] str = new char[md.length * 2];
            int k = 0;
            for (int i = 0; i < md.length; ++i) {
                byte b = md[i];
                str[k++] = SecretUtil.hexDigits[b >>> 4 & 0xF];
                str[k++] = SecretUtil.hexDigits[b & 0xF];
            }
            rt = new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rt;
    }

    private MD5Util() {
    }

    public static String encrypt(byte[] bytes) {
        String resultString = null;
        try {
            MessageDigest digest = MD5Util.getMd5Digest();
            resultString = SecretUtil.byteArrayToHexString(digest.digest(bytes));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return resultString;
    }

    public static String encrypt(File file) throws Exception {
        Preconditions.checkNotNull((Object)file);
        return MD5Util.encrypt(Files.readAllBytes(file.toPath()));
    }
}

