/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.secret;

public class ProtocolUtil {
    public static byte[] encryptData(byte[] data, short chunkSize) {
        if (data == null) {
            return null;
        }
        if (chunkSize < 1) {
            chunkSize = 1;
        }
        int len = data.length;
        byte[] ret = new byte[len];
        if (chunkSize <= 0 || chunkSize >= len) {
            System.arraycopy(data, 0, ret, 0, len);
            return ret;
        }
        int chunkNum = len / chunkSize;
        int oddSize = len % chunkSize;
        int srcPos = len;
        int destPos = 0;
        if (oddSize != 0) {
            System.arraycopy(data, srcPos -= oddSize, ret, destPos, oddSize);
            destPos += oddSize;
        }
        for (int i = chunkNum - 1; i >= 0; --i) {
            System.arraycopy(data, srcPos -= chunkSize, ret, destPos, chunkSize);
            destPos += chunkSize;
        }
        return ret;
    }

    public static byte[] decryptData(byte[] data, short chunkSize) {
        if (data == null) {
            return null;
        }
        if (chunkSize < 1) {
            chunkSize = 1;
        }
        int len = data.length;
        byte[] ret = new byte[len];
        if (chunkSize <= 0 || chunkSize >= len) {
            System.arraycopy(data, 0, ret, 0, len);
            return ret;
        }
        int chunkNum = len / chunkSize;
        int oddSize = len % chunkSize;
        int srcPos = 0;
        int destPos = len;
        if (oddSize != 0) {
            System.arraycopy(data, srcPos, ret, destPos -= oddSize, oddSize);
            srcPos += oddSize;
        }
        for (int i = chunkNum - 1; i >= 0; --i) {
            System.arraycopy(data, srcPos, ret, destPos -= chunkSize, chunkSize);
            srcPos += chunkSize;
        }
        return ret;
    }
}

