/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.secret;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.qiunet.utils.secret.SecretUtil;

public final class SHA1Util {
    private static final ThreadLocal<MessageDigest> SHA1 = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("SHA-1 not supported on this platform - Outdated?");
        }
    });

    private static byte[] sha1(byte[] data) {
        MessageDigest digest = SHA1.get();
        digest.reset();
        return digest.digest(data);
    }

    public static String sha1(File file) throws IOException {
        return SecretUtil.byteArrayToHexString(Files.readAllBytes(file.toPath()));
    }

    public static String sha1(String source) {
        return SHA1Util.sha1(source, StandardCharsets.UTF_8);
    }

    public static String sha1(String source, Charset charset) {
        byte[] bytes = source.getBytes(charset);
        return SecretUtil.byteArrayToHexString(SHA1Util.sha1(bytes));
    }
}

