/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.string;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qiunet.utils.math.MathUtil;
import org.slf4j.helpers.MessageFormatter;

public class StringUtil {
    public static final Pattern CHINESE_REGEX = Pattern.compile("([\u4e00-\u9fa5]*)");
    public static final String EMPTY_STRING = "";
    private static final String chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int start = Integer.valueOf("4e00", 16);
    private static final int end = Integer.valueOf("9fa5", 16);

    private StringUtil() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String[] split(String srcStr, String splitStr) {
        if (srcStr == null || srcStr.length() == 0) {
            return new String[0];
        }
        LinkedList<String> retList = new LinkedList<String>();
        int before = 0;
        int cursor = 0;
        boolean splitValid = false;
        for (int i = 0; i < srcStr.length(); ++i) {
            if (!splitValid && srcStr.charAt(i) == splitStr.charAt(0)) {
                splitValid = true;
                cursor = i;
            }
            if (!splitValid) continue;
            if (srcStr.charAt(i) != splitStr.charAt(i - cursor)) {
                splitValid = false;
                continue;
            }
            if (i - cursor != splitStr.length() - 1) continue;
            int validCursor = cursor;
            retList.add(srcStr.substring(before, validCursor));
            before = i + 1;
            splitValid = false;
        }
        retList.add(srcStr.substring(before));
        return retList.toArray(new String[0]);
    }

    public static <T extends Number> T[] conversion(String[] k, Class<T> t) {
        Number[] tt = (Number[])Array.newInstance(t, k.length);
        try {
            for (int i = 0; i < k.length; ++i) {
                Method m = t.getMethod("valueOf", String.class);
                tt[i] = (Number)m.invoke(t, k[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tt;
    }

    public static <T extends Number> T[] conversion(String src, String split, Class<T> t) {
        return StringUtil.conversion((String[])StringUtil.split(src, split), t);
    }

    public static <T> String arraysToString(T[] arrays, String separator) {
        return StringUtil.arraysToString(arrays, EMPTY_STRING, EMPTY_STRING, separator);
    }

    public static <T> String arraysToString(T[] arrays, String start, String end, String separator) {
        return StringUtil.arraysToString(arrays, start, end, 0, arrays.length - 1, separator);
    }

    public static <T> String arraysToString(T[] arrays, String start, String end, int startIndex, int endIndex, String separator) {
        StringJoiner joiner = new StringJoiner(separator, start, end);
        for (int i = startIndex; i <= endIndex; ++i) {
            joiner.add(StringUtil.objectToString(arrays[i]));
        }
        return joiner.toString();
    }

    public static <T> String arraysToString(Collection<T> arrays, String start, String end, String separator) {
        StringJoiner joiner = new StringJoiner(separator, start, end);
        arrays.forEach(t -> joiner.add(t.toString()));
        return joiner.toString();
    }

    public static String mapToString(Map<?, ?> map, String keyValSeparator, String separator, String start, String end) {
        StringJoiner joiner = new StringJoiner(separator, start, end);
        map.forEach((key, val) -> joiner.add(key.toString() + keyValSeparator + val.toString()));
        return joiner.toString();
    }

    public static String mapToString(Map<?, ?> map, String keyValSeparator, String separator) {
        return StringUtil.mapToString(map, keyValSeparator, separator, EMPTY_STRING, EMPTY_STRING);
    }

    private static String objectToString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass().isArray()) {
            return Arrays.toString((Object[])obj);
        }
        return obj.toString();
    }

    public static boolean regex(String matchStr, String regex) {
        if (StringUtil.isEmpty(matchStr)) {
            return false;
        }
        Pattern p = Pattern.compile(regex);
        return StringUtil.regex(matchStr, p);
    }

    public static boolean isNum(String numStr) {
        if (numStr == null) {
            return false;
        }
        return numStr.matches("-?[0-9]+");
    }

    public static boolean regex(String matchStr, Pattern p) {
        Matcher m = p.matcher(matchStr);
        return m.matches();
    }

    public static int regexCount(String matchStr, String regex) {
        if (StringUtil.isEmpty(matchStr)) {
            return 0;
        }
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(matchStr);
        if (m.find()) {
            return m.groupCount();
        }
        return 0;
    }

    public static boolean regexChinese(String matchStr) {
        return StringUtil.regex(matchStr, CHINESE_REGEX);
    }

    public static String format(String string, Object ... params) {
        return MessageFormat.format(string, params);
    }

    public static String slf4jFormat(String string, Object ... params) {
        return MessageFormatter.arrayFormat((String)string, (Object[])params).getMessage();
    }

    public static String getIntHexVal(int val) {
        return String.format("%08x", val).toUpperCase();
    }

    public static String getByteHexVal(byte val) {
        return String.format("%02x", val).toUpperCase();
    }

    public static String getShortHexVal(short val) {
        return String.format("%04x", val).toUpperCase();
    }

    public static String randomString(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(chars.charAt(MathUtil.random(chars.length())));
        }
        return sb.toString();
    }

    public static String repeated(String string, int count) {
        if (count == 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static String powerfulTrim(String str) {
        int start;
        if (str == null || str.isEmpty()) {
            return str;
        }
        int length = str.length();
        for (start = 0; start < length && !StringUtil.isAllowChar(str.charAt(start)); ++start) {
        }
        while (length > start && !StringUtil.isAllowChar(str.charAt(length - 1))) {
            --length;
        }
        if (start > 0 || length < str.length()) {
            return str.substring(start, length);
        }
        return str;
    }

    private static boolean isAllowChar(char ch) {
        if (ch >= '!' && ch <= '~') {
            return true;
        }
        return ch >= start && ch <= end;
    }

    public static int getMixedStringLength(String input) {
        int length = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            length += c >= start && c <= end ? 2 : 1;
        }
        return length;
    }

    public static boolean equals(String str1, String str2) {
        return Objects.equals(str1, str2);
    }
}

