/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.string;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.qiunet.utils.logger.LoggerType;
import org.qiunet.utils.reflect.ReflectUtil;
import org.qiunet.utils.string.IDataToString;

public final class ToString {
    private static final String nullText = "<null>";
    private static final String contentStart = "[";
    private static final String contentEnd = "]";
    private static final String fieldNameValueSeparator = " = ";
    private static final String fieldSeparator = ", ";
    private static final String arrayStart = "{";
    private static final String arraySeparator = ", ";
    private static final String arrayEnd = "}";

    public static String toString(Object obj) {
        if (obj instanceof IDataToString) {
            return ((IDataToString)obj)._toString();
        }
        return ToString.objToString(obj);
    }

    private static void appendFields(Object obj, StringJoiner joiner) {
        ReflectUtil.doWithFields(obj.getClass(), field -> {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) {
                return;
            }
            try {
                field.setAccessible(true);
                Object fieldValue = field.get(obj);
                joiner.add(field.getName() + fieldNameValueSeparator + ToString.objToString(fieldValue));
            }
            catch (IllegalAccessException e) {
                LoggerType.DUODUO.error("Object {} field {} get value error! {}", obj.getClass(), field.getName(), e);
            }
        });
    }

    private static String arrToString(Object obj) {
        if (Objects.isNull(obj)) {
            return nullText;
        }
        Class<?> aClass = obj.getClass();
        StringJoiner joiner = new StringJoiner(", ", aClass.getSimpleName() + arrayStart, arrayEnd);
        if (aClass == int[].class) {
            for (int val : (int[])obj) {
                joiner.add(String.valueOf(val));
            }
        } else if (aClass == long[].class) {
            for (long val : (long[])obj) {
                joiner.add(String.valueOf(val));
            }
        } else if (aClass == byte[].class) {
            for (byte val : (byte[])obj) {
                joiner.add(String.valueOf(val));
            }
        } else if (aClass == short[].class) {
            for (short val : (short[])obj) {
                joiner.add(String.valueOf(val));
            }
        } else if (aClass == float[].class) {
            for (float val : (float[])obj) {
                joiner.add(String.valueOf(val));
            }
        } else if (aClass == double[].class) {
            for (double val : (double[])obj) {
                joiner.add(String.valueOf(val));
            }
        } else if (aClass == boolean[].class) {
            for (boolean val : (boolean[])obj) {
                joiner.add(String.valueOf(val));
            }
        } else {
            for (Object o : (Object[])obj) {
                joiner.add(ToString.objToString(o));
            }
        }
        return joiner.toString();
    }

    private static String objToString(Object obj) {
        if (obj == null) {
            return nullText;
        }
        Class<?> aClass = obj.getClass();
        if (aClass.isArray()) {
            return ToString.arrToString(obj);
        }
        if (aClass == String.class || aClass == Integer.class || aClass == Long.class || aClass == Boolean.class || aClass == Short.class || aClass == Float.class || aClass == Byte.class || aClass == Double.class || aClass.isEnum() || aClass.getSuperclass().isEnum()) {
            return String.valueOf(obj);
        }
        if (Date.class.isAssignableFrom(aClass)) {
            return String.valueOf(((Date)obj).getTime());
        }
        if (Map.class.isAssignableFrom(aClass)) {
            StringJoiner joiner = new StringJoiner(", ", arrayStart, arrayEnd);
            ((Map)obj).forEach((key, val) -> joiner.add(ToString.objToString(key) + fieldNameValueSeparator + ToString.objToString(val)));
            return joiner.toString();
        }
        if (Collection.class.isAssignableFrom(aClass)) {
            StringJoiner joiner = new StringJoiner(", ", arrayStart, arrayEnd);
            ((Collection)obj).forEach(val -> joiner.add(ToString.objToString(val)));
            return joiner.toString();
        }
        return ToString.objDetail(obj);
    }

    private static String objDetail(Object obj) {
        if (Objects.isNull(obj)) {
            return nullText;
        }
        StringJoiner joiner = new StringJoiner(", ", obj.getClass().getSimpleName() + contentStart, contentEnd);
        ToString.appendFields(obj, joiner);
        return joiner.toString();
    }
}

