/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.system;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.StringJoiner;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.string.StringUtil;

public class CmdUtil {
    private CmdUtil() {
    }

    public static String exec(Path commandPath, String ... args) {
        return CmdUtil.exec(commandPath.toString(), args);
    }

    public static String exec(String commandPath, String ... args) {
        String command = commandPath;
        command = command.replace("~", System.getProperty("user.home"));
        StringJoiner sb = new StringJoiner("\n");
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(StringUtil.arraysToString(args, command + " ", "", " "));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Preconditions.checkNotNull(process, (Object)"process is null");
        try (InputStreamReader ir = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
             LineNumberReader input = new LineNumberReader(ir);
             InputStreamReader irError = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
             LineNumberReader inputError = new LineNumberReader(irError);){
            String line;
            while ((line = input.readLine()) != null) {
                sb.add(line);
            }
            StringJoiner sbError = new StringJoiner("\n");
            while ((line = inputError.readLine()) != null) {
                sbError.add(line);
            }
            if (sbError.length() > 0) {
                throw new CustomException(sbError.toString(), new Object[0]);
            }
        }
        catch (Exception e) {
            throw new CustomException(e, "\u6267\u884c\u5f02\u5e38", new Object[0]);
        }
        return sb.toString();
    }
}

