/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.system;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import org.qiunet.utils.exceptions.CustomException;
import org.qiunet.utils.system.SystemPropertyUtil;

public class OSUtil {
    private OSUtil() {
    }

    public static int availableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int pid() {
        return Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static boolean isWindows() {
        return SystemPropertyUtil.getOsName() == SystemPropertyUtil.OSType.WINDOWS;
    }

    public static boolean isLinux() {
        return SystemPropertyUtil.getOsName() == SystemPropertyUtil.OSType.LINUX;
    }

    public static boolean isMac() {
        return SystemPropertyUtil.getOsName() == SystemPropertyUtil.OSType.MAC_OS;
    }

    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long getUsedDirectMemory() {
        BufferPoolMXBean bufferPoolMXBean = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class).stream().filter(e -> e.getName().equals("direct")).findFirst().orElseThrow(() -> new CustomException("getUsedDirectMemory throw exception", new Object[0]));
        return bufferPoolMXBean.getMemoryUsed();
    }

    public static long getUsableMemory() {
        return OSUtil.getMaxMemory() - OSUtil.getTotalMemory() + OSUtil.getFreeMemory();
    }
}

