/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.system;

import org.qiunet.utils.data.IKeyValueData;
import org.qiunet.utils.logger.LoggerType;
import org.slf4j.Logger;

public final class SystemPropertyUtil {
    private static final Logger logger = LoggerType.DUODUO.getLogger();
    private static final IKeyValueData<Object, Object> data = System::getProperties;

    private SystemPropertyUtil() {
    }

    public static String get(String key) {
        return String.valueOf(data.getValue(key));
    }

    public static String get(String key, String defaultVal) {
        if (!data.containKey(key)) {
            return defaultVal;
        }
        return SystemPropertyUtil.get(key);
    }

    public static String getUserHome() {
        return SystemPropertyUtil.get("user.home");
    }

    public static String getUserDir() {
        return SystemPropertyUtil.get("user.dir");
    }

    public static OSType getOsName() {
        return OSType.getOSType(SystemPropertyUtil.get("os.name"));
    }

    public static String getPathSeparator() {
        return SystemPropertyUtil.get("path.separator");
    }

    public static String getFileSeparator() {
        return SystemPropertyUtil.get("file.separator");
    }

    public static String getLineSeparator() {
        return SystemPropertyUtil.get("line.separator");
    }

    public static enum OSType {
        MAC_OS,
        WINDOWS,
        LINUX;


        public boolean is(OSType type) {
            return this == type;
        }

        private static OSType getOSType(String osName) {
            if (osName.startsWith("Mac OS")) {
                return MAC_OS;
            }
            if (osName.startsWith("Windows")) {
                return WINDOWS;
            }
            return LINUX;
        }
    }
}

