/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.thread;

import java.util.HashMap;
import java.util.Map;

public class ThreadContextData {
    private static final ThreadLocal<Map<String, Object>> servletRequestContext = ThreadLocal.withInitial(HashMap::new);

    private ThreadContextData() {
    }

    private static Map<String, Object> getThreadParamMap() {
        return servletRequestContext.get();
    }

    public boolean isEmpty() {
        return ThreadContextData.getThreadParamMap().isEmpty();
    }

    public static void put(String key, Object val) {
        if (val == null) {
            val = "NULL";
        }
        ThreadContextData.getThreadParamMap().put(key, val);
    }

    public static <T> T get(String key) {
        Object val = ThreadContextData.getThreadParamMap().get(key);
        if ("NULL".equals(val)) {
            return null;
        }
        return (T)val;
    }

    public static void removeKey(String key) {
        ThreadContextData.getThreadParamMap().remove(key);
    }

    public static void removeAll() {
        servletRequestContext.remove();
    }
}

