/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.timer;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.qiunet.utils.async.factory.DefaultThreadFactory;
import org.qiunet.utils.async.future.DCompletePromise;
import org.qiunet.utils.async.future.DFuture;
import org.qiunet.utils.date.DateUtil;
import org.qiunet.utils.listener.event.EventListener;
import org.qiunet.utils.listener.event.data.ServerShutdownEventData;
import org.qiunet.utils.logger.LoggerType;
import org.qiunet.utils.thread.ThreadPoolManager;
import org.qiunet.utils.timer.IDelayTask;
import org.qiunet.utils.timer.IScheduledTask;
import org.qiunet.utils.timer.executor.DScheduledThreadPoolExecutor;

public enum TimerManager {
    instance(new DScheduledThreadPoolExecutor(8, 1000L, new DefaultThreadFactory("qiunet_fix_schedule_timerManager"))),
    executor(new ScheduledThreadPoolExecutor(8, new DefaultThreadFactory("qiunet_jdk_schedule_timerManager")));

    private final ScheduledExecutorService schedule;

    private TimerManager(ScheduledExecutorService executorService) {
        this.schedule = executorService;
    }

    @EventListener
    private void shutdown(ServerShutdownEventData eventData) {
        for (TimerManager value : TimerManager.values()) {
            value.schedule.shutdown();
        }
    }

    public static <V> DFuture<V> executorNow(Runnable callable) {
        return TimerManager.executorNow(() -> {
            callable.run();
            return null;
        });
    }

    public static <V> DFuture<V> executorNow(Callable<V> callable) {
        DCompletePromise<Object> future = new DCompletePromise<Object>();
        Future<Object> submit = ThreadPoolManager.NORMAL.submit(() -> {
            Object result = null;
            try {
                result = callable.call();
                future.trySuccess(result);
            }
            catch (Exception e) {
                future.tryFailure(e);
            }
            return result;
        });
        future.setFuture(submit);
        return future;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(IScheduledTask timerTask, long delay, long period, TimeUnit unit) {
        return this.schedule.scheduleAtFixedRate(timerTask, delay, period, unit);
    }

    public <T> DFuture<T> scheduleWithDelay(Runnable delayTask, long delay, TimeUnit unit) {
        return this.scheduleWithDelay(() -> {
            delayTask.run();
            return null;
        }, delay, unit);
    }

    public <T> DFuture<T> scheduleWithDelay(IDelayTask<T> delayTask, long delay, TimeUnit unit) {
        DCompletePromise<Object> promise = new DCompletePromise<Object>();
        Callable<Object> caller = () -> {
            try {
                Object result = delayTask.call();
                promise.trySuccess(result);
                return result;
            }
            catch (Exception e) {
                LoggerType.DUODUO.error("DelayTask Exception: ", e);
                promise.tryFailure(e);
                return null;
            }
        };
        ScheduledFuture<Object> future = this.schedule.schedule(caller, delay, unit);
        promise.setFuture(future);
        return promise;
    }

    public <T> DFuture<T> scheduleWithTimeMillis(Runnable delayTask, long timeMillis) {
        return this.scheduleWithTimeMillis(() -> {
            delayTask.run();
            return null;
        }, timeMillis);
    }

    public <T> DFuture<T> scheduleWithTimeMillis(IDelayTask<T> delayTask, long timeMillis) {
        long now = DateUtil.currentTimeMillis();
        if (timeMillis < now) {
            throw new IllegalArgumentException("timeMillis is less than currentTimeMillis");
        }
        return this.scheduleWithDelay(delayTask, timeMillis - now, TimeUnit.MILLISECONDS);
    }
}

