/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.timer;

import java.util.function.Supplier;
import org.apache.commons.lang3.time.StopWatch;
import org.qiunet.utils.logger.LoggerType;
import org.slf4j.Logger;

public class UseTimer {
    private static final Logger logger = LoggerType.DUODUO_USE_TIME.getLogger();
    private final Supplier<String> nameGetter;
    private final long warnUseTime;
    private final StopWatch stopWatch;

    public UseTimer(String name, long warnUseTime) {
        this(() -> name, warnUseTime);
    }

    public UseTimer(Supplier<String> nameGetter, long warnUseTime) {
        this.nameGetter = nameGetter;
        this.warnUseTime = warnUseTime;
        this.stopWatch = new StopWatch();
        this.start();
    }

    public void reset() {
        this.stopWatch.reset();
    }

    public void start() {
        this.reset();
        this.stopWatch.start();
    }

    private long countUseTime() {
        this.stopWatch.stop();
        return this.stopWatch.getTime();
    }

    public long printUseTime() {
        return this.printUseTime(null);
    }

    public long printUseTime(Supplier<String> supplement) {
        long useTime = this.countUseTime();
        if (useTime > this.warnUseTime) {
            if (supplement != null) {
                logger.error("{} use {} ms! detail: {}", new Object[]{this.nameGetter.get(), useTime, supplement.get()});
            } else {
                logger.error("{} use {} ms", (Object)this.nameGetter.get(), (Object)useTime);
            }
        }
        return useTime;
    }

    public String toString() {
        return this.nameGetter.get() + " current use [" + this.stopWatch.getTime() + "]ms";
    }
}

