/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.timer.executor;

import com.google.common.base.Preconditions;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.qiunet.utils.date.DateUtil;
import org.qiunet.utils.timer.executor.DRejectedExecutionHandler;
import org.qiunet.utils.timer.executor.DThreadPoolExecutor;

public class DScheduledThreadPoolExecutor
extends DThreadPoolExecutor
implements ScheduledExecutorService {
    private volatile boolean continueExistingPeriodicTasksAfterShutdown;
    private volatile boolean executeExistingDelayedTasksAfterShutdown = true;
    private volatile boolean removeOnCancel = true;
    private static final AtomicLong sequencer = new AtomicLong();

    final long now() {
        return DateUtil.currentTimeMillis();
    }

    boolean canRunInCurrentRunState(boolean periodic) {
        return this.isRunningOrShutdown(periodic ? this.continueExistingPeriodicTasksAfterShutdown : this.executeExistingDelayedTasksAfterShutdown);
    }

    private void delayedExecute(RunnableScheduledFuture<?> task) {
        if (this.isShutdown()) {
            this.reject(task);
        } else {
            super.getQueue().add(task);
            if (this.isShutdown() && !this.canRunInCurrentRunState(task.isPeriodic()) && this.remove(task)) {
                task.cancel(false);
            } else {
                this.ensurePrestart();
            }
        }
    }

    void reExecutePeriodic(RunnableScheduledFuture<?> task) {
        if (this.canRunInCurrentRunState(true)) {
            super.getQueue().add(task);
            if (!this.canRunInCurrentRunState(true) && this.remove(task)) {
                task.cancel(false);
            } else {
                this.ensurePrestart();
            }
        }
    }

    @Override
    void onShutdown() {
        BlockingQueue<Runnable> q = super.getQueue();
        boolean keepDelayed = this.getExecuteExistingDelayedTasksAfterShutdownPolicy();
        boolean keepPeriodic = this.getContinueExistingPeriodicTasksAfterShutdownPolicy();
        if (!keepDelayed && !keepPeriodic) {
            for (Object e : q.toArray()) {
                if (!(e instanceof RunnableScheduledFuture)) continue;
                ((RunnableScheduledFuture)e).cancel(false);
            }
            q.clear();
        } else {
            for (Object e : q.toArray()) {
                RunnableScheduledFuture t;
                if (!(e instanceof RunnableScheduledFuture) || !(!(t = (RunnableScheduledFuture)e).isPeriodic() ? !keepDelayed : !keepPeriodic) && !t.isCancelled() || !q.remove(t)) continue;
                t.cancel(false);
            }
        }
        this.tryTerminate();
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return task;
    }

    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return task;
    }

    public DScheduledThreadPoolExecutor(int delay, TimeUnit unit) {
        this(1, unit.toMillis(delay));
    }

    public DScheduledThreadPoolExecutor() {
        this(1, 60000L);
    }

    public DScheduledThreadPoolExecutor(long delayCheckMillis) {
        this(1, delayCheckMillis);
    }

    public DScheduledThreadPoolExecutor(int corePoolSize, long delayCheckMillis) {
        this(corePoolSize, delayCheckMillis, Executors.defaultThreadFactory());
    }

    public DScheduledThreadPoolExecutor(int corePoolSize, long delayCheckMillis, ThreadFactory threadFactory) {
        this(corePoolSize, delayCheckMillis, threadFactory, defaultHandler);
    }

    public DScheduledThreadPoolExecutor(int corePoolSize, long delayCheckMillis, DRejectedExecutionHandler handler) {
        this(corePoolSize, delayCheckMillis, Executors.defaultThreadFactory(), handler);
    }

    public DScheduledThreadPoolExecutor(int corePoolSize, long delayCheckMillis, ThreadFactory threadFactory, DRejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue(delayCheckMillis), threadFactory, handler);
    }

    private long triggerTime(long delay, TimeUnit unit) {
        return this.triggerTime(unit.toMillis(delay < 0L ? 0L : delay));
    }

    long triggerTime(long delay) {
        return this.now() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(delay));
    }

    private long overflowFree(long delay) {
        long headDelay;
        Delayed head = (Delayed)super.getQueue().peek();
        if (head != null && (headDelay = head.getDelay(TimeUnit.MILLISECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<Object> t = this.decorateTask(command, new ScheduledFutureTask<Object>(command, null, this.triggerTime(delay, unit)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null || unit == null) {
            throw new NullPointerException();
        }
        RunnableScheduledFuture<V> t = this.decorateTask(callable, new ScheduledFutureTask<V>(callable, this.triggerTime(delay, unit)));
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> sft = new ScheduledFutureTask<Object>(command, null, this.triggerTime(initialDelay, unit), unit.toMillis(period));
        RunnableScheduledFuture<Object> t = this.decorateTask(command, sft);
        sft.outerTask = t;
        this.delayedExecute(t);
        return t;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null || unit == null) {
            throw new NullPointerException();
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        ScheduledFutureTask<Object> sft = new ScheduledFutureTask<Object>(command, null, this.triggerTime(initialDelay, unit), unit.toMillis(-delay));
        RunnableScheduledFuture<Object> t = this.decorateTask(command, sft);
        sft.outerTask = t;
        this.delayedExecute(t);
        return t;
    }

    @Override
    public void execute(Runnable command) {
        this.schedule(command, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.schedule(task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.schedule(Executors.callable(task, result), 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.schedule(task, 0L, TimeUnit.MILLISECONDS);
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.continueExistingPeriodicTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public boolean getContinueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdown;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.executeExistingDelayedTasksAfterShutdown = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public boolean getExecuteExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdown;
    }

    public void setRemoveOnCancelPolicy(boolean value) {
        this.removeOnCancel = value;
    }

    public boolean getRemoveOnCancelPolicy() {
        return this.removeOnCancel;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return super.shutdownNow();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return super.getQueue();
    }

    static class DelayedWorkQueue
    extends AbstractQueue<Runnable>
    implements BlockingQueue<Runnable> {
        private static final int INITIAL_CAPACITY = 16;
        private RunnableScheduledFuture<?>[] queue = new RunnableScheduledFuture[16];
        private final ReentrantLock lock = new ReentrantLock();
        private int size = 0;
        private Thread leader = null;
        private long delayCheckMillis;
        private final Condition available = this.lock.newCondition();

        public DelayedWorkQueue(long delayCheckMillis) {
            Preconditions.checkState((delayCheckMillis >= 1000L ? 1 : 0) != 0);
            this.delayCheckMillis = delayCheckMillis;
        }

        private void setIndex(RunnableScheduledFuture<?> f, int idx) {
            if (f instanceof ScheduledFutureTask) {
                ((ScheduledFutureTask)f).heapIndex = idx;
            }
        }

        private void siftUp(int k, RunnableScheduledFuture<?> key) {
            int parent;
            RunnableScheduledFuture<?> e;
            while (k > 0 && key.compareTo(e = this.queue[parent = k - 1 >>> 1]) < 0) {
                this.queue[k] = e;
                this.setIndex(e, k);
                k = parent;
            }
            this.queue[k] = key;
            this.setIndex(key, k);
        }

        private void siftDown(int k, RunnableScheduledFuture<?> key) {
            int half = this.size >>> 1;
            while (k < half) {
                int child = (k << 1) + 1;
                RunnableScheduledFuture<?> c = this.queue[child];
                int right = child + 1;
                if (right < this.size && c.compareTo(this.queue[right]) > 0) {
                    child = right;
                    c = this.queue[child];
                }
                if (key.compareTo(c) <= 0) break;
                this.queue[k] = c;
                this.setIndex(c, k);
                k = child;
            }
            this.queue[k] = key;
            this.setIndex(key, k);
        }

        private void grow() {
            int oldCapacity = this.queue.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            this.queue = Arrays.copyOf(this.queue, newCapacity);
        }

        private int indexOf(Object x) {
            if (x != null) {
                if (x instanceof ScheduledFutureTask) {
                    int i = ((ScheduledFutureTask)x).heapIndex;
                    if (i >= 0 && i < this.size && this.queue[i] == x) {
                        return i;
                    }
                } else {
                    for (int i = 0; i < this.size; ++i) {
                        if (!x.equals(this.queue[i])) continue;
                        return i;
                    }
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object x) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                boolean bl = this.indexOf(x) != -1;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object x) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i = this.indexOf(x);
                if (i < 0) {
                    boolean bl = false;
                    return bl;
                }
                this.setIndex(this.queue[i], -1);
                int s = --this.size;
                RunnableScheduledFuture<?> replacement = this.queue[s];
                this.queue[s] = null;
                if (s != i) {
                    this.siftDown(i, replacement);
                    if (this.queue[i] == replacement) {
                        this.siftUp(i, replacement);
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public int size() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int n = this.size;
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public RunnableScheduledFuture<?> peek() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                RunnableScheduledFuture<?> runnableScheduledFuture = this.queue[0];
                return runnableScheduledFuture;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean offer(Runnable x) {
            if (x == null) {
                throw new NullPointerException();
            }
            RunnableScheduledFuture e = (RunnableScheduledFuture)x;
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                int i = this.size;
                if (i >= this.queue.length) {
                    this.grow();
                }
                this.size = i + 1;
                if (i == 0) {
                    this.queue[0] = e;
                    this.setIndex(e, 0);
                } else {
                    this.siftUp(i, e);
                }
                if (this.queue[0] == e) {
                    this.leader = null;
                    this.available.signal();
                }
            }
            finally {
                lock.unlock();
            }
            return true;
        }

        @Override
        public void put(Runnable e) {
            this.offer(e);
        }

        @Override
        public boolean add(Runnable e) {
            return this.offer(e);
        }

        @Override
        public boolean offer(Runnable e, long timeout, TimeUnit unit) {
            return this.offer(e);
        }

        private RunnableScheduledFuture<?> finishPoll(RunnableScheduledFuture<?> f) {
            int s = --this.size;
            RunnableScheduledFuture<?> x = this.queue[s];
            this.queue[s] = null;
            if (s != 0) {
                this.siftDown(0, x);
            }
            this.setIndex(f, -1);
            return f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RunnableScheduledFuture<?> poll() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                RunnableScheduledFuture<?> first = this.queue[0];
                if (first == null || first.getDelay(TimeUnit.MILLISECONDS) > 0L) {
                    RunnableScheduledFuture<?> runnableScheduledFuture = null;
                    return runnableScheduledFuture;
                }
                RunnableScheduledFuture<?> runnableScheduledFuture = this.finishPoll(first);
                return runnableScheduledFuture;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public RunnableScheduledFuture<?> take() throws InterruptedException {
            lock = this.lock;
            lock.lockInterruptibly();
            block7: while (true) {
                while (true) lbl-1000:
                // 4 sources

                {
                    if ((first = this.queue[0]) == null) {
                        this.available.await();
                        continue block7;
                    }
                    delay = first.getDelay(TimeUnit.MILLISECONDS);
                    if (delay <= 0L) {
                        var5_4 = this.finishPoll(first);
                        return var5_4;
                    }
                    first = null;
                    if (this.leader != null) {
                        this.available.await();
                        continue;
                    }
                    this.leader = thisThread = Thread.currentThread();
                    try {
                        this.available.await(Math.min(this.delayCheckMillis, delay), TimeUnit.MILLISECONDS);
                    }
                    finally {
                        if (this.leader != thisThread) continue;
                        this.leader = null;
                        continue;
                    }
                    break;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (this.leader == null && this.queue[0] != null) {
                    this.available.signal();
                }
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RunnableScheduledFuture<?> poll(long timeout, TimeUnit unit) throws InterruptedException {
            long millis = unit.toMillis(timeout);
            ReentrantLock lock = this.lock;
            lock.lockInterruptibly();
            try {
                while (true) {
                    Thread thisThread;
                    RunnableScheduledFuture<?> first;
                    if ((first = this.queue[0]) == null) {
                        if (millis <= 0L) {
                            RunnableScheduledFuture<?> runnableScheduledFuture = null;
                            return runnableScheduledFuture;
                        }
                        long preMillis = DateUtil.currentTimeMillis();
                        boolean flag = this.available.await(Math.min(this.delayCheckMillis, millis), TimeUnit.MILLISECONDS);
                        millis -= DateUtil.currentTimeMillis() - preMillis;
                        if (flag) continue;
                        continue;
                    }
                    long delay = first.getDelay(TimeUnit.MILLISECONDS);
                    if (delay <= 0L) {
                        RunnableScheduledFuture<?> flag = this.finishPoll(first);
                        return flag;
                    }
                    if (millis <= 0L) {
                        RunnableScheduledFuture<?> flag = null;
                        return flag;
                    }
                    first = null;
                    this.leader = thisThread = Thread.currentThread();
                    try {
                        delay = Math.min(millis, delay);
                        delay = Math.min(this.delayCheckMillis, delay);
                        long preMillis = DateUtil.currentTimeMillis();
                        boolean flag = this.available.await(delay, TimeUnit.MILLISECONDS);
                        millis -= DateUtil.currentTimeMillis() - preMillis;
                        if (flag) continue;
                        RunnableScheduledFuture<?> runnableScheduledFuture = null;
                        return runnableScheduledFuture;
                    }
                    finally {
                        if (this.leader != thisThread) continue;
                        this.leader = null;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (this.leader == null && this.queue[0] != null) {
                    this.available.signal();
                }
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                for (int i = 0; i < this.size; ++i) {
                    RunnableScheduledFuture<?> t = this.queue[i];
                    if (t == null) continue;
                    this.queue[i] = null;
                    this.setIndex(t, -1);
                }
                this.size = 0;
            }
            finally {
                lock.unlock();
            }
        }

        private RunnableScheduledFuture<?> peekExpired() {
            RunnableScheduledFuture<?> first = this.queue[0];
            return first == null || first.getDelay(TimeUnit.MILLISECONDS) > 0L ? null : first;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int drainTo(Collection<? super Runnable> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            if (c == this) {
                throw new IllegalArgumentException();
            }
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                RunnableScheduledFuture<?> first;
                int n = 0;
                while ((first = this.peekExpired()) != null) {
                    c.add(first);
                    this.finishPoll(first);
                    ++n;
                }
                int n2 = n;
                return n2;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int drainTo(Collection<? super Runnable> c, int maxElements) {
            if (c == null) {
                throw new NullPointerException();
            }
            if (c == this) {
                throw new IllegalArgumentException();
            }
            if (maxElements <= 0) {
                return 0;
            }
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                RunnableScheduledFuture<?> first;
                int n;
                for (n = 0; n < maxElements && (first = this.peekExpired()) != null; ++n) {
                    c.add(first);
                    this.finishPoll(first);
                }
                int n2 = n;
                return n2;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public Object[] toArray() {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                Object[] objectArray = Arrays.copyOf(this.queue, this.size, Object[].class);
                return objectArray;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                if (a.length < this.size) {
                    T[] TArray = Arrays.copyOf(this.queue, this.size, a.getClass());
                    return TArray;
                }
                System.arraycopy(this.queue, 0, a, 0, this.size);
                if (a.length > this.size) {
                    a[this.size] = null;
                }
                T[] TArray = a;
                return TArray;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public Iterator<Runnable> iterator() {
            return new Itr(Arrays.copyOf(this.queue, this.size));
        }

        private class Itr
        implements Iterator<Runnable> {
            final RunnableScheduledFuture<?>[] array;
            int cursor = 0;
            int lastRet = -1;

            Itr(RunnableScheduledFuture<?>[] array) {
                this.array = array;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < this.array.length;
            }

            @Override
            public Runnable next() {
                if (this.cursor >= this.array.length) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.cursor;
                return this.array[this.cursor++];
            }

            @Override
            public void remove() {
                if (this.lastRet < 0) {
                    throw new IllegalStateException();
                }
                DelayedWorkQueue.this.remove(this.array[this.lastRet]);
                this.lastRet = -1;
            }
        }
    }

    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final long sequenceNumber;
        private long time;
        private final long period;
        RunnableScheduledFuture<V> outerTask;
        int heapIndex;

        ScheduledFutureTask(Runnable r, V result, long ns) {
            super(r, result);
            this.outerTask = this;
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Runnable r, V result, long ns, long period) {
            super(r, result);
            this.outerTask = this;
            this.time = ns;
            this.period = period;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        ScheduledFutureTask(Callable<V> callable, long ns) {
            super(callable);
            this.outerTask = this;
            this.time = ns;
            this.period = 0L;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.time - DScheduledThreadPoolExecutor.this.now(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledFutureTask) {
                ScheduledFutureTask x = (ScheduledFutureTask)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        private void setNextRunTime() {
            long p = this.period;
            this.time = p > 0L ? (this.time += p) : DScheduledThreadPoolExecutor.this.triggerTime(-p);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && DScheduledThreadPoolExecutor.this.removeOnCancel && this.heapIndex >= 0) {
                DScheduledThreadPoolExecutor.this.remove(this);
            }
            return cancelled;
        }

        @Override
        public void run() {
            boolean periodic = this.isPeriodic();
            if (!DScheduledThreadPoolExecutor.this.canRunInCurrentRunState(periodic)) {
                this.cancel(false);
            } else if (!periodic) {
                ScheduledFutureTask.super.run();
            } else if (ScheduledFutureTask.super.runAndReset()) {
                this.setNextRunTime();
                DScheduledThreadPoolExecutor.this.reExecutePeriodic(this.outerTask);
            }
        }
    }
}

