/*
 * Decompiled with CFR 0.152.
 */
package org.qiunet.utils.timer.timeout;

import java.util.concurrent.atomic.AtomicReference;
import org.qiunet.utils.async.future.DFuture;
import org.qiunet.utils.timer.timeout.TimeOutCaller;

public class TimeOutFuture {
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.INIT);
    private final TimeOutCaller caller;
    DFuture<Void> dFuture;

    TimeOutFuture(TimeOutCaller caller) {
        this.caller = caller;
    }

    public boolean cancel() {
        if (!this.compareAndSetStatus(Status.INIT, Status.CANCELED)) {
            return false;
        }
        return this.dFuture.cancel(false);
    }

    public Status status() {
        return this.status.get();
    }

    public boolean isTimeOut() {
        return this.status() == Status.TIMEOUT;
    }

    public boolean isCanceled() {
        return this.status() == Status.CANCELED;
    }

    void timeout() {
        if (!this.compareAndSetStatus(Status.INIT, Status.TIMEOUT)) {
            return;
        }
        this.caller.run(this);
    }

    private boolean compareAndSetStatus(Status expect, Status update) {
        return this.status.compareAndSet(expect, update);
    }

    public static enum Status {
        INIT,
        CANCELED,
        TIMEOUT;

    }
}

