/*
 * Decompiled with CFR 0.152.
 */
package com.java2s;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Log10BigDecimal {
    private static final int SCALE = 18;

    public static BigDecimal log10(BigDecimal b) {
        int NUM_OF_DIGITS = 20;
        MathContext mc = new MathContext(20, RoundingMode.HALF_EVEN);
        if (b.signum() <= 0) {
            throw new ArithmeticException("log of a negative number! (or zero)");
        }
        if (b.compareTo(BigDecimal.ONE) == 0) {
            return BigDecimal.ZERO;
        }
        if (b.compareTo(BigDecimal.ONE) < 0) {
            return Log10BigDecimal.log10(BigDecimal.ONE.divide(b, mc)).negate();
        }
        StringBuilder sb = new StringBuilder();
        int leftDigits = b.precision() - b.scale();
        sb.append(leftDigits - 1).append(".");
        for (int n = 0; n < 20; ++n) {
            b = b.movePointLeft(leftDigits - 1).pow(10, mc);
            leftDigits = b.precision() - b.scale();
            sb.append(leftDigits - 1);
        }
        BigDecimal ans = new BigDecimal(sb.toString());
        ans = ans.round(new MathContext(ans.precision() - ans.scale() + 18, RoundingMode.HALF_EVEN));
        return ans;
    }

    public static BigDecimal pow(BigDecimal savedValue, BigDecimal value) {
        BigDecimal result = null;
        result = Log10BigDecimal.exp(Log10BigDecimal.ln(savedValue, 32).multiply(value), 32);
        return result;
    }

    public static BigDecimal exp(BigDecimal x, int scale) {
        if (x.signum() == 0) {
            return BigDecimal.valueOf(1L);
        }
        if (x.signum() == -1) {
            return BigDecimal.valueOf(1L).divide(Log10BigDecimal.exp(x.negate(), scale), scale, 6);
        }
        BigDecimal xWhole = x.setScale(0, 1);
        if (xWhole.signum() == 0) {
            return Log10BigDecimal.expTaylor(x, scale);
        }
        BigDecimal xFraction = x.subtract(xWhole);
        BigDecimal z = BigDecimal.valueOf(1L).add(xFraction.divide(xWhole, scale, 6));
        BigDecimal t = Log10BigDecimal.expTaylor(z, scale);
        BigDecimal maxLong = BigDecimal.valueOf(Long.MAX_VALUE);
        BigDecimal result = BigDecimal.valueOf(1L);
        while (xWhole.compareTo(maxLong) >= 0) {
            result = result.multiply(Log10BigDecimal.intPower(t, Long.MAX_VALUE, scale)).setScale(scale, 6);
            xWhole = xWhole.subtract(maxLong);
            Thread.yield();
        }
        return result.multiply(Log10BigDecimal.intPower(t, xWhole.longValue(), scale)).setScale(scale, 6);
    }

    public static BigDecimal ln(BigDecimal x, int scale) {
        if (x.signum() <= 0) {
            throw new IllegalArgumentException("x <= 0");
        }
        int magnitude = x.toString().length() - x.scale() - 1;
        if (magnitude < 3) {
            return Log10BigDecimal.lnNewton(x, scale);
        }
        BigDecimal root = Log10BigDecimal.intRoot(x, magnitude, scale);
        BigDecimal lnRoot = Log10BigDecimal.lnNewton(root, scale);
        return BigDecimal.valueOf(magnitude).multiply(lnRoot).setScale(scale, 6);
    }

    private static BigDecimal expTaylor(BigDecimal x, int scale) {
        BigDecimal sumPrev;
        BigDecimal factorial = BigDecimal.valueOf(1L);
        BigDecimal xPower = x;
        BigDecimal sum = x.add(BigDecimal.valueOf(1L));
        int i = 2;
        do {
            xPower = xPower.multiply(x).setScale(scale, 6);
            factorial = factorial.multiply(BigDecimal.valueOf(i));
            BigDecimal term = xPower.divide(factorial, scale, 6);
            sumPrev = sum;
            sum = sum.add(term);
            ++i;
            Thread.yield();
        } while (sum.compareTo(sumPrev) != 0);
        return sum;
    }

    public static BigDecimal intPower(BigDecimal x, long exponent, int scale) {
        if (exponent < 0L) {
            return BigDecimal.valueOf(1L).divide(Log10BigDecimal.intPower(x, -exponent, scale), scale, 6);
        }
        BigDecimal power = BigDecimal.valueOf(1L);
        while (exponent > 0L) {
            if ((exponent & 1L) == 1L) {
                power = power.multiply(x).setScale(scale, 6);
            }
            x = x.multiply(x).setScale(scale, 6);
            exponent >>= 1;
            Thread.yield();
        }
        return power;
    }

    private static BigDecimal lnNewton(BigDecimal x, int scale) {
        BigDecimal term;
        int sp1 = scale + 1;
        BigDecimal n = x;
        BigDecimal tolerance = BigDecimal.valueOf(5L).movePointLeft(sp1);
        do {
            BigDecimal eToX = Log10BigDecimal.exp(x, sp1);
            term = eToX.subtract(n).divide(eToX, sp1, 1);
            x = x.subtract(term);
            Thread.yield();
        } while (term.compareTo(tolerance) > 0);
        return x.setScale(scale, 6);
    }

    public static BigDecimal intRoot(BigDecimal x, long index, int scale) {
        BigDecimal xPrev;
        if (x.signum() < 0) {
            throw new IllegalArgumentException("x < 0");
        }
        int sp1 = scale + 1;
        BigDecimal n = x;
        BigDecimal i = BigDecimal.valueOf(index);
        BigDecimal im1 = BigDecimal.valueOf(index - 1L);
        BigDecimal tolerance = BigDecimal.valueOf(5L).movePointLeft(sp1);
        x = x.divide(i, scale, 6);
        do {
            BigDecimal xToIm1 = Log10BigDecimal.intPower(x, index - 1L, sp1);
            BigDecimal xToI = x.multiply(xToIm1).setScale(sp1, 6);
            BigDecimal numerator = n.add(im1.multiply(xToI)).setScale(sp1, 6);
            BigDecimal denominator = i.multiply(xToIm1).setScale(sp1, 6);
            xPrev = x;
            x = numerator.divide(denominator, sp1, 1);
            Thread.yield();
        } while (x.subtract(xPrev).abs().compareTo(tolerance) > 0);
        return x;
    }
}

