/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib;

import com.java2s.Log10BigDecimal;
import io.github.qudtlib.algorithm.AssignmentProblem;
import io.github.qudtlib.exception.InconvertibleQuantitiesException;
import io.github.qudtlib.exception.NotFoundException;
import io.github.qudtlib.init.Initializer;
import io.github.qudtlib.model.DerivedUnitSearchMode;
import io.github.qudtlib.model.FactorUnit;
import io.github.qudtlib.model.FactorUnits;
import io.github.qudtlib.model.LangString;
import io.github.qudtlib.model.Prefix;
import io.github.qudtlib.model.QuantityKind;
import io.github.qudtlib.model.QuantityValue;
import io.github.qudtlib.model.QudtNamespaces;
import io.github.qudtlib.model.SystemOfUnits;
import io.github.qudtlib.model.Unit;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Qudt {
    private static final Map<String, Unit> units;
    private static final Map<String, QuantityKind> quantityKinds;
    private static final Map<String, Prefix> prefixes;
    private static final Map<String, SystemOfUnits> systemsOfUnits;
    private static final BigDecimal BD_1000;

    public static Optional<Unit> unitFromLocalname(String localname) {
        return Qudt.unit(Qudt.unitIriFromLocalname(localname));
    }

    public static Unit unitFromLocalnameRequired(String localname) {
        return Qudt.unitRequired(Qudt.unitIriFromLocalname(localname));
    }

    public static Optional<Unit> unitFromLabel(String label) {
        LabelMatcher labelMatcher = new LabelMatcher(label);
        return units.values().stream().filter(u -> u.getLabels().stream().anyMatch(labelMatcher::matches)).findFirst();
    }

    public static Unit unitFromLabelRequired(String label) {
        return Qudt.unitFromLabel(label).orElseThrow(() -> new NotFoundException("No unit found for label '" + label + "'"));
    }

    public static Optional<Unit> unit(String iri) {
        return Optional.ofNullable(units.get(iri));
    }

    public static Unit unitRequired(String iri) {
        return Optional.ofNullable(units.get(iri)).orElseThrow(() -> new NotFoundException("No unit found for Iri " + iri));
    }

    public static String unitIriFromLocalname(String localname) {
        return NAMESPACES.unit.makeIriInNamespace(localname);
    }

    public static Unit scale(String prefixLabel, String baseUnitLabel) {
        LabelMatcher labelMatcher = new LabelMatcher(baseUnitLabel);
        return units.values().stream().filter(u -> u.getPrefix().isPresent()).filter(u -> ((Prefix)u.getPrefix().get()).getLabels().stream().anyMatch(pl -> pl.getString().equalsIgnoreCase(prefixLabel))).filter(u -> u.getScalingOf().isPresent()).filter(u -> ((Unit)u.getScalingOf().get()).getLabels().stream().anyMatch(labelMatcher::matches)).findFirst().orElseThrow(() -> new NotFoundException(String.format("No scaled unit found with base unit '%s' and prefix '%s'", baseUnitLabel, prefixLabel)));
    }

    public static Unit scale(Prefix prefix, Unit baseUnit) {
        return units.values().stream().filter(u -> u.getPrefix().isPresent()).filter(u -> ((Prefix)u.getPrefix().get()).equals((Object)prefix)).filter(u -> u.getScalingOf().isPresent()).filter(u -> ((Unit)u.getScalingOf().get()).equals((Object)baseUnit)).findFirst().orElseThrow(() -> new NotFoundException(String.format("No scaled unit found with base unit '%s' and prefix '%s'", baseUnit, prefix)));
    }

    public static Unit unscale(Unit unit) {
        if (unit.getScalingOf().isEmpty()) {
            return unit;
        }
        return (Unit)unit.getScalingOf().get();
    }

    public static List<FactorUnit> factorUnits(Unit unit) {
        return Qudt.simplifyFactorUnits(unit.getLeafFactorUnitsWithCumulativeExponents());
    }

    public static List<FactorUnit> simplifyFactorUnits(List<FactorUnit> factorUnits) {
        return new ArrayList<FactorUnit>(factorUnits.stream().collect(Collectors.toMap(FactorUnit::getKind, Function.identity(), FactorUnit::combine)).values());
    }

    public static List<FactorUnit> unscale(List<FactorUnit> factorUnits) {
        return factorUnits.stream().map(uf -> (FactorUnit)FactorUnit.builder().unit(Qudt.unscale(uf.getUnit())).exponent(uf.getExponent()).build()).collect(Collectors.toList());
    }

    public static Set<Unit> derivedUnitsFromMap(DerivedUnitSearchMode searchMode, Map<Unit, Integer> factorUnits) {
        Object[] arr = new Object[factorUnits.size() * 2];
        return Qudt.derivedUnitsFromUnitExponentPairs(searchMode, factorUnits.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).collect(Collectors.toList()).toArray(arr));
    }

    public static Set<Unit> derivedUnitsFromFactorUnits(DerivedUnitSearchMode searchMode, List<FactorUnit> factorUnits) {
        FactorUnits selection = new FactorUnits(factorUnits);
        return Qudt.derivedUnitsFromFactorUnits(searchMode, selection);
    }

    public static Set<Unit> derivedUnitsFromUnitExponentPairs(DerivedUnitSearchMode searchMode, Object ... factorUnitSpec) {
        Object[] spec = new Object[factorUnitSpec.length];
        for (int i = 0; i < factorUnitSpec.length; ++i) {
            if (i % 2 == 0 && factorUnitSpec[i] instanceof Unit) {
                spec[i] = factorUnitSpec[i];
                continue;
            }
            if (i % 2 == 0 && factorUnitSpec[i] instanceof String) {
                String unitString = (String)factorUnitSpec[i];
                Optional<Unit> unitOpt = Qudt.unit(unitString);
                if (unitOpt.isEmpty()) {
                    unitOpt = Qudt.unitFromLocalname(unitString);
                }
                if (unitOpt.isEmpty()) {
                    unitOpt = Qudt.unitFromLabel(unitString);
                }
                if (unitOpt.isEmpty()) {
                    throw new NotFoundException(String.format("Unable to find unit for string %s, interpreted as iri, label, or localname", unitString));
                }
                spec[i] = unitOpt.get();
                continue;
            }
            if (i % 2 == 1 && factorUnitSpec[i] instanceof Integer) {
                spec[i] = factorUnitSpec[i];
                continue;
            }
            throw new IllegalArgumentException(String.format("Cannot handle input '%s' at 0-base position %d", factorUnitSpec[i].toString(), i));
        }
        FactorUnits selection = FactorUnits.ofFactorUnitSpec((Object[])spec);
        return Qudt.derivedUnitsFromFactorUnits(searchMode, selection);
    }

    private static Set<Unit> derivedUnitsFromFactorUnits(DerivedUnitSearchMode searchMode, FactorUnits selection) {
        List matchingUnits = units.values().stream().filter(d -> d.matches(selection)).collect(Collectors.toList());
        if (searchMode == DerivedUnitSearchMode.ALL || matchingUnits.size() < 2) {
            return new HashSet<Unit>(matchingUnits);
        }
        HashMap<Unit, Double> scores = new HashMap<Unit, Double>();
        for (Unit unit : matchingUnits) {
            scores.put(unit, Qudt.matchScore(unit, selection));
        }
        return Set.of((Unit)matchingUnits.stream().max((l, r) -> (int)Math.signum((Double)scores.get(l) - (Double)scores.get(r))).get());
    }

    private static Double matchScore(Unit unit, FactorUnits requested) {
        List unitFactors = unit.getAllPossibleFactorUnitCombinations();
        List requestedFactors = FactorUnit.getAllPossibleFactorUnitCombinations((List)requested.getFactorUnits());
        List smaller = unitFactors.size() > requestedFactors.size() ? requestedFactors : unitFactors;
        List larger = unitFactors.size() > requestedFactors.size() ? unitFactors : requestedFactors;
        double[][] unitSimilarityMatrix = Qudt.getUnitSimilarityMatrix(smaller, larger);
        double overlapScore = 0.0;
        if (unitSimilarityMatrix.length > 0) {
            overlapScore = Qudt.getOverlapScore(unitSimilarityMatrix);
        }
        String unitLocalName = Qudt.getIriLocalName(unit.getIri());
        int tieBreaker = requested.getFactorUnits().stream().reduce(0, (prev, cur) -> prev + (unitLocalName.matches(".*\\b" + Qudt.getIriLocalName(cur.getUnit().getIri()) + "\\b.*") || unitLocalName.matches(".*\\b" + Qudt.getIriLocalName(cur.getUnit().getIri()) + Math.abs(cur.getExponent()) + "\\b.*") ? 1 : 0), (l, r) -> l + r);
        return overlapScore + (double)tieBreaker / Math.pow(unitFactors.size() + requestedFactors.size() + 1, 2.0);
    }

    private static double getOverlapScore(double[][] mat) {
        int numAssignments = mat.length;
        int rowsPlusCols = mat.length + mat[0].length;
        double minAssignmentScore = AssignmentProblem.instance((double[][])mat).solve().getWeight();
        double overlap = (double)numAssignments * (1.0 - minAssignmentScore / (double)numAssignments);
        return overlap / ((double)rowsPlusCols - overlap);
    }

    static double[][] getUnitSimilarityMatrix(List<List<FactorUnit>> rows, List<List<FactorUnit>> cols) {
        return (double[][])rows.stream().map(rowCombination -> cols.stream().map(colCombination -> Qudt.scoreCombinations(rowCombination, colCombination)).mapToDouble(d -> d).toArray()).collect(Collectors.toList()).toArray((T[])new double[0][0]);
    }

    private static double scoreCombinations(List<FactorUnit> leftFactors, List<FactorUnit> rightFactors) {
        List<FactorUnit> smaller = leftFactors.size() > rightFactors.size() ? rightFactors : leftFactors;
        List<FactorUnit> larger = leftFactors.size() > rightFactors.size() ? leftFactors : rightFactors;
        double[][] similarityMatrix = (double[][])smaller.stream().map(sFactor -> larger.stream().map(lFactor -> {
            Unit unitScaledOrSelf;
            if (sFactor.equals(lFactor)) {
                return 0.0;
            }
            Unit reqScaledOrSelf = sFactor.getUnit().getScalingOf().orElse(sFactor.getUnit());
            if (reqScaledOrSelf.equals((Object)(unitScaledOrSelf = lFactor.getUnit().getScalingOf().orElse(lFactor.getUnit()))) && sFactor.getExponent() == lFactor.getExponent()) {
                return 0.6;
            }
            if (sFactor.getUnit().equals((Object)lFactor.getUnit())) {
                return 0.8;
            }
            if (reqScaledOrSelf.equals((Object)unitScaledOrSelf)) {
                return 0.9;
            }
            return 1.0;
        }).mapToDouble(d -> d).toArray()).collect(Collectors.toList()).toArray((T[])new double[0][0]);
        if (similarityMatrix.length == 0) {
            return 1.0;
        }
        return 1.0 - Qudt.getOverlapScore(similarityMatrix);
    }

    private static String getIriLocalName(String iri) {
        return iri.replaceAll("^.+[/|#]", "");
    }

    public static Map.Entry<Unit, BigDecimal> scaleToBaseUnit(Unit unit) {
        if (!unit.isScaled()) {
            return Map.entry(unit, BigDecimal.ONE);
        }
        Unit baseUnit = (Unit)unit.getScalingOf().orElseThrow(() -> new IllegalStateException("Scaled unit has null isScalingOf() unit - that's a bug!"));
        BigDecimal multiplier = unit.getConversionMultiplier(baseUnit);
        return Map.entry(baseUnit, multiplier);
    }

    public static Optional<QuantityKind> quantityKindFromLocalname(String localname) {
        return Qudt.quantityKind(Qudt.quantityKindIriFromLocalname(localname));
    }

    public static QuantityKind quantityKindFromLocalnameRequired(String localname) {
        return Qudt.quantityKindRequired(Qudt.quantityKindIriFromLocalname(localname));
    }

    public static Optional<QuantityKind> quantityKind(String iri) {
        return Optional.ofNullable(quantityKinds.get(iri));
    }

    public static QuantityKind quantityKindRequired(String iri) {
        return Qudt.quantityKind(iri).orElseThrow(() -> new NotFoundException("QuantityKind not found: " + iri));
    }

    public static Set<QuantityKind> quantityKinds(Unit unit) {
        return unit.getQuantityKinds().stream().collect(Collectors.toUnmodifiableSet());
    }

    public static Set<QuantityKind> quantityKindsBroad(Unit unit) {
        Set<Object> current = Qudt.quantityKinds(unit);
        HashSet<QuantityKind> result = new HashSet<QuantityKind>(current);
        while (!current.isEmpty()) {
            current = current.stream().flatMap(qk -> qk.getBroaderQuantityKinds().stream()).collect(Collectors.toSet());
            result.addAll(current);
        }
        return result;
    }

    public static String quantityKindIriFromLocalname(String localname) {
        return NAMESPACES.quantityKind.makeIriInNamespace(localname);
    }

    public static String prefixIriFromLocalname(String localname) {
        return NAMESPACES.prefix.makeIriInNamespace(localname);
    }

    public static Prefix prefixFromLocalnameRequired(String localname) {
        return Qudt.prefixRequired(Qudt.prefixIriFromLocalname(localname));
    }

    public static Optional<Prefix> prefixFromLocalname(String localname) {
        return Qudt.prefix(Qudt.prefixIriFromLocalname(localname));
    }

    public static Optional<Prefix> prefix(String iri) {
        return Optional.ofNullable(prefixes.get(iri));
    }

    public static Prefix prefixRequired(String iri) {
        return Qudt.prefix(iri).orElseThrow(() -> new NotFoundException("Prefix not found: " + iri));
    }

    public static Optional<SystemOfUnits> systemOfUnitsFromLocalname(String localname) {
        return Qudt.systemOfUnits(Qudt.systemOfUnitsIriFromLocalname(localname));
    }

    public static SystemOfUnits systemOfUnitsFromLocalnameRequired(String localname) {
        return Qudt.systemOfUnitsRequired(Qudt.systemOfUnitsIriFromLocalname(localname));
    }

    public static Optional<SystemOfUnits> systemOfUnitsFromLabel(String label) {
        LabelMatcher labelMatcher = new LabelMatcher(label);
        return systemsOfUnits.values().stream().filter(u -> u.getLabels().stream().anyMatch(labelMatcher::matches)).findFirst();
    }

    public static SystemOfUnits systemOfUnitsFromLabelRequired(String label) {
        return Qudt.systemOfUnitsFromLabel(label).orElseThrow(() -> new NotFoundException("No systemOfUnits found for label '" + label + "'"));
    }

    public static Optional<SystemOfUnits> systemOfUnits(String iri) {
        return Optional.ofNullable(systemsOfUnits.get(iri));
    }

    public static SystemOfUnits systemOfUnitsRequired(String iri) {
        return Optional.ofNullable(systemsOfUnits.get(iri)).orElseThrow(() -> new NotFoundException("No systemOfUnits found for Iri " + iri));
    }

    public static String systemOfUnitsIriFromLocalname(String localname) {
        return NAMESPACES.systemOfUnits.makeIriInNamespace(localname);
    }

    public static QuantityValue quantityValue(BigDecimal value, String unitIri) {
        return new QuantityValue(value, Qudt.unitRequired(unitIri));
    }

    public static QuantityValue quantityValue(BigDecimal value, Unit unit) {
        return new QuantityValue(value, unit);
    }

    public static QuantityValue convert(QuantityValue from, Unit toUnit) throws InconvertibleQuantitiesException {
        return from.convert(toUnit);
    }

    public static QuantityValue convert(QuantityValue from, String toUnitIri) throws InconvertibleQuantitiesException, NotFoundException {
        Unit toUnit = Qudt.unitRequired(toUnitIri);
        return Qudt.quantityValue(Qudt.convert(from.getValue(), from.getUnit(), toUnit), toUnit);
    }

    public static BigDecimal convert(BigDecimal fromValue, String fromUnitIri, String toUnitIri) throws InconvertibleQuantitiesException, NotFoundException {
        return Qudt.convert(fromValue, Qudt.unitRequired(fromUnitIri), Qudt.unitRequired(toUnitIri));
    }

    public static BigDecimal convert(BigDecimal fromValue, Unit fromUnit, Unit toUnit) throws InconvertibleQuantitiesException {
        return fromUnit.convert(fromValue, toUnit);
    }

    public static boolean isConvertible(Unit fromUnit, Unit toUnit) {
        return fromUnit.isConvertible(toUnit);
    }

    public static String getGreeting() {
        return "This is QUDTLib-Java (https://github.com/qudtlib/qudtlib.java)\nbased on the QUDT ontology (https://qudt.org/)\nhappily providing\n\t" + units.size() + " units\n\t" + quantityKinds.size() + " quantityKinds\n\t" + prefixes.size() + " prefixes\n";
    }

    static Map<String, Prefix> getPrefixesMap() {
        return Collections.unmodifiableMap(prefixes);
    }

    static Map<String, QuantityKind> getQuantityKindsMap() {
        return Collections.unmodifiableMap(quantityKinds);
    }

    static Map<String, Unit> getUnitsMap() {
        return Collections.unmodifiableMap(units);
    }

    static Map<String, SystemOfUnits> getSystemsOfUnitsMap() {
        return Collections.unmodifiableMap(systemsOfUnits);
    }

    public static Collection<Unit> allUnits() {
        return Collections.unmodifiableCollection(units.values());
    }

    public static Collection<QuantityKind> allQuantityKinds() {
        return Collections.unmodifiableCollection(quantityKinds.values());
    }

    public static Collection<Prefix> allPrefixes() {
        return Collections.unmodifiableCollection(prefixes.values());
    }

    public static Collection<SystemOfUnits> allSystemsOfUnits() {
        return Collections.unmodifiableCollection(systemsOfUnits.values());
    }

    public static Collection<Unit> allUnitsOfSystem(SystemOfUnits system) {
        return units.values().stream().filter(arg_0 -> ((SystemOfUnits)system).allowsUnit(arg_0)).collect(Collectors.toUnmodifiableSet());
    }

    public static Optional<Unit> correspondingUnitInSystem(Unit unit, SystemOfUnits systemOfUnits) {
        return Qudt.correspondingUnitsInSystem(unit, systemOfUnits).stream().findFirst();
    }

    public static List<Unit> correspondingUnitsInSystem(Unit unit, SystemOfUnits systemOfUnits) {
        if (systemOfUnits.allowsUnit(unit)) {
            return List.of(unit);
        }
        List<Unit> elegible = Qudt.getUnitsMap().values().stream().filter(u -> systemOfUnits.allowsUnit(u)).filter(u -> u.getDimensionVectorIri().equals(unit.getDimensionVectorIri())).collect(Collectors.toList());
        if (elegible.size() == 1) {
            return elegible;
        }
        ArrayList<Unit> candidates = new ArrayList<Unit>(elegible);
        candidates = new ArrayList<Unit>(elegible);
        candidates.removeIf(u -> !u.getQuantityKinds().stream().anyMatch(q -> unit.getQuantityKinds().contains(q)));
        if (candidates.size() == 1) {
            return candidates;
        }
        candidates.sort((l, r) -> {
            double offsetDiffR;
            double scaleDiffR;
            double scaleDiffL = Math.abs(Qudt.scaleDifference(l, unit));
            double diff = Math.signum(scaleDiffL - (scaleDiffR = Math.abs(Qudt.scaleDifference(r, unit))));
            if (diff != 0.0) {
                return (int)diff;
            }
            int cmp = Boolean.compare(systemOfUnits.hasBaseUnit(r), systemOfUnits.hasBaseUnit(l));
            if (cmp != 0) {
                return cmp;
            }
            double offsetDiffL = Math.abs(Qudt.offsetDifference(l, unit));
            cmp = (int)Math.signum(offsetDiffL - (offsetDiffR = Math.abs(Qudt.offsetDifference(r, unit))));
            if (cmp != 0) {
                return cmp;
            }
            cmp = Boolean.compare(l.isScaled(), r.isScaled());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Boolean.compare(r.getSymbol().isPresent(), l.getSymbol().isPresent());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(l.getQuantityKinds().size(), r.getQuantityKinds().size());
            if (cmp != 0) {
                return cmp;
            }
            return l.getIri().compareTo(r.getIri());
        });
        return candidates;
    }

    private static double scaleDifference(Unit u1, Unit u2) {
        BigDecimal u1Log10 = Log10BigDecimal.log10((BigDecimal)u1.getConversionMultiplier().get());
        BigDecimal u2Log10 = Log10BigDecimal.log10((BigDecimal)u2.getConversionMultiplier().get());
        return u1Log10.doubleValue() - u2Log10.doubleValue();
    }

    private static double offsetDifference(Unit u1, Unit u2) {
        BigDecimal u2Log10;
        BigDecimal u1Log10 = ((BigDecimal)u1.getConversionOffset().get()).abs();
        if (u1Log10.compareTo(BigDecimal.ZERO) > 0) {
            u1Log10 = Log10BigDecimal.log10(u1Log10);
        }
        if ((u2Log10 = ((BigDecimal)u2.getConversionOffset().get()).abs()).compareTo(BigDecimal.ZERO) > 0) {
            u2Log10 = Log10BigDecimal.log10(u2Log10);
        }
        return u1Log10.doubleValue() - u2Log10.doubleValue();
    }

    static {
        BD_1000 = new BigDecimal("1000");
        Initializer initializer = null;
        try {
            Class<?> type = Class.forName("io.github.qudtlib.init.InitializerImpl");
            initializer = (Initializer)type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot initialize QUDTlib\n\nMake sure you have either \n\n\tqudtlib-init-rdf \nor \n\n\tqudtlib-init-hardcoded \n\non your classpath!", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot initialize QUDTlib - No zero-arg constructor found in InitializerImpl", e);
        }
        if (initializer != null) {
            Initializer.Definitions definitions = initializer.loadData();
            prefixes = initializer.buildPrefixes(definitions);
            units = initializer.buildUnits(definitions);
            quantityKinds = initializer.buildQuantityKinds(definitions);
            systemsOfUnits = initializer.buildSystemsOfUnits(definitions);
        } else {
            prefixes = new HashMap<String, Prefix>();
            units = new HashMap<String, Unit>();
            quantityKinds = new HashMap<String, QuantityKind>();
            systemsOfUnits = new HashMap<String, SystemOfUnits>();
            System.err.println("\n\n\n ERROR: The QUDTlib data model has not been initialized properly and will not work\n\n\n");
        }
    }

    private static class LabelMatcher {
        private final String labelToMatch;

        public LabelMatcher(String labelToMatch) {
            this.labelToMatch = labelToMatch.replaceAll("_", " ").toUpperCase(Locale.US);
        }

        public boolean matches(LangString candidateLabel) {
            return this.matches(candidateLabel.getString());
        }

        public boolean matches(String candiateLabel) {
            return candiateLabel.toUpperCase(Locale.US).equals(this.labelToMatch);
        }
    }

    public static abstract class SystemsOfUnits
    extends io.github.qudtlib.model.SystemsOfUnits {
    }

    public static abstract class Prefixes
    extends io.github.qudtlib.model.Prefixes {
    }

    public static abstract class QuantityKinds
    extends io.github.qudtlib.model.QuantityKinds {
    }

    public static abstract class Units
    extends io.github.qudtlib.model.Units {
    }

    public static abstract class NAMESPACES
    extends QudtNamespaces {
    }
}

