/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.algorithm;

import java.util.Arrays;
import java.util.stream.DoubleStream;

public class AssignmentProblem {
    public static Instance instance(double[][] weights) {
        int rows = weights.length;
        if (rows == 0) {
            throw new IllegalArgumentException("Cannot create instance with 0x0 weights matrix");
        }
        int cols = weights[0].length;
        if (rows > cols) {
            throw new IllegalArgumentException("The weights matrix may not have more rows than columns");
        }
        return new NaiveAlgorithmInstance(AssignmentProblem.copy(weights));
    }

    private static double[][] copy(double[][] weights) {
        int rows = weights.length;
        int cols = weights[0].length;
        double[][] ret = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(weights[i], 0, ret[i], 0, cols);
        }
        return ret;
    }

    private static double[][] flipMatrix(double[][] mat) {
        int rows = mat.length;
        int cols = mat[0].length;
        double[][] ret = new double[cols][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                ret[j][i] = mat[i][j];
            }
        }
        return ret;
    }

    private static int[] append(int[] arr, int val) {
        int[] ret = new int[arr.length + 1];
        System.arraycopy(arr, 0, ret, 0, arr.length);
        ret[ret.length - 1] = val;
        return ret;
    }

    private static ValueWithIndex[] rowSortedAscending(double[][] weights, int row, int[] skipCols) {
        int cols = weights[row].length;
        ValueWithIndex[] sorted = new ValueWithIndex[cols - skipCols.length];
        int j = 0;
        for (int i = 0; i < cols; ++i) {
            if (AssignmentProblem.containsValue(skipCols, i)) continue;
            sorted[j++] = new ValueWithIndex(weights[row][i], i);
        }
        Arrays.sort(sorted, (left, right) -> (int)Math.signum(left.value - right.value));
        return sorted;
    }

    private static ValueWithIndex[] rowNMin(double[][] mat, int row, int n, int[] skipCols) {
        ValueWithIndex[] nMin = new ValueWithIndex[n];
        for (int i = 0; i < mat[0].length; ++i) {
            if (AssignmentProblem.containsValue(skipCols, i)) continue;
            AssignmentProblem.replaceIfLower(nMin, mat[row][i], i);
        }
        Arrays.sort(nMin, (left, right) -> (int)Math.signum(left.value - right.value));
        return nMin;
    }

    private static boolean containsValue(int[] arr, int val) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != val) continue;
            return true;
        }
        return false;
    }

    private static void replaceIfLower(ValueWithIndex[] nMin, double value, int index) {
        int maxValueIndex = -1;
        double maxValue = -1.7976931348623157E308;
        for (int i = 0; i < nMin.length; ++i) {
            if (nMin[i] == null) {
                nMin[i] = new ValueWithIndex(value, index);
                return;
            }
            if (!(nMin[i].value > maxValue)) continue;
            maxValue = nMin[i].value;
            maxValueIndex = i;
        }
        if (maxValue > value) {
            nMin[maxValueIndex] = new ValueWithIndex(value, index);
        }
    }

    private static ValueWithIndex rowMax(double[][] mat, int row, int[] skipCols) {
        if (skipCols == null) {
            skipCols = new int[]{-1};
        }
        Arrays.sort(skipCols);
        double max = -1.7976931348623157E308;
        int index = -1;
        int cols = mat[0].length;
        for (int i = 0; i < cols; ++i) {
            double cur;
            if (Arrays.binarySearch(skipCols, i) > -1 || !((cur = mat[row][i]) > max)) continue;
            index = i;
            max = cur;
        }
        return new ValueWithIndex(max, index);
    }

    private static ValueWithIndex colMax(double[][] mat, int col, int[] skipRows) {
        if (skipRows == null) {
            skipRows = new int[]{-1};
        }
        Arrays.sort(skipRows);
        double max = -1.7976931348623157E308;
        int index = -1;
        int rows = mat.length;
        for (int i = 0; i < rows; ++i) {
            double cur;
            if (Arrays.binarySearch(skipRows, i) > -1 || !((cur = mat[i][col]) > max)) continue;
            index = i;
            max = cur;
        }
        return new ValueWithIndex(max, index);
    }

    private static double[][] copyWithoutCol(double[][] mat, int col) {
        int rows = mat.length;
        int cols = mat[0].length;
        double[][] ret = new double[rows][cols - 1];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols - 1; ++c) {
                int readCol = c >= col ? c + 1 : c;
                ret[r][c] = mat[r][readCol];
            }
        }
        return ret;
    }

    private static class ValueWithIndex {
        private final int index;
        private final double value;

        public ValueWithIndex(double value, int index) {
            this.index = index;
            this.value = value;
        }
    }

    public static class Solution {
        private final int[] assignment;
        private final Double weight;
        private final Instance instance;

        public Solution(Instance instance) {
            this(instance, new int[0]);
        }

        public Solution(Instance instance, int[] assignment) {
            this.assignment = assignment;
            this.instance = instance;
            this.weight = instance.weightOfAssignment(assignment);
        }

        public int[] getAssignment() {
            return this.assignment;
        }

        public Double getWeight() {
            return this.weight;
        }

        public Solution assignColumnInNextRow(int col) {
            if (this.isComplete()) {
                throw new IllegalStateException("Solution is already complete");
            }
            return new Solution(this.instance, AssignmentProblem.append(this.assignment, col));
        }

        private boolean isComplete() {
            return this.assignment.length >= this.instance.rows;
        }

        public boolean isEmpty() {
            return this.assignment == null || this.assignment.length == 0;
        }

        public boolean isBetterSolutionThan(Solution other) {
            if (!this.isComplete() || !other.isComplete()) {
                throw new IllegalStateException("Cannot compare incomplete solutions");
            }
            return this.weight < other.weight;
        }
    }

    public static class NaiveAlgorithmInstance
    extends Instance {
        private Solution currentBestSolution;

        public NaiveAlgorithmInstance(double[][] weights) {
            super(weights);
        }

        public boolean isLowerThanBestWeight(double weightToTest) {
            if (this.currentBestSolution == null) {
                return true;
            }
            if (!this.currentBestSolution.isComplete()) {
                return true;
            }
            return this.currentBestSolution.weight > weightToTest;
        }

        public void updateBestSolutionIfPossible(Solution candidate) {
            if (this.currentBestSolution == null || candidate.isBetterSolutionThan(this.currentBestSolution)) {
                this.currentBestSolution = candidate;
            }
        }

        @Override
        public Solution solve() {
            this.solve(0, new Solution(this));
            return this.currentBestSolution;
        }

        private void solve(int row, Solution solution) {
            if (row >= this.rows) {
                this.updateBestSolutionIfPossible(solution);
                return;
            }
            if (!solution.isEmpty()) {
                double bestAttainableScore = this.sum(this.minPerRow(row, solution.assignment));
                if (!this.isLowerThanBestWeight(solution.weight + bestAttainableScore)) {
                    return;
                }
            }
            ValueWithIndex[] nMin = AssignmentProblem.rowSortedAscending(this.weights, row, solution.getAssignment());
            for (int i = 0; i < nMin.length; ++i) {
                if (!solution.isEmpty() && !this.isLowerThanBestWeight(solution.getWeight() + nMin[i].value)) continue;
                this.solve(row + 1, solution.assignColumnInNextRow(nMin[i].index));
            }
        }

        private double[] minPerRow(int startRow, int[] skipCols) {
            double[] ret = new double[this.weights.length - startRow];
            for (int r = startRow; r < this.weights.length; ++r) {
                double min = Double.MAX_VALUE;
                for (int c = 0; c < this.weights[r].length; ++c) {
                    if (AssignmentProblem.containsValue(skipCols, c) || !(min > this.weights[r][c])) continue;
                    min = this.weights[r][c];
                }
                ret[r - startRow] = min;
            }
            return ret;
        }

        private double sum(double[] arr) {
            return DoubleStream.of(arr).sum();
        }
    }

    public static abstract class Instance {
        protected final double[][] weights;
        protected final int rows;
        protected final int cols;

        public Instance(double[][] weights) {
            this.weights = weights;
            this.rows = weights.length;
            this.cols = weights[0].length;
        }

        public double[][] getWeights() {
            return this.weights;
        }

        public Double weightOfAssignment(int[] selection) {
            if (selection == null || selection.length == 0) {
                return null;
            }
            double sum = 0.0;
            for (int i = 0; i < selection.length; ++i) {
                sum += this.weights[i][selection[i]];
            }
            return sum;
        }

        public abstract Solution solve();
    }
}

