/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.init;

import io.github.qudtlib.exception.NotFoundException;
import io.github.qudtlib.model.Prefix;
import io.github.qudtlib.model.QuantityKind;
import io.github.qudtlib.model.SystemOfUnits;
import io.github.qudtlib.model.Unit;
import io.github.qudtlib.nodedef.MapBackedNodeDefinition;
import io.github.qudtlib.nodedef.NodeDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public interface Initializer {
    public Definitions loadData();

    default public Map<String, Unit> buildUnits(Definitions definitions) {
        return Collections.unmodifiableMap(definitions.unitDefinitions.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Unit)((Unit.Definition)e.getValue()).build())));
    }

    default public Map<String, QuantityKind> buildQuantityKinds(Definitions definitions) {
        return Collections.unmodifiableMap(definitions.quantityKindDefinitions.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (QuantityKind)((QuantityKind.Definition)e.getValue()).build())));
    }

    default public Map<String, Prefix> buildPrefixes(Definitions definitions) {
        return Collections.unmodifiableMap(definitions.prefixDefinitions.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Prefix)((Prefix.Definition)e.getValue()).build())));
    }

    default public Map<String, SystemOfUnits> buildSystemsOfUnits(Definitions definitions) {
        return Collections.unmodifiableMap(definitions.systemOfUnitsDefinitions.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (SystemOfUnits)((SystemOfUnits.Definition)e.getValue()).build())));
    }

    public static class Definitions {
        private Map<String, Unit.Definition> unitDefinitions;
        private Map<String, Prefix.Definition> prefixDefinitions = new HashMap<String, Prefix.Definition>();
        private Map<String, QuantityKind.Definition> quantityKindDefinitions;
        private Map<String, SystemOfUnits.Definition> systemOfUnitsDefinitions;

        public Definitions() {
            this.unitDefinitions = new HashMap<String, Unit.Definition>();
            this.quantityKindDefinitions = new HashMap<String, QuantityKind.Definition>();
            this.systemOfUnitsDefinitions = new HashMap<String, SystemOfUnits.Definition>();
        }

        public void addUnitDefinition(Unit.Definition definition) {
            this.unitDefinitions.put((String)definition.getId(), definition);
        }

        public void addQuantityKindDefinition(QuantityKind.Definition definition) {
            this.quantityKindDefinitions.put((String)definition.getId(), definition);
        }

        public void addPrefixDefinition(Prefix.Definition definition) {
            this.prefixDefinitions.put((String)definition.getId(), definition);
        }

        public void addSystemOfUnitsDefinition(SystemOfUnits.Definition definition) {
            this.systemOfUnitsDefinitions.put((String)definition.getId(), definition);
        }

        public NodeDefinition<String, Unit> expectUnitDefinition(String iri) {
            if (iri == null) {
                return null;
            }
            return new MapBackedNodeDefinition<String, Unit>(this.unitDefinitions, iri, () -> new NotFoundException(String.format("No Unit found with iri %s", iri)));
        }

        public NodeDefinition<String, Prefix> expectPrefixDefinition(String iri) {
            if (iri == null) {
                return null;
            }
            return new MapBackedNodeDefinition<String, Prefix>(this.prefixDefinitions, iri, () -> new NotFoundException(String.format("No Prefix found with iri %s", iri)));
        }

        public NodeDefinition<String, QuantityKind> expectQuantityKindDefinition(String iri) {
            if (iri == null) {
                return null;
            }
            return new MapBackedNodeDefinition<String, QuantityKind>(this.quantityKindDefinitions, iri, () -> new NotFoundException(String.format("No QuantityKind found with iri %s", iri)));
        }

        public NodeDefinition<String, SystemOfUnits> expectSystemOfUnitsDefinition(String iri) {
            if (iri == null) {
                return null;
            }
            return new MapBackedNodeDefinition<String, SystemOfUnits>(this.systemOfUnitsDefinitions, iri, () -> new NotFoundException(String.format("No System of Units found with iri %s", iri)));
        }

        public boolean hasUnitDefinitions() {
            return !this.unitDefinitions.isEmpty();
        }

        public Optional<Unit.Definition> getUnitDefinition(String iri) {
            return Optional.of(this.unitDefinitions.get(iri));
        }

        public Optional<QuantityKind.Definition> getQuantityKindDefinition(String iri) {
            return Optional.of(this.quantityKindDefinitions.get(iri));
        }

        public Optional<Prefix.Definition> getPrefixDefinition(String iri) {
            return Optional.of(this.prefixDefinitions.get(iri));
        }

        public Optional<SystemOfUnits.Definition> getSystemOfUnitsDefinition(String iri) {
            return Optional.of(this.systemOfUnitsDefinitions.get(iri));
        }
    }
}

