/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.model;

import io.github.qudtlib.model.FactorUnits;
import io.github.qudtlib.model.Unit;
import io.github.qudtlib.nodedef.NodeDefinition;
import io.github.qudtlib.nodedef.SettableBuilderBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class FactorUnit {
    final int exponent;
    final Unit unit;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FactorUnit factorUnit) {
        return new Builder(factorUnit);
    }

    private FactorUnit(Builder builder) {
        Objects.requireNonNull(builder.unitBuilder);
        Objects.requireNonNull(builder.exponent);
        this.exponent = builder.exponent;
        this.unit = builder.unitBuilder.build();
    }

    public FactorUnit(Unit unit, int exponent) {
        Objects.requireNonNull(unit);
        this.exponent = exponent;
        this.unit = unit;
    }

    public static List<FactorUnit> contractExponents(List<FactorUnit> factorUnits) {
        return factorUnits.stream().collect(Collectors.groupingBy(FactorUnit::getKind, Collectors.reducing((l, r) -> FactorUnit.combine(l, r)))).values().stream().map(Optional::get).collect(Collectors.toList());
    }

    public static List<FactorUnit> reduceExponents(List<FactorUnit> factorUnits) {
        return factorUnits.stream().collect(Collectors.groupingBy(FactorUnit::getUnit, Collectors.reducing((l, r) -> FactorUnit.combine(l, r)))).values().stream().map(Optional::get).filter(fu -> Math.abs(fu.getExponent()) > 0).collect(Collectors.toList());
    }

    public static FactorUnits normalizeFactorUnits(List<FactorUnit> factorUnits) {
        FactorUnits ret = factorUnits.stream().map(fu -> fu.normalize()).reduce((prev, cur) -> cur.combineWith((FactorUnits)prev)).get();
        if (ret.isRatioOfSameUnits()) {
            return ret;
        }
        return ret.reduceExponents();
    }

    public static FactorUnit ofUnit(Unit unit) {
        return (FactorUnit)FactorUnit.builder().unit(unit).exponent(1).build();
    }

    public List<List<FactorUnit>> getAllPossibleFactorUnitCombinations() {
        List<List<FactorUnit>> subResult = this.unit.getAllPossibleFactorUnitCombinations();
        return subResult.stream().map(fus -> fus.stream().map(fu -> fu.pow(this.exponent)).collect(Collectors.toList())).distinct().collect(Collectors.toList());
    }

    public static List<List<FactorUnit>> getAllPossibleFactorUnitCombinations(List<FactorUnit> factorUnits) {
        int numFactors = factorUnits.size();
        List subresults = factorUnits.stream().map(fu -> fu.getAllPossibleFactorUnitCombinations()).collect(Collectors.toList());
        int[] subResultLengths = subresults.stream().map(sr -> sr.size()).mapToInt(i -> i).toArray();
        int[] currentIndices = new int[numFactors];
        ArrayList<List<FactorUnit>> results = new ArrayList<List<FactorUnit>>();
        do {
            ArrayList<FactorUnit> curResult = new ArrayList<FactorUnit>();
            boolean countUp = true;
            for (int i2 = 0; i2 < numFactors; ++i2) {
                curResult.addAll((Collection)((List)subresults.get(i2)).get(currentIndices[i2]));
                if (!countUp) continue;
                int n = i2;
                currentIndices[n] = currentIndices[n] + 1;
                if (currentIndices[i2] >= subResultLengths[i2]) {
                    currentIndices[i2] = 0;
                    continue;
                }
                countUp = false;
            }
            FactorUnit.addNoDuplicate(results, FactorUnit.contractExponents(curResult));
            FactorUnit.addNoDuplicate(results, FactorUnit.reduceExponents(curResult));
        } while (IntStream.of(currentIndices).sum() > 0);
        return results;
    }

    private static void addNoDuplicate(List<List<FactorUnit>> list, List<FactorUnit> candidate) {
        if (!list.stream().anyMatch(elem -> candidate.size() == elem.size() && elem.stream().allMatch(e -> candidate.stream().anyMatch(c -> e.equals(c))))) {
            list.add(candidate);
        }
    }

    public String getKind() {
        return this.unit.getIri() + " " + Integer.signum(this.exponent);
    }

    public int getExponent() {
        return this.exponent;
    }

    public int getExponentCumulated(int cumulatedExponent) {
        return this.exponent * cumulatedExponent;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public static FactorUnit combine(FactorUnit left, FactorUnit right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (!left.getUnit().equals(right.getUnit())) {
            throw new IllegalArgumentException("Cannot combine UnitFactors of different units (left: " + left.getUnit() + ", right: " + right.getUnit() + ")");
        }
        return (FactorUnit)FactorUnit.builder().unit(left.getUnit()).exponent(left.getExponent() + right.getExponent()).build();
    }

    public String toString() {
        return this.unit + (String)(this.exponent == 1 ? "" : "^" + this.exponent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactorUnit that = (FactorUnit)o;
        return this.exponent == that.exponent && this.unit.equals(that.unit);
    }

    public int hashCode() {
        return Objects.hash(this.exponent, this.unit);
    }

    public List<FactorUnit> getLeafFactorUnitsWithCumulativeExponents() {
        List<FactorUnit> leafFactorUnits = this.unit.getLeafFactorUnitsWithCumulativeExponents();
        if (!leafFactorUnits.isEmpty()) {
            return leafFactorUnits.stream().map(f -> f.pow(this.getExponent())).collect(Collectors.toList());
        }
        return List.of(this);
    }

    private FactorUnit withExponentMultiplied(int by) {
        return (FactorUnit)FactorUnit.builder().unit(this.unit).exponent(this.exponent * by).build();
    }

    public FactorUnits normalize() {
        return this.unit.normalize().pow(this.exponent);
    }

    public FactorUnit pow(int exponent) {
        return new FactorUnit(this.unit, this.exponent * exponent);
    }

    public static class Builder
    extends SettableBuilderBase<FactorUnit> {
        private Integer exponent;
        private io.github.qudtlib.nodedef.Builder<Unit> unitBuilder;

        public Builder() {
        }

        public Builder(FactorUnit presetProduct) {
            super(presetProduct);
        }

        public Builder exponent(int exponent) {
            this.exponent = exponent;
            this.resetProduct();
            return this;
        }

        public Builder unit(NodeDefinition<String, Unit> unitDefinition) {
            this.unitBuilder = unitDefinition;
            this.resetProduct();
            return this;
        }

        public Builder unit(Unit unit) {
            Objects.requireNonNull(unit);
            this.unitBuilder = Unit.definition(unit);
            return this;
        }

        @Override
        public FactorUnit doBuild() {
            return new FactorUnit(this);
        }
    }
}

