/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.model;

import io.github.qudtlib.model.FactorUnit;
import io.github.qudtlib.model.Unit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public class FactorUnitMatch {
    private final FactorUnit matchedFactorUnit;
    private final List<Unit> matchedPath;
    private final BigDecimal matchedMultiplier;

    public FactorUnitMatch(FactorUnit matchedFactorUnit, BigDecimal matchedMultiplier, Collection<Unit> matchedPath) {
        Objects.requireNonNull(matchedFactorUnit);
        Objects.requireNonNull(matchedPath);
        Objects.requireNonNull(matchedMultiplier);
        this.matchedFactorUnit = matchedFactorUnit;
        this.matchedPath = Collections.unmodifiableList(new ArrayList<Unit>(matchedPath));
        this.matchedMultiplier = matchedMultiplier;
    }

    public FactorUnit getMatchedFactorUnit() {
        return this.matchedFactorUnit;
    }

    public BigDecimal getMatchedMultiplier() {
        return this.matchedMultiplier;
    }

    public List<Unit> getMatchedPath() {
        return this.matchedPath;
    }

    public String toString() {
        return this.getPathAsString() + (String)(this.matchedMultiplier.compareTo(BigDecimal.ONE) == 0 ? "" : "*" + this.matchedMultiplier);
    }

    private String getPathAsString() {
        StringBuilder sb = new StringBuilder("/");
        if (this.matchedPath != null) {
            ListIterator<Unit> li = this.matchedPath.listIterator(this.matchedPath.size());
            while (li.hasPrevious()) {
                sb.append(li.previous());
                if (!li.hasPrevious()) continue;
                sb.append("/");
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactorUnitMatch that = (FactorUnitMatch)o;
        return this.matchedFactorUnit.equals(that.matchedFactorUnit) && this.matchedPath.equals(that.matchedPath) && this.matchedMultiplier.equals(that.matchedMultiplier);
    }

    public int hashCode() {
        return Objects.hash(this.matchedFactorUnit, this.matchedPath, this.matchedMultiplier);
    }
}

