/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.model;

import io.github.qudtlib.model.FactorUnit;
import io.github.qudtlib.model.Unit;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FactorUnits {
    private final List<FactorUnit> factorUnits;
    private final BigDecimal scaleFactor;

    public FactorUnits(List<FactorUnit> factorUnits, BigDecimal scaleFactor) {
        this.factorUnits = factorUnits.stream().collect(Collectors.toUnmodifiableList());
        this.scaleFactor = scaleFactor;
    }

    public FactorUnits(List<FactorUnit> factorUnits) {
        this(factorUnits, new BigDecimal("1"));
    }

    public static FactorUnits ofUnit(Unit unit) {
        return new FactorUnits(List.of((FactorUnit)FactorUnit.builder().unit(Unit.definition(unit)).exponent(1).build()));
    }

    public static FactorUnits ofFactorUnitSpec(Object ... factorUnitSpec) {
        if (factorUnitSpec.length % 2 != 0) {
            throw new IllegalArgumentException("An even number of arguments is required");
        }
        if (factorUnitSpec.length > 14) {
            throw new IllegalArgumentException("No more than 14 arguments (7 factor units) supported");
        }
        ArrayList<FactorUnit> factorUnits = new ArrayList<FactorUnit>();
        for (int i = 0; i < factorUnitSpec.length; i += 2) {
            Unit requestedUnit = (Unit)factorUnitSpec[i];
            Integer requestedExponent = (Integer)factorUnitSpec[i + 1];
            factorUnits.add((FactorUnit)FactorUnit.builder().unit(Unit.definition(requestedUnit)).exponent(requestedExponent).build());
        }
        return new FactorUnits(factorUnits);
    }

    public static FactorUnits ofFactorUnitSpec(Collection<Map.Entry<String, Integer>> factorUnitSpec) {
        Object[] arr = new Object[factorUnitSpec.size() * 2];
        return FactorUnits.ofFactorUnitSpec(factorUnitSpec.stream().flatMap(e -> Stream.of((Serializable)e.getKey(), (Serializable)e.getValue())).collect(Collectors.toList()).toArray(arr));
    }

    public List<FactorUnit> getFactorUnits() {
        return this.factorUnits;
    }

    public BigDecimal getScaleFactor() {
        return this.scaleFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactorUnits that = (FactorUnits)o;
        return this.scaleFactor.compareTo(that.scaleFactor) == 0 && new HashSet<FactorUnit>(this.factorUnits).equals(new HashSet<FactorUnit>(that.factorUnits));
    }

    public int hashCode() {
        return Objects.hash(this.factorUnits, this.scaleFactor);
    }

    public String toString() {
        return (String)(this.scaleFactor.compareTo(BigDecimal.ONE) == 0 ? "" : this.scaleFactor.toString() + "*") + this.factorUnits;
    }

    public FactorUnits pow(int exponent) {
        return new FactorUnits(this.factorUnits.stream().map(fu -> fu.pow(exponent)).collect(Collectors.toList()), this.scaleFactor.pow(exponent, MathContext.DECIMAL128));
    }

    public FactorUnits combineWith(FactorUnits other) {
        if (other == null) {
            return this;
        }
        return new FactorUnits(FactorUnit.contractExponents(Stream.concat(this.factorUnits.stream(), other.factorUnits.stream()).collect(Collectors.toList())), this.scaleFactor.multiply(other.scaleFactor, MathContext.DECIMAL128));
    }

    public boolean isRatioOfSameUnits() {
        return this.factorUnits.size() == 2 && this.factorUnits.get(0).getUnit().equals(this.factorUnits.get(1).getUnit()) && this.factorUnits.get(0).getExponent() == this.factorUnits.get(1).getExponent();
    }

    public FactorUnits reduceExponents() {
        return new FactorUnits(FactorUnit.reduceExponents(this.factorUnits), this.scaleFactor);
    }

    public FactorUnits scale(BigDecimal by) {
        return new FactorUnits(this.factorUnits, this.scaleFactor.multiply(by));
    }

    public FactorUnits normalize() {
        FactorUnits normalized = FactorUnit.normalizeFactorUnits(this.factorUnits);
        return new FactorUnits(normalized.getFactorUnits(), normalized.getScaleFactor().multiply(this.scaleFactor));
    }
}

