/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.model;

import java.util.Objects;
import java.util.Optional;

public class LangString {
    private final String string;
    private final String languageTag;

    public LangString(String string) {
        this(string, null);
    }

    public LangString(String string, String languageTag) {
        Objects.requireNonNull(string);
        this.string = string;
        this.languageTag = languageTag;
    }

    public String getString() {
        return this.string;
    }

    public Optional<String> getLanguageTag() {
        return Optional.ofNullable(this.languageTag);
    }

    public String toString() {
        return "'" + this.string + "'" + (String)(this.languageTag == null ? "" : "@" + this.languageTag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LangString that = (LangString)o;
        return this.string.equals(that.string) && Objects.equals(this.languageTag, that.languageTag);
    }

    public int hashCode() {
        return Objects.hash(this.string, this.languageTag);
    }
}

