/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.model;

import io.github.qudtlib.model.LangString;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class LangStrings {
    private static final String KEY_NO_TAG = "no-language-tag";
    private final Map<String, Set<LangString>> langStrings;

    public LangStrings(Collection<LangString> langStrings) {
        this.langStrings = Collections.unmodifiableMap(langStrings.stream().collect(Collectors.groupingBy(l -> l.getLanguageTag().orElse(KEY_NO_TAG), Collectors.toSet())));
    }

    public Optional<String> getStringForLanguageTag(String language, String fallbackLanguage, boolean allowAnyIfNoMatch) {
        return this.getLangStringForLanguageTag(language, fallbackLanguage, allowAnyIfNoMatch).map(ls -> ls.getString());
    }

    public Optional<LangString> getLangStringForLanguageTag(String language, String fallbackLanguage, boolean allowAnyIfNoMatch) {
        if (language == null) {
            return this.getAnyLangString();
        }
        Optional<LangString> result = this.getAnyLangStringForLanguageTag(language);
        if (result.isPresent()) {
            return result;
        }
        if (fallbackLanguage != null && (result = this.getAnyLangStringForLanguageTag(fallbackLanguage)) != null) {
            return result;
        }
        if (allowAnyIfNoMatch) {
            return this.getAnyLangString();
        }
        return Optional.empty();
    }

    private Optional<LangString> getAnyLangStringForLanguageTag(String language) {
        return Optional.ofNullable(this.langStrings.get(language)).map(s -> s.stream().findFirst().orElse(null));
    }

    private Optional<LangString> getAnyLangString() {
        return this.langStrings.values().stream().findFirst().map(s -> s.stream().findFirst().orElse(null));
    }

    public boolean containsStringForLanguageTag(String languageTag) {
        return this.langStrings.containsKey(languageTag);
    }

    public Set<LangString> getAll() {
        return this.langStrings.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LangStrings that = (LangStrings)o;
        return this.langStrings.equals(that.langStrings);
    }

    public int hashCode() {
        return Objects.hash(this.langStrings);
    }

    public boolean containsString(String label) {
        return this.langStrings.values().stream().flatMap(Collection::stream).anyMatch(s -> s.getString().equals(label));
    }
}

