/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.model;

public class Namespace {
    private final String abbreviationPrefix;
    private final String baseIri;

    public Namespace(String baseIri, String abbreviationPrefix) {
        this.abbreviationPrefix = abbreviationPrefix;
        this.baseIri = baseIri;
    }

    public String getAbbreviationPrefix() {
        return this.abbreviationPrefix;
    }

    public String getBaseIri() {
        return this.baseIri;
    }

    public String abbreviate(String iri) {
        if (this.isFullNamespaceIri(iri)) {
            return this.abbreviationPrefix + ":" + iri.substring(this.baseIri.length());
        }
        return new String(iri);
    }

    public String expand(String abbreviatedIri) {
        if (this.isAbbreviatedNamespaceIri(abbreviatedIri)) {
            return this.baseIri + abbreviatedIri.substring(this.abbreviationPrefix.length() + 1);
        }
        return new String(abbreviatedIri);
    }

    public boolean isAbbreviatedNamespaceIri(String abbreviatedIri) {
        return abbreviatedIri.startsWith(this.abbreviationPrefix + ":");
    }

    public boolean isFullNamespaceIri(String iri) {
        return iri.startsWith(this.baseIri);
    }

    public String makeIriInNamespace(String localName) {
        return this.baseIri + localName;
    }
}

