/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.model;

import io.github.qudtlib.model.LangString;
import io.github.qudtlib.model.LangStrings;
import io.github.qudtlib.nodedef.NodeDefinitionBase;
import io.github.qudtlib.nodedef.SelfSmuggler;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Prefix
extends SelfSmuggler {
    private final String iri;
    private final BigDecimal multiplier;
    private final String symbol;
    private final String ucumCode;
    private final LangStrings labels;

    public static Definition definition(String iri) {
        return new Definition(iri);
    }

    public static Definition definition(Prefix prefix) {
        return new Definition(prefix);
    }

    public Prefix(Definition definition) {
        super(definition);
        Objects.requireNonNull(definition.iri);
        Objects.requireNonNull(definition.iri);
        Objects.requireNonNull(definition.multiplier);
        Objects.requireNonNull(definition.symbol);
        Objects.requireNonNull(definition.labels);
        this.iri = definition.iri;
        this.multiplier = definition.multiplier;
        this.symbol = definition.symbol;
        this.labels = new LangStrings(definition.labels);
        this.ucumCode = definition.ucumCode;
    }

    public String getIri() {
        return this.iri;
    }

    public BigDecimal getMultiplier() {
        return this.multiplier;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Optional<String> getUcumCode() {
        return Optional.ofNullable(this.ucumCode);
    }

    public Set<LangString> getLabels() {
        return this.labels.getAll();
    }

    public Optional<LangString> getLabelForLanguageTag(String languageTag) {
        return this.labels.getLangStringForLanguageTag(languageTag, null, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Prefix prefix = (Prefix)o;
        return this.multiplier.compareTo(prefix.multiplier) == 0 && Objects.equals(this.iri, prefix.iri) && Objects.equals(this.symbol, prefix.symbol) && Objects.equals(this.ucumCode, prefix.ucumCode) && Objects.equals(this.labels, prefix.labels);
    }

    public int hashCode() {
        return Objects.hash(this.iri, this.multiplier, this.symbol, this.ucumCode, this.labels);
    }

    public String toString() {
        return "prefix:" + this.iri.replaceAll(".+/", "");
    }

    public static class Definition
    extends NodeDefinitionBase<String, Prefix> {
        private final String iri;
        private BigDecimal multiplier;
        private String symbol;
        private String ucumCode;
        private Set<LangString> labels = new HashSet<LangString>();

        public Definition(String iri) {
            super(iri);
            Objects.requireNonNull(iri);
            this.iri = iri;
        }

        public Definition(Prefix presetPrefix) {
            super(presetPrefix.getIri(), presetPrefix);
            Objects.requireNonNull(presetPrefix.getIri());
            this.iri = presetPrefix.getIri();
        }

        public Definition multiplier(BigDecimal multiplier) {
            this.doIfPresent(multiplier, m -> {
                this.multiplier = m;
            });
            return this;
        }

        public Definition symbol(String symbol) {
            this.doIfPresent(symbol, s -> {
                this.symbol = s;
            });
            return this;
        }

        public Definition ucumCode(String ucumCode) {
            this.doIfPresent(ucumCode, s -> {
                this.ucumCode = s;
            });
            return this;
        }

        public Definition addLabel(LangString label) {
            this.doIfPresent(label, l -> this.labels.add((LangString)l));
            return this;
        }

        @Override
        public Prefix doBuild() {
            return new Prefix(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Definition definition = (Definition)o;
            return this.iri.equals(definition.iri);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.iri);
        }
    }
}

