/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.model;

import io.github.qudtlib.exception.InconvertibleQuantitiesException;
import io.github.qudtlib.model.Unit;
import java.math.BigDecimal;
import java.util.Objects;

public class QuantityValue {
    private final BigDecimal value;
    private final Unit unit;

    public QuantityValue(BigDecimal value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuantityValue that = (QuantityValue)o;
        return this.value.compareTo(that.value) == 0 && Objects.equals(this.unit, that.unit);
    }

    public QuantityValue convert(Unit toUnit) throws InconvertibleQuantitiesException {
        return new QuantityValue(this.unit.convert(this.value, toUnit), toUnit);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.unit);
    }

    public String toString() {
        return this.value.toString() + this.unit.toString();
    }
}

