/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.model;

import io.github.qudtlib.exception.InconvertibleQuantitiesException;
import io.github.qudtlib.model.FactorUnit;
import io.github.qudtlib.model.FactorUnits;
import io.github.qudtlib.model.LangString;
import io.github.qudtlib.model.LangStrings;
import io.github.qudtlib.model.Prefix;
import io.github.qudtlib.model.QuantityKind;
import io.github.qudtlib.model.QuantityValue;
import io.github.qudtlib.model.SystemOfUnits;
import io.github.qudtlib.nodedef.Builder;
import io.github.qudtlib.nodedef.NodeDefinitionBase;
import io.github.qudtlib.nodedef.SelfSmuggler;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Unit
extends SelfSmuggler {
    private final String iri;
    private final Prefix prefix;
    private final BigDecimal conversionMultiplier;
    private final BigDecimal conversionOffset;
    private final Set<QuantityKind> quantityKinds;
    private final String symbol;
    private final LangStrings labels;
    private final Unit scalingOf;
    private final String dimensionVectorIri;
    private final List<FactorUnit> factorUnits;
    private final String currencyCode;
    private final Integer currencyNumber;
    private final Set<SystemOfUnits> unitOfSystems;

    public static Definition definition(String iri) {
        return new Definition(iri);
    }

    static Definition definition(Unit product) {
        return new Definition(product);
    }

    private Unit(Definition definition) {
        super(definition);
        Objects.requireNonNull(definition.iri);
        Objects.requireNonNull(definition.labels);
        Objects.requireNonNull(definition.factorUnits);
        Objects.requireNonNull(definition.quantityKinds);
        if (definition.dimensionVectorIri == null) {
            definition.dimensionVectorIri = "missing:dimensionvector:iri";
            System.err.println("warning: no dimension vector present for unit " + definition.iri);
        }
        Objects.requireNonNull(definition.dimensionVectorIri);
        this.iri = definition.iri;
        this.dimensionVectorIri = definition.dimensionVectorIri;
        if (definition.conversionMultiplier != null && definition.conversionMultiplier.compareTo(BigDecimal.ZERO) == 0) {
            System.out.println("warning: conversionMultiplier 0.0 for unit " + this.iri);
            definition.conversionMultiplier = null;
        }
        this.conversionMultiplier = definition.conversionMultiplier != null ? definition.conversionMultiplier : BigDecimal.ONE;
        this.conversionOffset = definition.conversionOffset != null ? definition.conversionOffset : BigDecimal.ZERO;
        this.symbol = definition.symbol;
        this.currencyCode = definition.currencyCode;
        this.currencyNumber = definition.currencyNumber;
        this.labels = new LangStrings(definition.labels);
        this.prefix = definition.prefix == null ? null : definition.prefix.build();
        this.scalingOf = definition.scalingOf == null ? null : definition.scalingOf.build();
        this.quantityKinds = Builder.buildSet(definition.quantityKinds);
        this.factorUnits = Builder.buildList(definition.factorUnits);
        this.unitOfSystems = Builder.buildSet(definition.unitOfSystems);
    }

    static boolean isUnitless(Unit unit) {
        return unit.getIri().equals("http://qudt.org/vocab/unit/UNITLESS");
    }

    public QuantityValue convertToQuantityValue(BigDecimal value, Unit toUnit) {
        return new QuantityValue(this.convert(value, toUnit), toUnit);
    }

    public BigDecimal convert(BigDecimal value, Unit toUnit) throws InconvertibleQuantitiesException {
        Objects.requireNonNull(value);
        Objects.requireNonNull(toUnit);
        if (this.equals(toUnit)) {
            return value;
        }
        if (Unit.isUnitless(this) || Unit.isUnitless(toUnit)) {
            return value;
        }
        if (!this.isConvertible(toUnit)) {
            throw new InconvertibleQuantitiesException(String.format("Cannot convert from %s to %s: dimension vectors differ", this.getIri(), toUnit.getIri()));
        }
        BigDecimal fromOffset = this.getConversionOffset().orElse(BigDecimal.ZERO);
        BigDecimal fromMultiplier = this.getConversionMultiplier().orElse(BigDecimal.ONE);
        BigDecimal toOffset = toUnit.getConversionOffset().orElse(BigDecimal.ZERO);
        BigDecimal toMultiplier = toUnit.getConversionMultiplier().orElse(BigDecimal.ONE);
        return value.add(fromOffset).multiply(fromMultiplier, MathContext.DECIMAL128).divide(toMultiplier, MathContext.DECIMAL128).subtract(toOffset);
    }

    public BigDecimal getConversionMultiplier(Unit toUnit) {
        if (this.equals(toUnit)) {
            return BigDecimal.ONE;
        }
        if (this.conversionOffsetDiffers(toUnit)) {
            throw new IllegalArgumentException(String.format("Cannot convert from %s to %s just by multiplication as their conversion offsets differ (%s vs %s)", this, toUnit, this.conversionOffset, toUnit.conversionOffset));
        }
        BigDecimal fromMultiplier = this.getConversionMultiplier().orElse(BigDecimal.ONE);
        BigDecimal toMultiplier = toUnit.getConversionMultiplier().orElse(BigDecimal.ONE);
        return fromMultiplier.divide(toMultiplier, MathContext.DECIMAL128);
    }

    public boolean conversionOffsetDiffers(Unit other) {
        if (this.hasNonzeroConversionOffset() && other.hasNonzeroConversionOffset()) {
            return this.conversionOffset.compareTo(other.conversionOffset) != 0;
        }
        return false;
    }

    public boolean hasNonzeroConversionOffset() {
        return this.conversionOffset != null && this.conversionOffset.compareTo(BigDecimal.ZERO) != 0;
    }

    public boolean isConvertible(Unit toUnit) {
        Objects.requireNonNull(toUnit);
        Objects.requireNonNull(this.dimensionVectorIri);
        return this.dimensionVectorIri.equals(toUnit.dimensionVectorIri);
    }

    public boolean matches(Collection<Map.Entry<String, Integer>> factorUnitSpec) {
        return this.matches(FactorUnits.ofFactorUnitSpec(factorUnitSpec));
    }

    public boolean matches(Object ... factorUnitSpec) {
        return this.matches(FactorUnits.ofFactorUnitSpec(factorUnitSpec));
    }

    public boolean matches(FactorUnits factorUnits) {
        FactorUnits thisNormalized = this.normalize();
        FactorUnits selectionNormalized = factorUnits.normalize();
        return thisNormalized.equals(selectionNormalized);
    }

    public boolean hasFactorUnits() {
        return this.factorUnits != null && !this.factorUnits.isEmpty();
    }

    public boolean isScaled() {
        return this.scalingOf != null;
    }

    public FactorUnits normalize() {
        if (this.hasFactorUnits()) {
            FactorUnits ret = this.factorUnits.stream().map(fu -> fu.normalize()).reduce((prev, cur) -> cur.combineWith((FactorUnits)prev)).get();
            if (ret.isRatioOfSameUnits()) {
                return FactorUnits.ofUnit(this);
            }
            return ret.reduceExponents();
        }
        if (this.isScaled()) {
            return this.scalingOf.normalize().scale(this.getConversionMultiplier(this.scalingOf));
        }
        return FactorUnits.ofUnit(this);
    }

    public List<FactorUnit> getLeafFactorUnitsWithCumulativeExponents() {
        return this.factorUnits == null || this.factorUnits.isEmpty() ? List.of(FactorUnit.ofUnit(this)) : this.factorUnits.stream().flatMap(f -> f.getLeafFactorUnitsWithCumulativeExponents().stream()).collect(Collectors.toList());
    }

    public List<List<FactorUnit>> getAllPossibleFactorUnitCombinations() {
        List<FactorUnit> thisAsResult;
        if (!this.hasFactorUnits() || this.factorUnits.isEmpty()) {
            if (this.isScaled()) {
                return this.scalingOf.getAllPossibleFactorUnitCombinations();
            }
            return List.of(List.of(FactorUnit.ofUnit(this)));
        }
        List<List<FactorUnit>> result = FactorUnit.getAllPossibleFactorUnitCombinations(this.factorUnits);
        if (!result.contains(thisAsResult = List.of(FactorUnit.ofUnit(this)))) {
            result.add(thisAsResult);
        }
        return result;
    }

    public String getIri() {
        return this.iri;
    }

    public Optional<String> getDimensionVectorIri() {
        return Optional.ofNullable(this.dimensionVectorIri);
    }

    public Optional<BigDecimal> getConversionMultiplier() {
        return Optional.ofNullable(this.conversionMultiplier);
    }

    public Optional<BigDecimal> getConversionOffset() {
        return Optional.ofNullable(this.conversionOffset);
    }

    public Optional<String> getSymbol() {
        return Optional.ofNullable(this.symbol);
    }

    public Set<LangString> getLabels() {
        return this.labels.getAll();
    }

    public Optional<LangString> getLabelForLanguageTag(String languageTag) {
        return this.labels.getLangStringForLanguageTag(languageTag, null, true);
    }

    public boolean hasLabel(String label) {
        return this.labels.containsString(label);
    }

    public Optional<Prefix> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    public Optional<Unit> getScalingOf() {
        return Optional.ofNullable(this.scalingOf);
    }

    public Set<QuantityKind> getQuantityKinds() {
        return this.quantityKinds;
    }

    public List<FactorUnit> getFactorUnits() {
        return this.factorUnits == null ? Collections.emptyList() : Collections.unmodifiableList(this.factorUnits);
    }

    public Optional<String> getCurrencyCode() {
        return Optional.ofNullable(this.currencyCode);
    }

    public Optional<Integer> getCurrencyNumber() {
        return Optional.ofNullable(this.currencyNumber);
    }

    public Set<SystemOfUnits> getUnitOfSystems() {
        return this.unitOfSystems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Unit unit = (Unit)o;
        return Objects.equals(this.iri, unit.iri);
    }

    public int hashCode() {
        return Objects.hash(this.iri);
    }

    public String toString() {
        if (this.symbol != null) {
            return this.symbol;
        }
        if (this.scalingOf != null && this.scalingOf.getSymbol().isPresent() && this.prefix != null) {
            return this.prefix.getSymbol() + this.scalingOf.getSymbol().get();
        }
        return "unit:" + this.iri.replaceAll(".+/([^/]+)", "$1");
    }

    private boolean findInBasesRecursively(Unit toFind) {
        if (!this.isScaled()) {
            return this.equals(toFind);
        }
        return this.getScalingOf().orElseThrow(() -> new IllegalStateException(String.format("No base unit found for %s - this is a bug", this))).findInBasesRecursively(toFind);
    }

    public boolean isSameScaleAs(Unit other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.getScalingOf().map(s -> s.equals(other.getScalingOf().orElse(null))).orElse(false).booleanValue()) {
            return true;
        }
        return this.findInBasesRecursively(other) || other.findInBasesRecursively(this);
    }

    public static class Definition
    extends NodeDefinitionBase<String, Unit> {
        private String iri;
        private Builder<Prefix> prefix;
        private BigDecimal conversionMultiplier;
        private BigDecimal conversionOffset;
        private Set<Builder<QuantityKind>> quantityKinds = new HashSet<Builder<QuantityKind>>();
        private String symbol;
        private Set<LangString> labels = new HashSet<LangString>();
        private Builder<Unit> scalingOf;
        private String dimensionVectorIri;
        private List<Builder<FactorUnit>> factorUnits = new ArrayList<Builder<FactorUnit>>();
        private String currencyCode;
        private Integer currencyNumber;
        private Set<Builder<SystemOfUnits>> unitOfSystems = new HashSet<Builder<SystemOfUnits>>();

        Definition(String iri) {
            super(iri);
            this.iri = iri;
        }

        Definition(Unit product) {
            super(product.getIri(), product);
            this.iri = product.iri;
        }

        public Definition conversionMultiplier(BigDecimal conversionMultiplier) {
            this.conversionMultiplier = conversionMultiplier;
            return this;
        }

        public Definition conversionOffset(BigDecimal conversionOffset) {
            this.conversionOffset = conversionOffset;
            return this;
        }

        public Definition symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        Definition addLabel(String label, String languageTag) {
            if (label != null) {
                return this.addLabel(new LangString(label, languageTag));
            }
            return this;
        }

        public Definition addLabel(LangString label) {
            this.doIfPresent(label, l -> this.labels.add((LangString)l));
            return this;
        }

        Definition addLabels(Collection<LangString> labels) {
            this.labels.addAll(labels);
            return this;
        }

        public Definition dimensionVectorIri(String dimensionVectorIri) {
            this.dimensionVectorIri = dimensionVectorIri;
            return this;
        }

        public Definition addFactorUnit(FactorUnit.Builder factorUnit) {
            this.doIfPresent(factorUnit, f -> this.factorUnits.add((Builder<FactorUnit>)f));
            return this;
        }

        Definition addFactorUnit(FactorUnit factorUnit) {
            this.doIfPresent(factorUnit, f -> this.factorUnits.add(FactorUnit.builder(f)));
            return this;
        }

        public Definition currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Definition currencyNumber(Integer currencyNumber) {
            this.currencyNumber = currencyNumber;
            return this;
        }

        public Definition addUnitOfSystem(Builder<SystemOfUnits> systemOfUnits) {
            this.doIfPresent(systemOfUnits, s -> this.unitOfSystems.add(systemOfUnits));
            return this;
        }

        public Definition prefix(Builder<Prefix> prefix) {
            this.prefix = prefix;
            return this;
        }

        public Definition scalingOf(Builder<Unit> scalingOf) {
            this.scalingOf = scalingOf;
            return this;
        }

        public Definition addQuantityKind(Builder<QuantityKind> quantityKind) {
            this.doIfPresent(quantityKind, q -> this.quantityKinds.add(quantityKind));
            return this;
        }

        @Override
        public Unit doBuild() {
            return new Unit(this);
        }
    }
}

