/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.api;

import io.github.queritylib.querity.api.AndConditionsWrapper;
import io.github.queritylib.querity.api.Condition;
import io.github.queritylib.querity.api.NativeConditionWrapper;
import io.github.queritylib.querity.api.NotCondition;
import io.github.queritylib.querity.api.Operator;
import io.github.queritylib.querity.api.OrConditionsWrapper;
import io.github.queritylib.querity.api.Pagination;
import io.github.queritylib.querity.api.Query;
import io.github.queritylib.querity.api.SimpleCondition;
import io.github.queritylib.querity.api.Sort;
import java.util.Arrays;
import java.util.List;

public interface Querity {
    public <T> List<T> findAll(Class<T> var1, Query var2);

    public <T> Long count(Class<T> var1, Condition var2);

    public static Query.QueryBuilder query() {
        return Query.builder();
    }

    public static SimpleCondition filterBy(String propertyName, Object value) {
        return SimpleCondition.builder().propertyName(propertyName).value(value).build();
    }

    public static SimpleCondition filterBy(String propertyName, Operator operator, Object value) {
        return SimpleCondition.builder().propertyName(propertyName).operator(operator).value(value).build();
    }

    public static SimpleCondition filterBy(String propertyName, Operator operator) {
        return SimpleCondition.builder().propertyName(propertyName).operator(operator).build();
    }

    public static <T> NativeConditionWrapper<T> filterByNative(T nativeCondition) {
        return NativeConditionWrapper.builder().nativeCondition(nativeCondition).build();
    }

    public static AndConditionsWrapper and(Condition ... conditions) {
        return AndConditionsWrapper.builder().conditions(Arrays.asList(conditions)).build();
    }

    public static OrConditionsWrapper or(Condition ... conditions) {
        return OrConditionsWrapper.builder().conditions(Arrays.asList(conditions)).build();
    }

    public static NotCondition not(Condition condition) {
        return NotCondition.builder().condition(condition).build();
    }

    public static Pagination paged(Integer page, Integer pageSize) {
        return Pagination.builder().page(page).pageSize(pageSize).build();
    }

    public static Sort sortBy(String propertyName) {
        return Querity.sortBy(propertyName, Sort.Direction.ASC);
    }

    public static Sort sortBy(String propertyName, Sort.Direction direction) {
        return Sort.builder().propertyName(propertyName).direction(direction).build();
    }

    public static Query wrapConditionInQuery(Condition condition) {
        return Querity.query().filter(condition).build();
    }
}

