/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.github.queritylib.querity.api.Condition;
import io.github.queritylib.querity.api.Pagination;
import io.github.queritylib.querity.api.Querity;
import io.github.queritylib.querity.api.QueryPreprocessor;
import io.github.queritylib.querity.api.Sort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import lombok.NonNull;

@JsonDeserialize(builder=QueryBuilder.class)
public class Query {
    private final Condition filter;
    private final Pagination pagination;
    @NonNull
    private final Sort[] sort;
    @JsonIgnore
    @NonNull
    private List<QueryPreprocessor> preprocessors;
    private boolean distinct;

    public boolean hasFilter() {
        return this.filter != null && !this.filter.isEmpty();
    }

    public boolean hasPagination() {
        return this.pagination != null;
    }

    public boolean hasSort() {
        return Arrays.stream(this.sort).anyMatch(s -> true);
    }

    public List<Sort> getSort() {
        return Arrays.asList(this.sort);
    }

    @NonNull
    List<QueryPreprocessor> getPreprocessors() {
        return this.preprocessors;
    }

    public Query preprocess() {
        AtomicReference<Query> atomicQuery = new AtomicReference<Query>(this);
        this.getPreprocessors().forEach(p -> atomicQuery.set(p.preprocess((Query)atomicQuery.get())));
        return atomicQuery.get();
    }

    @Generated
    Query(Condition filter, Pagination pagination, @NonNull Sort[] sort, @NonNull List<QueryPreprocessor> preprocessors, boolean distinct) {
        if (sort == null) {
            throw new NullPointerException("sort is marked non-null but is null");
        }
        if (preprocessors == null) {
            throw new NullPointerException("preprocessors is marked non-null but is null");
        }
        this.filter = filter;
        this.pagination = pagination;
        this.sort = sort;
        this.preprocessors = preprocessors;
        this.distinct = distinct;
    }

    @Generated
    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    @Generated
    public QueryBuilder toBuilder() {
        return new QueryBuilder().filter(this.filter).pagination(this.pagination).sort(this.sort).preprocessors(this.preprocessors).distinct(this.distinct);
    }

    @Generated
    public Condition getFilter() {
        return this.filter;
    }

    @Generated
    public Pagination getPagination() {
        return this.pagination;
    }

    @Generated
    public boolean isDistinct() {
        return this.distinct;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDistinct() != other.isDistinct()) {
            return false;
        }
        Condition this$filter = this.getFilter();
        Condition other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Pagination this$pagination = this.getPagination();
        Pagination other$pagination = other.getPagination();
        if (this$pagination == null ? other$pagination != null : !((Object)this$pagination).equals(other$pagination)) {
            return false;
        }
        List<Sort> this$sort = this.getSort();
        List<Sort> other$sort = other.getSort();
        return !(this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDistinct() ? 79 : 97);
        Condition $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Pagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : ((Object)$pagination).hashCode());
        List<Sort> $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Query(filter=" + String.valueOf(this.getFilter()) + ", pagination=" + String.valueOf(this.getPagination()) + ", sort=" + String.valueOf(this.getSort()) + ", distinct=" + this.isDistinct() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class QueryBuilder {
        @Generated
        private Condition filter;
        @Generated
        private boolean distinct;
        private Pagination pagination;
        private Sort[] sort = new Sort[0];
        private List<QueryPreprocessor> preprocessors = new ArrayList<QueryPreprocessor>();

        public QueryBuilder withPreprocessor(QueryPreprocessor preprocessor) {
            this.preprocessors.add(preprocessor);
            return this;
        }

        public QueryBuilder sort(Sort ... sort) {
            this.sort = sort;
            return this;
        }

        public QueryBuilder pagination(Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public QueryBuilder pagination(Integer page, Integer pageSize) {
            this.pagination = Querity.paged(page, pageSize);
            return this;
        }

        @Generated
        QueryBuilder() {
        }

        @Generated
        public QueryBuilder filter(Condition filter) {
            this.filter = filter;
            return this;
        }

        @JsonIgnore
        @Generated
        public QueryBuilder preprocessors(@NonNull List<QueryPreprocessor> preprocessors) {
            if (preprocessors == null) {
                throw new NullPointerException("preprocessors is marked non-null but is null");
            }
            this.preprocessors = preprocessors;
            return this;
        }

        @Generated
        public QueryBuilder distinct(boolean distinct) {
            this.distinct = distinct;
            return this;
        }

        @Generated
        public Query build() {
            return new Query(this.filter, this.pagination, this.sort, this.preprocessors, this.distinct);
        }

        @Generated
        public String toString() {
            return "Query.QueryBuilder(filter=" + String.valueOf(this.filter) + ", pagination=" + String.valueOf(this.pagination) + ", sort=" + Arrays.deepToString(this.sort) + ", preprocessors=" + String.valueOf(this.preprocessors) + ", distinct=" + this.distinct + ")";
        }
    }
}

