/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.github.queritylib.querity.api.Condition;
import io.github.queritylib.querity.api.Operator;
import lombok.Generated;
import lombok.NonNull;

@JsonDeserialize(builder=SimpleConditionBuilder.class)
public class SimpleCondition
implements Condition {
    @NonNull
    private final String propertyName;
    @NonNull
    private Operator operator = Operator.EQUALS;
    private final Object value;

    public SimpleCondition(@NonNull String propertyName, Operator operator, Object value) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        this.propertyName = propertyName;
        if (operator != null) {
            this.operator = operator;
        }
        this.value = value;
        this.validate(this.operator, this.value);
    }

    private void validate(Operator operator, Object value) {
        if (operator.getRequiredValuesCount() != this.getValuesCount(value)) {
            throw new IllegalArgumentException(String.format("The operator %s requires %d value(s)", new Object[]{operator, operator.getRequiredValuesCount()}));
        }
    }

    private int getValuesCount(Object value) {
        return value == null ? 0 : 1;
    }

    @Generated
    public static SimpleConditionBuilder builder() {
        return new SimpleConditionBuilder();
    }

    @Generated
    public SimpleConditionBuilder toBuilder() {
        return new SimpleConditionBuilder().propertyName(this.propertyName).operator(this.operator).value(this.value);
    }

    @NonNull
    @Generated
    public String getPropertyName() {
        return this.propertyName;
    }

    @NonNull
    @Generated
    public Operator getOperator() {
        return this.operator;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleCondition)) {
            return false;
        }
        SimpleCondition other = (SimpleCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
            return false;
        }
        Operator this$operator = this.getOperator();
        Operator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        Operator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SimpleCondition(propertyName=" + this.getPropertyName() + ", operator=" + String.valueOf((Object)this.getOperator()) + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class SimpleConditionBuilder {
        @Generated
        private String propertyName;
        @Generated
        private Operator operator;
        @Generated
        private Object value;

        @Generated
        SimpleConditionBuilder() {
        }

        @Generated
        public SimpleConditionBuilder propertyName(@NonNull String propertyName) {
            if (propertyName == null) {
                throw new NullPointerException("propertyName is marked non-null but is null");
            }
            this.propertyName = propertyName;
            return this;
        }

        @Generated
        public SimpleConditionBuilder operator(Operator operator) {
            this.operator = operator;
            return this;
        }

        @Generated
        public SimpleConditionBuilder value(Object value) {
            this.value = value;
            return this;
        }

        @Generated
        public SimpleCondition build() {
            return new SimpleCondition(this.propertyName, this.operator, this.value);
        }

        @Generated
        public String toString() {
            return "SimpleCondition.SimpleConditionBuilder(propertyName=" + this.propertyName + ", operator=" + String.valueOf((Object)this.operator) + ", value=" + String.valueOf(this.value) + ")";
        }
    }
}

