/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.common.mapping;

import io.github.queritylib.querity.api.Condition;
import io.github.queritylib.querity.api.Query;
import io.github.queritylib.querity.api.QueryPreprocessor;
import io.github.queritylib.querity.api.Sort;
import io.github.queritylib.querity.common.mapping.PropertyNameMapper;
import io.github.queritylib.querity.common.mapping.condition.ConditionMapperFactory;

public class PropertyNameMappingPreprocessor
implements QueryPreprocessor {
    private final PropertyNameMapper propertyNameMapper;

    public PropertyNameMappingPreprocessor(PropertyNameMapper propertyNameMapper) {
        this.propertyNameMapper = propertyNameMapper;
    }

    public Query preprocess(Query query) {
        return query.toBuilder().filter(this.mapCondition(query.getFilter())).sort((Sort[])query.getSort().stream().map(this::mapSort).toArray(Sort[]::new)).build();
    }

    private Condition mapCondition(Condition condition) {
        if (condition == null) {
            return null;
        }
        return ConditionMapperFactory.getConditionMapper(condition).mapCondition(condition, this.propertyNameMapper);
    }

    private Sort mapSort(Sort sort) {
        return sort.toBuilder().propertyName(this.propertyNameMapper.mapPropertyName(sort.getPropertyName())).build();
    }
}

