/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.common.mapping;

import io.github.queritylib.querity.common.mapping.PropertyNameMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class SimplePropertyNameMapper
implements PropertyNameMapper {
    private final Map<String, String> mappings;
    private final boolean recursive;

    @Override
    public String mapPropertyName(String propertyName) {
        Optional<String> mapping = this.findMapping(propertyName);
        return mapping.orElse(propertyName);
    }

    private Optional<String> findMapping(String propertyName) {
        Optional<String> result = Optional.ofNullable(this.mappings.get(propertyName));
        if (this.recursive && result.isEmpty() && propertyName.contains(".")) {
            result = this.findMapping(SimplePropertyNameMapper.getParentPropertyName(propertyName)).map(prefix -> prefix + "." + SimplePropertyNameMapper.getPropertyName(propertyName));
        }
        return result;
    }

    private static String getPropertyName(String propertyName) {
        String[] propertyPath = propertyName.split("\\.");
        return propertyPath[propertyPath.length - 1];
    }

    private static String getParentPropertyName(String propertyName) {
        String[] propertyPath = propertyName.split("\\.");
        CharSequence[] prefix = Arrays.copyOfRange(propertyPath, 0, propertyPath.length - 1);
        return String.join((CharSequence)".", prefix);
    }

    @Generated
    private static boolean $default$recursive() {
        return true;
    }

    @Generated
    SimplePropertyNameMapper(Map<String, String> mappings, boolean recursive) {
        this.mappings = mappings;
        this.recursive = recursive;
    }

    @Generated
    public static SimplePropertyNameMapperBuilder builder() {
        return new SimplePropertyNameMapperBuilder();
    }

    @Generated
    public static class SimplePropertyNameMapperBuilder {
        @Generated
        private ArrayList<String> mappings$key;
        @Generated
        private ArrayList<String> mappings$value;
        @Generated
        private boolean recursive$set;
        @Generated
        private boolean recursive$value;

        @Generated
        SimplePropertyNameMapperBuilder() {
        }

        @Generated
        public SimplePropertyNameMapperBuilder mapping(String mappingKey, String mappingValue) {
            if (this.mappings$key == null) {
                this.mappings$key = new ArrayList();
                this.mappings$value = new ArrayList();
            }
            this.mappings$key.add(mappingKey);
            this.mappings$value.add(mappingValue);
            return this;
        }

        @Generated
        public SimplePropertyNameMapperBuilder mappings(Map<? extends String, ? extends String> mappings) {
            if (mappings == null) {
                throw new NullPointerException("mappings cannot be null");
            }
            if (this.mappings$key == null) {
                this.mappings$key = new ArrayList();
                this.mappings$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : mappings.entrySet()) {
                this.mappings$key.add($lombokEntry.getKey());
                this.mappings$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public SimplePropertyNameMapperBuilder clearMappings() {
            if (this.mappings$key != null) {
                this.mappings$key.clear();
                this.mappings$value.clear();
            }
            return this;
        }

        @Generated
        public SimplePropertyNameMapperBuilder recursive(boolean recursive) {
            this.recursive$value = recursive;
            this.recursive$set = true;
            return this;
        }

        @Generated
        public SimplePropertyNameMapper build() {
            Map<String, String> mappings;
            switch (this.mappings$key == null ? 0 : this.mappings$key.size()) {
                case 0: {
                    mappings = Collections.emptyMap();
                    break;
                }
                case 1: {
                    mappings = Collections.singletonMap(this.mappings$key.get(0), this.mappings$value.get(0));
                    break;
                }
                default: {
                    mappings = new LinkedHashMap(this.mappings$key.size() < 0x40000000 ? 1 + this.mappings$key.size() + (this.mappings$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.mappings$key.size(); ++$i) {
                        mappings.put(this.mappings$key.get($i), this.mappings$value.get($i));
                    }
                    mappings = Collections.unmodifiableMap(mappings);
                }
            }
            boolean recursive$value = this.recursive$value;
            if (!this.recursive$set) {
                recursive$value = SimplePropertyNameMapper.$default$recursive();
            }
            return new SimplePropertyNameMapper(mappings, recursive$value);
        }

        @Generated
        public String toString() {
            return "SimplePropertyNameMapper.SimplePropertyNameMapperBuilder(mappings$key=" + String.valueOf(this.mappings$key) + ", mappings$value=" + String.valueOf(this.mappings$value) + ", recursive$value=" + this.recursive$value + ")";
        }
    }
}

