/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ReflectionUtils {
    public static <T> Set<Class<? extends T>> findSubclasses(Class<T> baseClass) {
        return new Reflections(baseClass.getPackage().getName(), new Scanner[0]).getSubTypesOf(baseClass).stream().filter(ReflectionUtils::isConcreteClass).collect(Collectors.toSet());
    }

    private static boolean isConcreteClass(Class<?> clazz) {
        return !Modifier.isAbstract(clazz.getModifiers());
    }

    public static <T> Optional<Field> getAccessibleField(Class<T> beanClass, String fieldName) {
        Optional<Field> field = ReflectionUtils.getField(beanClass, fieldName);
        field.ifPresent(f -> f.setAccessible(true));
        return field;
    }

    private static <T> Optional<Field> getField(Class<T> beanClass, String fieldName) {
        Class<T> currentClass = beanClass;
        do {
            Optional<Field> field;
            if (!(field = Arrays.stream(currentClass.getDeclaredFields()).filter(e -> e.getName().equals(fieldName)).findFirst()).isPresent()) continue;
            return field;
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return Optional.empty();
    }

    public static <T, A> Optional<Class<? extends T>> findClassWithConstructorArgumentOfType(Set<Class<? extends T>> allClasses, Class<? extends A> constructorArgumentType) {
        return allClasses.stream().filter(clazz -> Arrays.stream(clazz.getDeclaredConstructors()).anyMatch(constructor -> constructor.getParameterCount() == 1 && constructor.getParameterTypes()[0].equals(constructorArgumentType))).findAny();
    }

    public static <T, A> T constructInstanceWithArgument(Class<T> clazz, A argument) {
        Constructor<T> constructor = clazz.getDeclaredConstructor(argument.getClass());
        constructor.setAccessible(true);
        return constructor.newInstance(argument);
    }

    @Generated
    private ReflectionUtils() {
    }
}

