/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.common.valueextractor;

import io.github.queritylib.querity.common.valueextractor.PropertyValueExtractor;

public class BooleanValueExtractor
implements PropertyValueExtractor<Boolean> {
    @Override
    public boolean canHandle(Class<?> propertyType) {
        return BooleanValueExtractor.isBooleanType(propertyType);
    }

    @Override
    public Boolean extractValue(Class<?> propertyType, Object value) {
        if (value == null || BooleanValueExtractor.isBooleanType(value.getClass())) {
            return (Boolean)value;
        }
        return BooleanValueExtractor.getBooleanValue(value.toString());
    }

    private static boolean isBooleanType(Class<?> cls) {
        if (cls.isPrimitive()) {
            return Boolean.TYPE.equals(cls);
        }
        return Boolean.class.isAssignableFrom(cls);
    }

    private static Boolean getBooleanValue(String value) {
        return Boolean.valueOf(value);
    }
}

