/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.common.valueextractor;

import io.github.queritylib.querity.common.valueextractor.PropertyValueExtractor;
import java.time.LocalDate;

public class LocalDateValueExtractor
implements PropertyValueExtractor<LocalDate> {
    @Override
    public boolean canHandle(Class<?> propertyType) {
        return LocalDateValueExtractor.isLocalDateType(propertyType);
    }

    @Override
    public LocalDate extractValue(Class<?> propertyType, Object value) {
        if (value == null || LocalDateValueExtractor.isLocalDateType(value.getClass())) {
            return (LocalDate)value;
        }
        return LocalDateValueExtractor.getLocalDateValue(value.toString());
    }

    private static boolean isLocalDateType(Class<?> cls) {
        return LocalDate.class.isAssignableFrom(cls);
    }

    private static LocalDate getLocalDateValue(String value) {
        return LocalDate.parse(value);
    }
}

