/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.common.valueextractor;

import io.github.queritylib.querity.common.valueextractor.BooleanValueExtractor;
import io.github.queritylib.querity.common.valueextractor.DateValueExtractor;
import io.github.queritylib.querity.common.valueextractor.EnumValueExtractor;
import io.github.queritylib.querity.common.valueextractor.LocalDateTimeValueExtractor;
import io.github.queritylib.querity.common.valueextractor.LocalDateValueExtractor;
import io.github.queritylib.querity.common.valueextractor.NoOpValueExtractor;
import io.github.queritylib.querity.common.valueextractor.NumericValueExtractor;
import io.github.queritylib.querity.common.valueextractor.PropertyValueExtractor;
import io.github.queritylib.querity.common.valueextractor.StringValueExtractor;
import io.github.queritylib.querity.common.valueextractor.ZonedDateTimeValueExtractor;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class PropertyValueExtractorFactory {
    public static final NoOpValueExtractor NO_OP_VALUE_EXTRACTOR = new NoOpValueExtractor();
    private static final List<PropertyValueExtractor<?>> extractors = Arrays.asList(new StringValueExtractor(), new NumericValueExtractor(), new BooleanValueExtractor(), new DateValueExtractor(), new LocalDateValueExtractor(), new LocalDateTimeValueExtractor(), new ZonedDateTimeValueExtractor(), new EnumValueExtractor());

    public static PropertyValueExtractor<?> getPropertyValueExtractor(Class<?> propertyType) {
        return extractors.stream().filter(e -> e.canHandle(propertyType)).findAny().orElse(NO_OP_VALUE_EXTRACTOR);
    }

    @Generated
    private PropertyValueExtractorFactory() {
    }
}

