/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.common.valueextractor;

import io.github.queritylib.querity.common.valueextractor.PropertyValueExtractor;
import java.time.ZonedDateTime;

public class ZonedDateTimeValueExtractor
implements PropertyValueExtractor<ZonedDateTime> {
    @Override
    public boolean canHandle(Class<?> propertyType) {
        return ZonedDateTimeValueExtractor.isZonedDateTimeType(propertyType);
    }

    @Override
    public ZonedDateTime extractValue(Class<?> propertyType, Object value) {
        if (value == null || ZonedDateTimeValueExtractor.isZonedDateTimeType(value.getClass())) {
            return (ZonedDateTime)value;
        }
        return ZonedDateTimeValueExtractor.getZonedDateTimeValue(value.toString());
    }

    private static boolean isZonedDateTimeType(Class<?> cls) {
        return ZonedDateTime.class.isAssignableFrom(cls);
    }

    private static ZonedDateTime getZonedDateTimeValue(String value) {
        return ZonedDateTime.parse(value);
    }
}

