/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.jpa.domain;

import io.github.queritylib.querity.jpa.domain.AbstractPersistable;
import io.github.queritylib.querity.jpa.domain.Address;
import io.github.queritylib.querity.jpa.domain.Location;
import io.github.queritylib.querity.jpa.domain.Order;
import io.github.queritylib.querity.test.domain.Person;
import io.github.queritylib.querity.test.domain.ProductCategory;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.Enumerated;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class Person
extends AbstractPersistable<Long>
implements io.github.queritylib.querity.test.domain.Person<Long, Address, Location, Order> {
    @NonNull
    private String firstName;
    private String lastName;
    @NonNull
    private String email;
    @NonNull
    private Person.Gender gender;
    private LocalDate birthDate;
    @NonNull
    private BigDecimal height;
    @NonNull
    private Integer children;
    private boolean married;
    @OneToOne(mappedBy="person", cascade={CascadeType.ALL})
    @NonNull
    private Address address;
    @OneToMany(mappedBy="person", cascade={CascadeType.ALL})
    @NonNull
    private List<Location> visitedLocations;
    @Enumerated
    @NonNull
    private ProductCategory favouriteProductCategory;
    @OneToMany(mappedBy="person", cascade={CascadeType.ALL})
    @NonNull
    private List<Order> orders;

    @NonNull
    public String toString() {
        return "Person{id='" + String.valueOf(this.getId()) + "', firstName='" + this.firstName + "', lastName='" + this.lastName + "', birthDate='" + String.valueOf(this.birthDate) + "', city='" + this.address.getCity() + "'}";
    }

    @Generated
    private static List<Location> $default$visitedLocations() {
        return new ArrayList<Location>();
    }

    @Generated
    private static List<Order> $default$orders() {
        return new ArrayList<Order>();
    }

    @Generated
    public static PersonBuilder builder() {
        return new PersonBuilder();
    }

    @NonNull
    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @NonNull
    @Generated
    public String getEmail() {
        return this.email;
    }

    @NonNull
    @Generated
    public Person.Gender getGender() {
        return this.gender;
    }

    @Generated
    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    @NonNull
    @Generated
    public BigDecimal getHeight() {
        return this.height;
    }

    @NonNull
    @Generated
    public Integer getChildren() {
        return this.children;
    }

    @Generated
    public boolean isMarried() {
        return this.married;
    }

    @NonNull
    @Generated
    public Address getAddress() {
        return this.address;
    }

    @NonNull
    @Generated
    public List<Location> getVisitedLocations() {
        return this.visitedLocations;
    }

    @NonNull
    @Generated
    public ProductCategory getFavouriteProductCategory() {
        return this.favouriteProductCategory;
    }

    @NonNull
    @Generated
    public List<Order> getOrders() {
        return this.orders;
    }

    @Generated
    public void setFirstName(@NonNull String firstName) {
        if (firstName == null) {
            throw new NullPointerException("firstName is marked non-null but is null");
        }
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setEmail(@NonNull String email) {
        if (email == null) {
            throw new NullPointerException("email is marked non-null but is null");
        }
        this.email = email;
    }

    @Generated
    public void setGender(@NonNull Person.Gender gender) {
        if (gender == null) {
            throw new NullPointerException("gender is marked non-null but is null");
        }
        this.gender = gender;
    }

    @Generated
    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    @Generated
    public void setHeight(@NonNull BigDecimal height) {
        if (height == null) {
            throw new NullPointerException("height is marked non-null but is null");
        }
        this.height = height;
    }

    @Generated
    public void setChildren(@NonNull Integer children) {
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        this.children = children;
    }

    @Generated
    public void setMarried(boolean married) {
        this.married = married;
    }

    @Generated
    public void setAddress(@NonNull Address address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.address = address;
    }

    @Generated
    public void setVisitedLocations(@NonNull List<Location> visitedLocations) {
        if (visitedLocations == null) {
            throw new NullPointerException("visitedLocations is marked non-null but is null");
        }
        this.visitedLocations = visitedLocations;
    }

    @Generated
    public void setFavouriteProductCategory(@NonNull ProductCategory favouriteProductCategory) {
        if (favouriteProductCategory == null) {
            throw new NullPointerException("favouriteProductCategory is marked non-null but is null");
        }
        this.favouriteProductCategory = favouriteProductCategory;
    }

    @Generated
    public void setOrders(@NonNull List<Order> orders) {
        if (orders == null) {
            throw new NullPointerException("orders is marked non-null but is null");
        }
        this.orders = orders;
    }

    @Generated
    public Person() {
        this.visitedLocations = Person.$default$visitedLocations();
        this.orders = Person.$default$orders();
    }

    @Generated
    public Person(@NonNull String firstName, String lastName, @NonNull String email, @NonNull Person.Gender gender, LocalDate birthDate, @NonNull BigDecimal height, @NonNull Integer children, boolean married, @NonNull Address address, @NonNull List<Location> visitedLocations, @NonNull ProductCategory favouriteProductCategory, @NonNull List<Order> orders) {
        if (firstName == null) {
            throw new NullPointerException("firstName is marked non-null but is null");
        }
        if (email == null) {
            throw new NullPointerException("email is marked non-null but is null");
        }
        if (gender == null) {
            throw new NullPointerException("gender is marked non-null but is null");
        }
        if (height == null) {
            throw new NullPointerException("height is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (visitedLocations == null) {
            throw new NullPointerException("visitedLocations is marked non-null but is null");
        }
        if (favouriteProductCategory == null) {
            throw new NullPointerException("favouriteProductCategory is marked non-null but is null");
        }
        if (orders == null) {
            throw new NullPointerException("orders is marked non-null but is null");
        }
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.gender = gender;
        this.birthDate = birthDate;
        this.height = height;
        this.children = children;
        this.married = married;
        this.address = address;
        this.visitedLocations = visitedLocations;
        this.favouriteProductCategory = favouriteProductCategory;
        this.orders = orders;
    }

    @Generated
    public static class PersonBuilder {
        @Generated
        private String firstName;
        @Generated
        private String lastName;
        @Generated
        private String email;
        @Generated
        private Person.Gender gender;
        @Generated
        private LocalDate birthDate;
        @Generated
        private BigDecimal height;
        @Generated
        private Integer children;
        @Generated
        private boolean married;
        @Generated
        private Address address;
        @Generated
        private boolean visitedLocations$set;
        @Generated
        private List<Location> visitedLocations$value;
        @Generated
        private ProductCategory favouriteProductCategory;
        @Generated
        private boolean orders$set;
        @Generated
        private List<Order> orders$value;

        @Generated
        PersonBuilder() {
        }

        @Generated
        public PersonBuilder firstName(@NonNull String firstName) {
            if (firstName == null) {
                throw new NullPointerException("firstName is marked non-null but is null");
            }
            this.firstName = firstName;
            return this;
        }

        @Generated
        public PersonBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        @Generated
        public PersonBuilder email(@NonNull String email) {
            if (email == null) {
                throw new NullPointerException("email is marked non-null but is null");
            }
            this.email = email;
            return this;
        }

        @Generated
        public PersonBuilder gender(@NonNull Person.Gender gender) {
            if (gender == null) {
                throw new NullPointerException("gender is marked non-null but is null");
            }
            this.gender = gender;
            return this;
        }

        @Generated
        public PersonBuilder birthDate(LocalDate birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        @Generated
        public PersonBuilder height(@NonNull BigDecimal height) {
            if (height == null) {
                throw new NullPointerException("height is marked non-null but is null");
            }
            this.height = height;
            return this;
        }

        @Generated
        public PersonBuilder children(@NonNull Integer children) {
            if (children == null) {
                throw new NullPointerException("children is marked non-null but is null");
            }
            this.children = children;
            return this;
        }

        @Generated
        public PersonBuilder married(boolean married) {
            this.married = married;
            return this;
        }

        @Generated
        public PersonBuilder address(@NonNull Address address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
            return this;
        }

        @Generated
        public PersonBuilder visitedLocations(@NonNull List<Location> visitedLocations) {
            if (visitedLocations == null) {
                throw new NullPointerException("visitedLocations is marked non-null but is null");
            }
            this.visitedLocations$value = visitedLocations;
            this.visitedLocations$set = true;
            return this;
        }

        @Generated
        public PersonBuilder favouriteProductCategory(@NonNull ProductCategory favouriteProductCategory) {
            if (favouriteProductCategory == null) {
                throw new NullPointerException("favouriteProductCategory is marked non-null but is null");
            }
            this.favouriteProductCategory = favouriteProductCategory;
            return this;
        }

        @Generated
        public PersonBuilder orders(@NonNull List<Order> orders) {
            if (orders == null) {
                throw new NullPointerException("orders is marked non-null but is null");
            }
            this.orders$value = orders;
            this.orders$set = true;
            return this;
        }

        @Generated
        public Person build() {
            List<Location> visitedLocations$value = this.visitedLocations$value;
            if (!this.visitedLocations$set) {
                visitedLocations$value = Person.$default$visitedLocations();
            }
            List<Order> orders$value = this.orders$value;
            if (!this.orders$set) {
                orders$value = Person.$default$orders();
            }
            return new Person(this.firstName, this.lastName, this.email, this.gender, this.birthDate, this.height, this.children, this.married, this.address, visitedLocations$value, this.favouriteProductCategory, orders$value);
        }

        @Generated
        public String toString() {
            return "Person.PersonBuilder(firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", gender=" + String.valueOf(this.gender) + ", birthDate=" + String.valueOf(this.birthDate) + ", height=" + String.valueOf(this.height) + ", children=" + this.children + ", married=" + this.married + ", address=" + String.valueOf(this.address) + ", visitedLocations$value=" + String.valueOf(this.visitedLocations$value) + ", favouriteProductCategory=" + String.valueOf(this.favouriteProductCategory) + ", orders$value=" + String.valueOf(this.orders$value) + ")";
        }
    }
}

