/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.jpa;

import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.Arrays;
import lombok.Generated;

class JpaPropertyUtils {
    static Path<?> getPath(Path<?> rootPath, String propertyName, Metamodel metamodel) {
        String[] propertyPath = propertyName.split("\\.");
        return JpaPropertyUtils.getPropertyPath(rootPath, propertyPath, metamodel);
    }

    private static <T, P> Path<P> getPropertyPath(Path<T> rootPath, String[] propertyPath, Metamodel metamodel) {
        String firstLevelProperty = propertyPath[0];
        Path<P> firstLevelPropertyPath = JpaPropertyUtils.getPropertyPath(rootPath, firstLevelProperty, metamodel);
        if (propertyPath.length == 1) {
            return firstLevelPropertyPath;
        }
        String[] remainingPath = JpaPropertyUtils.removeFirstElement(propertyPath);
        return JpaPropertyUtils.getPropertyPath(firstLevelPropertyPath, remainingPath, metamodel);
    }

    private static String[] removeFirstElement(String[] propertyPath) {
        return Arrays.copyOfRange(propertyPath, 1, propertyPath.length);
    }

    private static <T, P> Path<P> getPropertyPath(Path<T> rootPath, String propertyName, Metamodel metamodel) {
        Join<T, P> propertyPath = rootPath.get(propertyName);
        if (JpaPropertyUtils.needsJoin(rootPath, propertyName, metamodel)) {
            propertyPath = JpaPropertyUtils.getJoin((From)rootPath, propertyName);
        }
        return propertyPath;
    }

    private static <T> boolean needsJoin(Path<T> rootPath, String propertyName, Metamodel metamodel) {
        ManagedType rootMetadata = metamodel.managedType(rootPath.getModel().getBindableJavaType());
        Attribute attribute = rootMetadata.getAttribute(propertyName);
        return attribute.isAssociation() || attribute.isCollection();
    }

    private static <T, P> Join<T, P> getJoin(From<?, T> from, String joinProperty) {
        return from.getJoins().stream().filter(j -> j.getParentPath().equals(from) && j.getAttribute().getName().equals(joinProperty)).findFirst().orElseGet(() -> from.join(joinProperty, JoinType.LEFT));
    }

    @Generated
    private JpaPropertyUtils() {
    }
}

