/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.jpa;

import io.github.queritylib.querity.api.Condition;
import io.github.queritylib.querity.api.Pagination;
import io.github.queritylib.querity.api.Query;
import io.github.queritylib.querity.api.Sort;
import io.github.queritylib.querity.jpa.JpaCondition;
import io.github.queritylib.querity.jpa.JpaSort;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.Metamodel;
import java.util.List;

class JpaQueryFactory<T> {
    private final Class<T> entityClass;
    private final Query query;
    private final EntityManager entityManager;

    JpaQueryFactory(Class<T> entityClass, Query query, EntityManager entityManager) {
        this.entityClass = entityClass;
        this.query = query;
        this.entityManager = entityManager;
    }

    public TypedQuery<T> getJpaQuery() {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(this.entityClass);
        Root root = cq.from(this.entityClass);
        Metamodel metamodel = this.entityManager.getMetamodel();
        this.applyDistinct(cq);
        this.applyFilters(metamodel, root, cq, cb);
        this.applySorting(metamodel, root, cq, cb);
        TypedQuery tq = this.createTypedQuery(cq);
        this.applyPagination(tq);
        return tq;
    }

    private void applyDistinct(CriteriaQuery<T> cq) {
        if (this.query != null && this.query.isDistinct()) {
            cq.distinct(true);
        }
    }

    public TypedQuery<Long> getJpaCountQuery() {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root root = cq.from(this.entityClass);
        Metamodel metaModel = this.entityManager.getMetamodel();
        this.applySelectCount(root, (CriteriaQuery<Long>)cq, cb);
        this.applyFilters(metaModel, root, cq, cb);
        return this.createTypedQuery(cq);
    }

    private void applySelectCount(Root<T> root, CriteriaQuery<Long> cq, CriteriaBuilder cb) {
        cq.select((Selection)cb.countDistinct(root));
    }

    private void applyFilters(Metamodel metamodel, Root<T> root, CriteriaQuery<?> cq, CriteriaBuilder cb) {
        if (this.query != null && this.query.hasFilter()) {
            cq.where((Expression)JpaQueryFactory.getPredicate(this.entityClass, this.query.getFilter(), metamodel, root, cq, cb));
        }
    }

    private static <T> Predicate getPredicate(Class<T> entityClass, Condition filter, Metamodel metamodel, Root<T> root, CriteriaQuery<?> cq, CriteriaBuilder cb) {
        return JpaCondition.of(filter).toPredicate(entityClass, metamodel, root, cq, cb);
    }

    private void applySorting(Metamodel metamodel, Root<T> root, CriteriaQuery<T> cq, CriteriaBuilder cb) {
        if (this.query != null && this.query.hasSort()) {
            cq.orderBy(JpaQueryFactory.getOrders(this.query.getSort(), metamodel, root, cb));
        }
    }

    private static <T> List<Order> getOrders(List<Sort> sort, Metamodel metamodel, Root<T> root, CriteriaBuilder cb) {
        return sort.stream().map(JpaSort::new).map(jpaSort -> jpaSort.toOrder(metamodel, root, cb)).toList();
    }

    private void applyPagination(TypedQuery<T> tq) {
        if (this.query != null && this.query.hasPagination()) {
            JpaQueryFactory.applyPagination(this.query.getPagination(), tq);
        }
    }

    private static <T> void applyPagination(Pagination pagination, TypedQuery<T> tq) {
        tq.setMaxResults(pagination.getPageSize().intValue()).setFirstResult(pagination.getPageSize() * (pagination.getPage() - 1));
    }

    private <R> TypedQuery<R> createTypedQuery(CriteriaQuery<R> cq) {
        return this.entityManager.createQuery(cq);
    }
}

