/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.jpa;

import io.github.queritylib.querity.api.Operator;
import io.github.queritylib.querity.api.SimpleCondition;
import io.github.queritylib.querity.common.util.PropertyUtils;
import io.github.queritylib.querity.jpa.JpaPropertyUtils;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.Metamodel;
import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;

class JpaOperatorMapper {
    static final Map<Operator, JpaOperatorPredicateProvider> OPERATOR_PREDICATE_MAP = new EnumMap<Operator, JpaOperatorPredicateProvider>(Operator.class);

    private static Predicate getIsNull(Path<?> path, CriteriaBuilder cb) {
        return cb.isNull(path);
    }

    private static Predicate getIsNotNull(Path<?> path, CriteriaBuilder cb) {
        return cb.isNotNull(path);
    }

    private static Predicate getNotEquals(Path<?> path, Object value, CriteriaBuilder cb) {
        return cb.or((Expression)cb.notEqual(path, value), (Expression)JpaOperatorMapper.getIsNull(path, cb));
    }

    private static Predicate getEquals(Path<?> path, Object value, CriteriaBuilder cb) {
        return cb.and((Expression)cb.equal(path, value), (Expression)JpaOperatorMapper.getIsNotNull(path, cb));
    }

    private static Predicate getStartsWith(Path<?> path, Object value, CriteriaBuilder cb) {
        return JpaOperatorMapper.getLike(path, value.toString() + "%", cb);
    }

    private static Predicate getEndsWith(Path<?> path, Object value, CriteriaBuilder cb) {
        return JpaOperatorMapper.getLike(path, "%" + value.toString(), cb);
    }

    private static Predicate getContains(Path<?> path, Object value, CriteriaBuilder cb) {
        return JpaOperatorMapper.getLike(path, "%" + value.toString() + "%", cb);
    }

    private static Predicate getLike(Path<?> path, Object value, CriteriaBuilder cb) {
        return cb.and((Expression)cb.like(cb.lower(path.as(String.class)), value.toString().toLowerCase()), (Expression)JpaOperatorMapper.getIsNotNull(path, cb));
    }

    private static Predicate getGreaterThan(Path<?> path, Object value, CriteriaBuilder cb) {
        return cb.greaterThan(path, (Comparable)value);
    }

    private static Predicate getGreaterThanEquals(Path<?> path, Object value, CriteriaBuilder cb) {
        return cb.greaterThanOrEqualTo(path, (Comparable)value);
    }

    private static Predicate getLesserThan(Path<?> path, Object value, CriteriaBuilder cb) {
        return cb.lessThan(path, (Comparable)value);
    }

    private static Predicate getLesserThanEquals(Path<?> path, Object value, CriteriaBuilder cb) {
        return cb.lessThanOrEqualTo(path, (Comparable)value);
    }

    private static Predicate getIn(Path<?> path, Object value, CriteriaBuilder cb) {
        if (value.getClass().isArray()) {
            return cb.and((Expression)path.in((Object[])value), (Expression)JpaOperatorMapper.getIsNotNull(path, cb));
        }
        throw new IllegalArgumentException("Value must be an array");
    }

    private static Predicate getNotIn(Path<?> path, Object value, CriteriaBuilder cb) {
        return JpaOperatorMapper.getIn(path, value, cb).not();
    }

    public static <T> Predicate getPredicate(Class<T> entityClass, SimpleCondition condition, Metamodel metamodel, Root<?> root, CriteriaBuilder cb) {
        String propertyPath = condition.getPropertyName();
        Object value = PropertyUtils.getActualPropertyValue(entityClass, (String)propertyPath, (Object)condition.getValue());
        return OPERATOR_PREDICATE_MAP.get(condition.getOperator()).getPredicate(JpaPropertyUtils.getPath(root, propertyPath, metamodel), value, cb);
    }

    @Generated
    private JpaOperatorMapper() {
    }

    static {
        OPERATOR_PREDICATE_MAP.put(Operator.EQUALS, JpaOperatorMapper::getEquals);
        OPERATOR_PREDICATE_MAP.put(Operator.NOT_EQUALS, JpaOperatorMapper::getNotEquals);
        OPERATOR_PREDICATE_MAP.put(Operator.STARTS_WITH, JpaOperatorMapper::getStartsWith);
        OPERATOR_PREDICATE_MAP.put(Operator.ENDS_WITH, JpaOperatorMapper::getEndsWith);
        OPERATOR_PREDICATE_MAP.put(Operator.CONTAINS, JpaOperatorMapper::getContains);
        OPERATOR_PREDICATE_MAP.put(Operator.GREATER_THAN, JpaOperatorMapper::getGreaterThan);
        OPERATOR_PREDICATE_MAP.put(Operator.GREATER_THAN_EQUALS, JpaOperatorMapper::getGreaterThanEquals);
        OPERATOR_PREDICATE_MAP.put(Operator.LESSER_THAN, JpaOperatorMapper::getLesserThan);
        OPERATOR_PREDICATE_MAP.put(Operator.LESSER_THAN_EQUALS, JpaOperatorMapper::getLesserThanEquals);
        OPERATOR_PREDICATE_MAP.put(Operator.IS_NULL, (path, value, cb) -> JpaOperatorMapper.getIsNull(path, cb));
        OPERATOR_PREDICATE_MAP.put(Operator.IS_NOT_NULL, (path, value, cb) -> JpaOperatorMapper.getIsNotNull(path, cb));
        OPERATOR_PREDICATE_MAP.put(Operator.IN, JpaOperatorMapper::getIn);
        OPERATOR_PREDICATE_MAP.put(Operator.NOT_IN, JpaOperatorMapper::getNotIn);
    }

    @FunctionalInterface
    private static interface JpaOperatorPredicateProvider {
        public Predicate getPredicate(Path<?> var1, Object var2, CriteriaBuilder var3);
    }
}

