/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.jpa;

import io.github.queritylib.querity.api.Condition;
import io.github.queritylib.querity.api.Querity;
import io.github.queritylib.querity.api.Query;
import io.github.queritylib.querity.jpa.JpaQueryFactory;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import java.util.List;

public class QuerityJpaImpl
implements Querity {
    private final EntityManager entityManager;

    public QuerityJpaImpl(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public <T> List<T> findAll(Class<T> entityClass, Query query) {
        TypedQuery<Tuple> jpaQuery = this.getJpaQueryFactory(entityClass, query).getJpaQuery();
        return jpaQuery.getResultList().stream().map(t -> t.get(0, entityClass)).toList();
    }

    public <T> Long count(Class<T> entityClass, Condition condition) {
        Query query = Querity.wrapConditionInQuery((Condition)condition);
        TypedQuery<Long> jpaQuery = this.getJpaQueryFactory(entityClass, query).getJpaCountQuery();
        return (Long)jpaQuery.getSingleResult();
    }

    protected <T> JpaQueryFactory<T> getJpaQueryFactory(Class<T> entityClass, Query query) {
        return new JpaQueryFactory<T>(entityClass, query, this.entityManager);
    }
}

