/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.parser;

import io.github.queritylib.querity.api.AndConditionsWrapper;
import io.github.queritylib.querity.api.Condition;
import io.github.queritylib.querity.api.NotCondition;
import io.github.queritylib.querity.api.Operator;
import io.github.queritylib.querity.api.OrConditionsWrapper;
import io.github.queritylib.querity.api.Pagination;
import io.github.queritylib.querity.api.Querity;
import io.github.queritylib.querity.api.Query;
import io.github.queritylib.querity.api.SimpleCondition;
import io.github.queritylib.querity.api.Sort;
import io.github.queritylib.querity.parser.QueryParser;
import io.github.queritylib.querity.parser.QueryParserBaseVisitor;
import java.math.BigDecimal;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

class QueryVisitor
extends QueryParserBaseVisitor<Object> {
    QueryVisitor() {
    }

    @Override
    public Query visitQuery(QueryParser.QueryContext ctx) {
        boolean distinct = ctx.DISTINCT() != null;
        Condition filter = ctx.condition() != null ? (Condition)this.visit((ParseTree)ctx.condition()) : null;
        Sort[] sorts = ctx.SORT() != null ? (Sort[])this.visit((ParseTree)ctx.sortFields()) : new Sort[]{};
        Pagination pagination = ctx.PAGINATION() != null ? (Pagination)this.visit((ParseTree)ctx.paginationParams()) : null;
        return Querity.query().distinct(distinct).filter(filter).pagination(pagination).sort(sorts).build();
    }

    @Override
    public Object visitPaginationParams(QueryParser.PaginationParamsContext ctx) {
        return Pagination.builder().page(Integer.valueOf(Integer.parseInt(ctx.INT_VALUE(0).getText()))).pageSize(Integer.valueOf(Integer.parseInt(ctx.INT_VALUE(1).getText()))).build();
    }

    @Override
    public Object visitCondition(QueryParser.ConditionContext ctx) {
        if (ctx.conditionWrapper() != null) {
            return this.visit((ParseTree)ctx.conditionWrapper());
        }
        if (ctx.notCondition() != null) {
            return this.visit((ParseTree)ctx.notCondition());
        }
        return this.visit((ParseTree)ctx.simpleCondition());
    }

    @Override
    public Condition visitConditionWrapper(QueryParser.ConditionWrapperContext ctx) {
        List<Condition> conditions = ctx.condition().stream().map(arg_0 -> ((QueryVisitor)this).visit(arg_0)).map(Condition.class::cast).toList();
        if (ctx.AND() != null) {
            return AndConditionsWrapper.builder().conditions(conditions).build();
        }
        return OrConditionsWrapper.builder().conditions(conditions).build();
    }

    @Override
    public Object visitNotCondition(QueryParser.NotConditionContext ctx) {
        Condition condition = (Condition)this.visit((ParseTree)ctx.condition());
        return NotCondition.builder().condition(condition).build();
    }

    @Override
    public Condition visitSimpleCondition(QueryParser.SimpleConditionContext ctx) {
        String propertyName = ctx.PROPERTY().getText();
        Operator operator = (Operator)this.visit((ParseTree)ctx.operator());
        Object value = null;
        if (operator.getRequiredValuesCount() > 0) {
            if (ctx.arrayValue() != null) {
                value = this.visitArrayValue(ctx.arrayValue());
            } else if (ctx.simpleValue() != null) {
                value = this.visitSimpleValue(ctx.simpleValue());
            }
        }
        return SimpleCondition.builder().propertyName(propertyName).operator(operator).value(value).build();
    }

    @Override
    public Object visitSimpleValue(QueryParser.SimpleValueContext ctx) {
        Object value = ctx.INT_VALUE() != null ? Integer.valueOf(Integer.parseInt(ctx.INT_VALUE().getText())) : (ctx.DECIMAL_VALUE() != null ? new BigDecimal(ctx.DECIMAL_VALUE().getText()) : (ctx.BOOLEAN_VALUE() != null ? Boolean.valueOf(ctx.BOOLEAN_VALUE().getText()) : ctx.STRING_VALUE().getText().replace("\"", "")));
        return value;
    }

    @Override
    public Object visitArrayValue(QueryParser.ArrayValueContext ctx) {
        return ctx.simpleValue().stream().map(this::visitSimpleValue).toArray();
    }

    @Override
    public Object visitOperator(QueryParser.OperatorContext ctx) {
        if (ctx.GTE() != null) {
            return Operator.GREATER_THAN_EQUALS;
        }
        if (ctx.LTE() != null) {
            return Operator.LESSER_THAN_EQUALS;
        }
        if (ctx.GT() != null) {
            return Operator.GREATER_THAN;
        }
        if (ctx.LT() != null) {
            return Operator.LESSER_THAN;
        }
        if (ctx.EQ() != null) {
            return Operator.EQUALS;
        }
        if (ctx.NEQ() != null) {
            return Operator.NOT_EQUALS;
        }
        if (ctx.STARTS_WITH() != null) {
            return Operator.STARTS_WITH;
        }
        if (ctx.ENDS_WITH() != null) {
            return Operator.ENDS_WITH;
        }
        if (ctx.CONTAINS() != null) {
            return Operator.CONTAINS;
        }
        if (ctx.IS_NULL() != null) {
            return Operator.IS_NULL;
        }
        if (ctx.IS_NOT_NULL() != null) {
            return Operator.IS_NOT_NULL;
        }
        if (ctx.IN() != null) {
            return Operator.IN;
        }
        if (ctx.NOT_IN() != null) {
            return Operator.NOT_IN;
        }
        throw new UnsupportedOperationException("Unsupported operator: " + ctx.getText());
    }

    @Override
    public Object visitSortFields(QueryParser.SortFieldsContext ctx) {
        return ctx.sortField().stream().map(arg_0 -> ((QueryVisitor)this).visit(arg_0)).map(Sort.class::cast).toArray(Sort[]::new);
    }

    @Override
    public Object visitSortField(QueryParser.SortFieldContext ctx) {
        return Querity.sortBy((String)ctx.PROPERTY().getText(), (Sort.Direction)(ctx.direction() != null ? (Sort.Direction)this.visit((ParseTree)ctx.direction()) : Sort.Direction.ASC));
    }

    @Override
    public Object visitDirection(QueryParser.DirectionContext ctx) {
        if (ctx.ASC() != null) {
            return Sort.Direction.ASC;
        }
        return Sort.Direction.DESC;
    }
}

