/*
 * Decompiled with CFR 0.152.
 */
package io.github.queritylib.querity.test;

import io.github.queritylib.querity.api.Condition;
import io.github.queritylib.querity.api.Operator;
import io.github.queritylib.querity.api.Querity;
import io.github.queritylib.querity.api.Query;
import io.github.queritylib.querity.api.Sort;
import io.github.queritylib.querity.test.DatabaseSeeder;
import io.github.queritylib.querity.test.domain.Location;
import io.github.queritylib.querity.test.domain.Order;
import io.github.queritylib.querity.test.domain.OrderItem;
import io.github.queritylib.querity.test.domain.Person;
import io.github.queritylib.querity.test.domain.ProductCategory;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public abstract class QuerityGenericTestSuite<T extends Person<K, ?, ?, ? extends Order<? extends OrderItem>>, K extends Comparable<K>> {
    protected DatabaseSeeder<T> databaseSeeder;
    protected Querity querity;
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_LAST_NAME = "lastName";
    public static final String PROPERTY_FIRST_NAME = "firstName";
    public static final String PROPERTY_BIRTH_DATE = "birthDate";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_CHILDREN = "children";
    public static final String PROPERTY_MARRIED = "married";
    public static final String PROPERTY_ADDRESS_CITY = "address.city";
    public static final String PROPERTY_VISITED_LOCATIONS_COUNTRY = "visitedLocations.country";
    public static final String PROPERTY_VISITED_LOCATIONS_CITIES = "visitedLocations.cities";
    public static final String PROPERTY_FAVOURITE_PRODUCT_CATEGORY = "favouriteProductCategory";
    public static final String PROPERTY_ORDERS_EXTERNAL_ID = "orders.externalId";
    protected List<T> entities;
    protected T entity1;
    protected T entity2;

    protected abstract DatabaseSeeder<T> getDatabaseSeeder();

    protected abstract Querity getQuerity();

    @BeforeEach
    void setUp() {
        this.databaseSeeder = this.getDatabaseSeeder();
        this.querity = this.getQuerity();
        this.entities = this.databaseSeeder.getEntities();
        Assertions.assertThat(this.entities).isNotEmpty();
        this.entity1 = this.getEntityFromList(20);
        this.entity2 = this.getEntityFromList(30);
    }

    private List<T> findByOrderContainingItemMatching(Predicate<OrderItem> matchPredicate) {
        return this.entities.stream().filter(p -> p.getOrders().stream().map(Order::getItems).flatMap(Collection::stream).anyMatch(matchPredicate)).toList();
    }

    protected abstract Class<T> getEntityClass();

    private T getEntityFromList(int skip) {
        return (T)this.entities.stream().filter(e -> e.getLastName() != null).filter(e -> e.getLastName().length() >= 5).filter(e -> e.getBirthDate() != null).filter(e -> e.getChildren() > 0).filter(e -> !e.getVisitedLocations().isEmpty()).filter(e -> !((Location)e.getVisitedLocations().get(0)).getCities().isEmpty()).filter(e -> !e.getOrders().isEmpty()).skip(skip).limit(1L).findAny().orElseThrow(() -> new IllegalStateException("No entities found"));
    }

    protected <C> Comparator<C> getStringComparator(Function<C, String> extractValueFunction) {
        return this.getStringComparator(extractValueFunction, false);
    }

    protected <C> Comparator<C> getStringComparator(Function<C, String> extractValueFunction, boolean reversed) {
        return Comparator.comparing(extractValueFunction, this.getSortComparator(reversed));
    }

    protected <C extends Comparable<? super C>> Comparator<C> getSortComparator() {
        return this.getSortComparator(false);
    }

    protected <C extends Comparable<? super C>> Comparator<C> getSortComparator(boolean reversed) {
        Comparator comparator = Comparator.nullsLast(Comparator.naturalOrder());
        if (reversed) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    @Nested
    class CountTests {
        CountTests() {
        }

        @Test
        void givenNullQuery_whenCount_thenReturnAllTheElementsCount() {
            Long count = QuerityGenericTestSuite.this.querity.count(QuerityGenericTestSuite.this.getEntityClass(), null);
            Assertions.assertThat((Long)count).isEqualTo((long)QuerityGenericTestSuite.this.entities.size());
        }

        @Test
        void givenEmptyFilter_whenCount_thenReturnAllTheElementsCount() {
            Long count = QuerityGenericTestSuite.this.querity.count(QuerityGenericTestSuite.this.getEntityClass(), (Condition)Querity.and((Condition[])new Condition[0]));
            Assertions.assertThat((Long)count).isEqualTo((long)QuerityGenericTestSuite.this.entities.size());
        }

        @Test
        void givenFilterWithStringEqualsCondition_whenCount_thenReturnOnlyFilteredElementsCount() {
            Long count = QuerityGenericTestSuite.this.querity.count(QuerityGenericTestSuite.this.getEntityClass(), (Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getLastName()));
            Assertions.assertThat((Long)count).isEqualTo(QuerityGenericTestSuite.this.entities.stream().filter(e -> QuerityGenericTestSuite.this.entity1.getLastName().equals(e.getLastName())).count());
        }

        @Test
        void givenFilterWithNumberGreaterThanConditionOnDoubleNestedCollectionItemField_whenCount_thenReturnOnlyFilteredElementsCount() {
            int quantity = 8;
            Long count = QuerityGenericTestSuite.this.querity.count(QuerityGenericTestSuite.this.getEntityClass(), (Condition)Querity.filterBy((String)"orders.items.quantity", (Operator)Operator.GREATER_THAN, (Object)quantity));
            Assertions.assertThat((Long)count).isEqualTo((long)QuerityGenericTestSuite.this.findByOrderContainingItemMatching(i -> i.getQuantity() > quantity).size());
        }
    }

    @Nested
    class SortingTests {
        SortingTests() {
        }

        @Test
        void givenSortByFieldAscending_whenFindAll_thenReturnSortedElements() {
            Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME), Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_ID)}).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Comparator<Person> comparator = QuerityGenericTestSuite.this.getStringComparator(p -> p.getLastName()).thenComparing(p -> p.getId());
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).hasSize(QuerityGenericTestSuite.this.entities.size());
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericTestSuite.this.entities.stream().sorted(comparator).toList());
        }

        @Test
        void givenSortByDateField_whenFindAll_thenReturnSortedElements() {
            Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_BIRTH_DATE), Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_ID)}).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Comparator<Person> comparator = Comparator.comparing(p -> p.getBirthDate(), QuerityGenericTestSuite.this.getSortComparator()).thenComparing(p -> p.getId());
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericTestSuite.this.entities.stream().sorted(comparator).toList());
        }

        @Test
        void givenSortByFieldDescending_whenFindAll_thenReturnSortedElements() {
            Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Sort.Direction)Sort.Direction.DESC), Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_ID)}).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Comparator<Person> comparator = QuerityGenericTestSuite.this.getStringComparator(p -> p.getLastName(), true).thenComparing(p -> p.getId());
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).hasSize(QuerityGenericTestSuite.this.entities.size());
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericTestSuite.this.entities.stream().sorted(comparator).toList());
        }

        @Test
        void givenSortByNestedField_whenFindAll_thenReturnSortedElements() {
            Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_ADDRESS_CITY), Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_ID)}).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Comparator<Person> comparator = QuerityGenericTestSuite.this.getStringComparator(p -> p.getAddress().getCity()).thenComparing(p -> p.getId());
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).hasSize(QuerityGenericTestSuite.this.entities.size());
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericTestSuite.this.entities.stream().sorted(comparator).toList());
        }

        @Test
        void givenSortByNestedFieldWithDistinct_whenFindAll_thenReturnSortedElements() {
            Query query = Querity.query().distinct(true).sort(new Sort[]{Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_ADDRESS_CITY), Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_ID)}).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Comparator<Person> comparator = QuerityGenericTestSuite.this.getStringComparator(t -> t.getAddress().getCity()).thenComparing(Person::getId);
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().sorted(comparator).toList());
        }

        @Test
        void givenSortByMultipleFields_whenFindAll_thenReturnSortedElements() {
            Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME), Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_FIRST_NAME)}).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Comparator<Person> comparator = QuerityGenericTestSuite.this.getStringComparator(p -> p.getLastName()).thenComparing(p -> p.getFirstName());
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).isEqualTo(QuerityGenericTestSuite.this.entities.stream().sorted(comparator).toList());
        }
    }

    @Nested
    class PaginationTests {
        PaginationTests() {
        }

        @Test
        void givenPagination_whenFindAll_thenReturnThePageElements() {
            Query query = Querity.query().sort(new Sort[]{Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_ID)}).pagination(Integer.valueOf(2), Integer.valueOf(3)).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyElementsOf(QuerityGenericTestSuite.this.entities.stream().sorted(Comparator.comparing(Person::getId)).skip(3L).limit(3L).toList());
        }
    }

    @Nested
    class FilteringTests {
        FilteringTests() {
        }

        @Test
        void givenNullQuery_whenFindAll_thenReturnAllTheElements() {
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), null);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities);
        }

        @Test
        void givenEmptyFilter_whenFindAll_thenReturnAllTheElements() {
            Query query = Querity.query().build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities);
        }

        @Test
        void givenFilterByIdEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_ID, (Operator)Operator.EQUALS, QuerityGenericTestSuite.this.entity1.getId())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).hasSize(1);
            Assertions.assertThat((List)result).containsExactly((Object[])new Person[]{QuerityGenericTestSuite.this.entity1});
        }

        @Test
        void givenFilterWithStringEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getLastName())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> QuerityGenericTestSuite.this.entity1.getLastName().equals(p.getLastName())).toList());
        }

        @Test
        void givenFilterWithIntegerEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_CHILDREN, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getChildren())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getChildren() != null && p.getChildren().equals(QuerityGenericTestSuite.this.entity1.getChildren())).toList());
        }

        @Test
        void givenFilterWithIntegerAsStringEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_CHILDREN, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getChildren().toString())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getChildren() != null && p.getChildren().equals(QuerityGenericTestSuite.this.entity1.getChildren())).toList());
        }

        @Test
        void givenFilterWithDateEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_BIRTH_DATE, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getBirthDate())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getBirthDate() != null && p.getBirthDate().isEqual(QuerityGenericTestSuite.this.entity1.getBirthDate())).toList());
        }

        @Test
        void givenFilterWithDateAsStringEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_BIRTH_DATE, (Operator)Operator.EQUALS, (Object)this.formatDate(QuerityGenericTestSuite.this.entity1.getBirthDate()))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getBirthDate() != null && p.getBirthDate().isEqual(QuerityGenericTestSuite.this.entity1.getBirthDate())).toList());
        }

        @Test
        void givenFilterWithBooleanEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_MARRIED, (Operator)Operator.EQUALS, (Object)true)).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(Person::isMarried).toList());
        }

        @Test
        void givenFilterWithBooleanAsStringEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_MARRIED, (Operator)Operator.EQUALS, (Object)Boolean.TRUE.toString())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(Person::isMarried).toList());
        }

        @Test
        void givenFilterWithUUIDEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            UUID anOrderExternalId = ((Order)QuerityGenericTestSuite.this.entity1.getOrders().get(0)).getExternalId();
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_ORDERS_EXTERNAL_ID, (Operator)Operator.EQUALS, (Object)anOrderExternalId)).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getOrders().stream().anyMatch(l -> l.getExternalId().equals(anOrderExternalId))).toList());
        }

        @Test
        void givenFilterWithUUIDAsStringEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            UUID anOrderExternalId = ((Order)QuerityGenericTestSuite.this.entity1.getOrders().get(0)).getExternalId();
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_ORDERS_EXTERNAL_ID, (Operator)Operator.EQUALS, (Object)anOrderExternalId.toString())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getOrders().stream().anyMatch(l -> l.getExternalId().equals(anOrderExternalId))).toList());
        }

        @Test
        void givenFilterWithBigDecimalEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_HEIGHT, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getHeight())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericTestSuite.this.entity1.getHeight()) == 0).toList());
        }

        @Test
        void givenFilterWithBigDecimalEqualsConditionAsString_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_HEIGHT, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getHeight().toString())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericTestSuite.this.entity1.getHeight()) == 0).toList());
        }

        @Test
        void givenFilterWithBigDecimalGreaterThanCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_HEIGHT, (Operator)Operator.GREATER_THAN, (Object)QuerityGenericTestSuite.this.entity1.getHeight().toString())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericTestSuite.this.entity1.getHeight()) > 0).toList());
        }

        @Test
        void givenFilterWithNotBigDecimalGreaterThanCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_HEIGHT, (Operator)Operator.GREATER_THAN, (Object)QuerityGenericTestSuite.this.entity1.getHeight().toString()))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericTestSuite.this.entity1.getHeight()) <= 0).toList());
        }

        @Test
        void givenFilterWithBigDecimalGreaterThanEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_HEIGHT, (Operator)Operator.GREATER_THAN_EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getHeight().toString())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericTestSuite.this.entity1.getHeight()) >= 0).toList());
        }

        @Test
        void givenFilterWithNotBigDecimalGreaterThanEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_HEIGHT, (Operator)Operator.GREATER_THAN_EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getHeight().toString()))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericTestSuite.this.entity1.getHeight()) < 0).toList());
        }

        @Test
        void givenFilterWithBigDecimalLesserThanCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_HEIGHT, (Operator)Operator.LESSER_THAN, (Object)QuerityGenericTestSuite.this.entity1.getHeight().toString())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericTestSuite.this.entity1.getHeight()) < 0).toList());
        }

        @Test
        void givenFilterWithNotBigDecimalLesserThanCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_HEIGHT, (Operator)Operator.LESSER_THAN, (Object)QuerityGenericTestSuite.this.entity1.getHeight().toString()))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericTestSuite.this.entity1.getHeight()) >= 0).toList());
        }

        @Test
        void givenFilterWithBigDecimalLesserThanEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_HEIGHT, (Operator)Operator.LESSER_THAN_EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getHeight().toString())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericTestSuite.this.entity1.getHeight()) <= 0).toList());
        }

        @Test
        void givenFilterWithNotBigDecimalLesserThanEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_HEIGHT, (Operator)Operator.LESSER_THAN_EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getHeight().toString()))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getHeight().compareTo(QuerityGenericTestSuite.this.entity1.getHeight()) > 0).toList());
        }

        @Test
        void givenFilterWithStringNotEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.NOT_EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getLastName())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> !QuerityGenericTestSuite.this.entity1.getLastName().equals(p.getLastName())).toList());
        }

        @Test
        void givenFilterWithNotStringNotEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.NOT_EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getLastName()))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> QuerityGenericTestSuite.this.entity1.getLastName().equals(p.getLastName())).toList());
        }

        @Test
        void givenFilterWithStringStartsWithCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            String prefix = QuerityGenericTestSuite.this.entity1.getLastName().substring(0, 3);
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.STARTS_WITH, (Object)prefix)).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getLastName() != null && p.getLastName().startsWith(prefix)).toList());
        }

        @Test
        void givenFilterWithStringEndsWithCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            String suffix = QuerityGenericTestSuite.this.entity1.getLastName().substring(3);
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.ENDS_WITH, (Object)suffix)).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getLastName() != null && p.getLastName().endsWith(suffix)).toList());
        }

        @Test
        void givenFilterWithStringContainsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            String substring = QuerityGenericTestSuite.this.entity1.getLastName().substring(1, 3);
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.CONTAINS, (Object)substring)).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getLastName() != null && p.getLastName().contains(substring)).toList());
        }

        @Test
        void givenFilterWithStringNotContainsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            String substring = QuerityGenericTestSuite.this.entity1.getLastName().substring(1, 3);
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.CONTAINS, (Object)substring))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getLastName() == null || !p.getLastName().contains(substring)).toList());
        }

        @Test
        void givenFilterWithStringIsNullCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.IS_NULL)).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getLastName() == null).toList());
        }

        @Test
        void givenFilterWithStringIsNotNullCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.IS_NOT_NULL)).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getLastName() != null).toList());
        }

        @Test
        void givenFilterWithNotStringIsNotNullCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.IS_NOT_NULL))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getLastName() == null).toList());
        }

        @Test
        void givenFilterWithInListCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.IN, List.of(QuerityGenericTestSuite.this.entity1.getLastName(), QuerityGenericTestSuite.this.entity2.getLastName()))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getLastName() != null && List.of(QuerityGenericTestSuite.this.entity1.getLastName(), QuerityGenericTestSuite.this.entity2.getLastName()).contains(p.getLastName())).toList());
        }

        @Test
        void givenFilterWithInArrayCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.IN, (Object)new String[]{QuerityGenericTestSuite.this.entity1.getLastName(), QuerityGenericTestSuite.this.entity2.getLastName()})).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getLastName() != null && List.of(QuerityGenericTestSuite.this.entity1.getLastName(), QuerityGenericTestSuite.this.entity2.getLastName()).contains(p.getLastName())).toList());
        }

        @Test
        void givenFilterWithInConditionWithStringValue_whenFindAll_thenThrowIllegalArgumentException() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.IN, (Object)QuerityGenericTestSuite.this.entity1.getLastName())).build();
            Assertions.assertThatIllegalArgumentException().isThrownBy(() -> QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query)).withMessage("Value must be an array");
        }

        @Test
        void givenFilterWithNotInListCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.NOT_IN, List.of(QuerityGenericTestSuite.this.entity1.getLastName(), QuerityGenericTestSuite.this.entity2.getLastName()))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getLastName() == null || !List.of(QuerityGenericTestSuite.this.entity1.getLastName(), QuerityGenericTestSuite.this.entity2.getLastName()).contains(p.getLastName())).toList());
        }

        @Test
        void givenFilterWithNotInArrayCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.NOT_IN, (Object)new String[]{QuerityGenericTestSuite.this.entity1.getLastName(), QuerityGenericTestSuite.this.entity2.getLastName()})).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getLastName() == null || !List.of(QuerityGenericTestSuite.this.entity1.getLastName(), QuerityGenericTestSuite.this.entity2.getLastName()).contains(p.getLastName())).toList());
        }

        @Test
        void givenFilterWithNotInConditionWithStringValue_whenFindAll_thenThrowIllegalArgumentException() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.NOT_IN, (Object)QuerityGenericTestSuite.this.entity1.getLastName())).build();
            Assertions.assertThatIllegalArgumentException().isThrownBy(() -> QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query)).withMessage("Value must be an array");
        }

        @Test
        void givenFilterWithTwoStringEqualsConditionsWithAndLogic_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getLastName()), Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_FIRST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getFirstName())})).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> QuerityGenericTestSuite.this.entity1.getLastName().equals(p.getLastName()) && QuerityGenericTestSuite.this.entity1.getFirstName().equals(p.getFirstName())).toList());
        }

        @Test
        void givenFilterWithTwoStringEqualsConditionsWithOrLogic_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.or((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getLastName()), Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity2.getLastName())})).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> QuerityGenericTestSuite.this.entity1.getLastName().equals(p.getLastName()) || QuerityGenericTestSuite.this.entity2.getLastName().equals(p.getLastName())).toList());
        }

        @Test
        void givenFilterWithNestedConditions_whenFindAll_thenReturnListOfEntity() {
            Query query = Querity.query().filter((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getLastName()), Querity.or((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_FIRST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getFirstName()), Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_FIRST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity2.getFirstName())})})).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> QuerityGenericTestSuite.this.entity1.getLastName().equals(p.getLastName()) && (QuerityGenericTestSuite.this.entity1.getFirstName().equals(p.getFirstName()) || QuerityGenericTestSuite.this.entity2.getFirstName().equals(p.getFirstName()))).toList());
        }

        @Test
        void givenFilterWithStringEqualsConditionOnNestedField_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_ADDRESS_CITY, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getAddress().getCity())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> QuerityGenericTestSuite.this.entity1.getAddress().getCity().equals(p.getAddress().getCity())).toList());
        }

        @Test
        void givenFilterWithStringEqualsConditionOnNestedCollectionItemField_whenFindAll_thenReturnOnlyFilteredElements() {
            String visitedCountry = ((Location)QuerityGenericTestSuite.this.entity1.getVisitedLocations().get(0)).getCountry();
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_VISITED_LOCATIONS_COUNTRY, (Operator)Operator.EQUALS, (Object)visitedCountry)).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getVisitedLocations().stream().map(Location::getCountry).anyMatch(visitedCountry::equals)).toList());
        }

        @Test
        void givenFilterWithStringEqualsConditionOnNestedCollectionItemStringListField_whenFindAll_thenReturnOnlyFilteredElements() {
            String visitedCity = ((Location)QuerityGenericTestSuite.this.entity1.getVisitedLocations().get(0)).getCities().get(0);
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_VISITED_LOCATIONS_CITIES, (Operator)Operator.EQUALS, (Object)visitedCity)).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getVisitedLocations().stream().anyMatch(l -> l.getCities().contains(visitedCity))).toList());
        }

        @Test
        void givenFilterWithTwoStringEqualsConditionOnNestedCollectionItemFieldsWithAndLogic_whenFindAll_thenReturnOnlyFilteredElements() {
            String visitedCountry = ((Location)QuerityGenericTestSuite.this.entity1.getVisitedLocations().get(0)).getCountry();
            String visitedCity = ((Location)QuerityGenericTestSuite.this.entity1.getVisitedLocations().get(0)).getCities().get(0);
            Query query = Querity.query().filter((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_VISITED_LOCATIONS_COUNTRY, (Operator)Operator.EQUALS, (Object)visitedCountry), Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_VISITED_LOCATIONS_CITIES, (Operator)Operator.EQUALS, (Object)visitedCity)})).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> p.getVisitedLocations().stream().anyMatch(l -> visitedCountry.equals(l.getCountry()) && l.getCities().contains(visitedCity))).toList());
        }

        @Test
        void givenFilterWithStringEqualsConditionOnDoubleNestedCollectionItemField_whenFindAll_thenReturnOnlyFilteredElements() {
            String sku = ((OrderItem)((Order)QuerityGenericTestSuite.this.entity1.getOrders().get(0)).getItems().get(0)).getSku();
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)"orders.items.sku", (Operator)Operator.EQUALS, (Object)sku)).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.findByOrderContainingItemMatching(i -> i.getSku().equals(sku)));
        }

        @Test
        void givenFilterWithNumberGreaterThanConditionOnDoubleNestedCollectionItemFieldAndDistinctAndSortAndPagination_whenFindAll_thenReturnOnlyFilteredElements() {
            int quantity = 8;
            Query query = Querity.query().distinct(true).filter((Condition)Querity.filterBy((String)"orders.items.quantity", (Operator)Operator.GREATER_THAN, (Object)quantity)).sort(new Sort[]{Querity.sortBy((String)QuerityGenericTestSuite.PROPERTY_ID)}).pagination(Integer.valueOf(1), Integer.valueOf(10)).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.findByOrderContainingItemMatching(i -> i.getQuantity() > quantity).stream().sorted(Comparator.comparing(Person::getId)).skip(0L).limit(10L).toList());
        }

        @Test
        void givenFilterWithEnumEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            ProductCategory category = QuerityGenericTestSuite.this.entity1.getFavouriteProductCategory();
            Query query = Querity.query().filter((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_FAVOURITE_PRODUCT_CATEGORY, (Operator)Operator.EQUALS, (Object)category.name())).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(e -> e.getFavouriteProductCategory().equals((Object)category)).toList());
        }

        @Test
        void givenFilterWithNotConditionWithStringEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getLastName()))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> !QuerityGenericTestSuite.this.entity1.getLastName().equals(p.getLastName())).toList());
        }

        @Test
        void givenFilterWithTwoNestedNotConditionsWithStringEqualsCondition_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.not((Condition)Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getLastName())))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> QuerityGenericTestSuite.this.entity1.getLastName().equals(p.getLastName())).toList());
        }

        @Test
        void givenFilterWithNotConditionWithTwoStringEqualsConditionsWithAndLogic_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getLastName()), Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_FIRST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getFirstName())}))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> !QuerityGenericTestSuite.this.entity1.getLastName().equals(p.getLastName()) || !QuerityGenericTestSuite.this.entity1.getFirstName().equals(p.getFirstName())).toList());
        }

        @Test
        void givenFilterWithNotConditionWithTwoStringEqualsConditionsWithOrLogic_whenFindAll_thenReturnOnlyFilteredElements() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.or((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getLastName()), Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity2.getLastName())}))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> !QuerityGenericTestSuite.this.entity1.getLastName().equals(p.getLastName()) && !QuerityGenericTestSuite.this.entity2.getLastName().equals(p.getLastName())).toList());
        }

        @Test
        void givenFilterWithNotConditionWithNestedConditions_whenFindAll_thenReturnListOfEntity() {
            Query query = Querity.query().filter((Condition)Querity.not((Condition)Querity.and((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_LAST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getLastName()), Querity.or((Condition[])new Condition[]{Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_FIRST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity1.getFirstName()), Querity.filterBy((String)QuerityGenericTestSuite.PROPERTY_FIRST_NAME, (Operator)Operator.EQUALS, (Object)QuerityGenericTestSuite.this.entity2.getFirstName())})}))).build();
            List result = QuerityGenericTestSuite.this.querity.findAll(QuerityGenericTestSuite.this.getEntityClass(), query);
            Assertions.assertThat((List)result).isNotEmpty();
            Assertions.assertThat((List)result).containsExactlyInAnyOrderElementsOf(QuerityGenericTestSuite.this.entities.stream().filter(p -> !QuerityGenericTestSuite.this.entity1.getLastName().equals(p.getLastName()) || !QuerityGenericTestSuite.this.entity1.getFirstName().equals(p.getFirstName()) && !QuerityGenericTestSuite.this.entity2.getFirstName().equals(p.getFirstName())).toList());
        }

        private String formatDate(LocalDate birthDate) {
            return birthDate.format(DateTimeFormatter.ISO_DATE);
        }
    }
}

