/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Message;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import razerdp.basepopup.BasePopupEvent;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.basepopup.PopupMaskLayout;
import razerdp.util.KeyboardUtils;
import razerdp.util.PopupUiUtils;

final class PopupDecorViewProxy
extends ViewGroup
implements KeyboardUtils.OnKeyboardChangeListener,
BasePopupEvent.EventObserver,
ClearMemoryObject {
    private static final String TAG = "PopupDecorViewProxy";
    private PopupMaskLayout mMaskLayout;
    private BasePopupHelper mHelper;
    private View mTarget;
    private Rect popupRect = new Rect();
    private Rect anchorRect = new Rect();
    private Rect contentRect = new Rect();
    private Rect contentBounds = new Rect();
    private Rect touchableRect = new Rect();
    private Rect touchableRectOnNoKeyboard = new Rect();
    private int childLeftMargin;
    private int childTopMargin;
    private int childRightMargin;
    private int childBottomMargin;
    private int[] location = new int[2];
    private Rect lastKeyboardBounds = new Rect();
    private View.OnClickListener emptyInterceptClickListener = new View.OnClickListener(){

        public void onClick(View v) {
        }
    };
    private boolean isStatusBarVisible = true;
    Rect keyboardBoundsCache;
    boolean keyboardVisibleCache = false;
    int lastKeyboardOffset = 0;

    private PopupDecorViewProxy(Context context) {
        super(context);
    }

    PopupDecorViewProxy(Context context, BasePopupHelper helper) {
        this(context);
        this.isStatusBarVisible = PopupUiUtils.isStatusBarVisible(context);
        this.init(helper);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void init(BasePopupHelper helper) {
        this.mHelper = helper;
        this.mHelper.observerEvent(this, this);
        this.mHelper.mKeyboardStateChangeListener = this;
        this.setClipChildren(this.mHelper.isClipChildren());
        this.mMaskLayout = new PopupMaskLayout(this.getContext(), this.mHelper);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.addViewInLayout((View)this.mMaskLayout, -1, new ViewGroup.LayoutParams(-1, -1));
    }

    public void wrapPopupDecorView(View target, WindowManager.LayoutParams params) {
        if (target == null) {
            throw new NullPointerException("contentView\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (target.getParent() != null) {
            return;
        }
        int childCount = this.getChildCount();
        if (childCount >= 2) {
            this.removeViewsInLayout(1, childCount - 1);
        }
        this.mTarget = target;
        WindowManager.LayoutParams wp = new WindowManager.LayoutParams();
        wp.copyFrom(params);
        wp.x = 0;
        wp.y = 0;
        View contentView = target.findViewById(this.mHelper.contentRootId);
        if (contentView != null) {
            if (!contentView.hasOnClickListeners()) {
                this.mTarget.setOnClickListener(this.emptyInterceptClickListener);
            } else {
                this.mTarget.setOnClickListener(null);
            }
            ViewGroup.LayoutParams lp = contentView.getLayoutParams();
            if (lp == null) {
                lp = new FrameLayout.LayoutParams(this.mHelper.getLayoutParams());
            } else {
                lp.width = this.mHelper.getLayoutParams().width;
                lp.height = this.mHelper.getLayoutParams().height;
                if (lp instanceof ViewGroup.MarginLayoutParams) {
                    ((ViewGroup.MarginLayoutParams)lp).leftMargin = this.mHelper.getLayoutParams().leftMargin;
                    ((ViewGroup.MarginLayoutParams)lp).topMargin = this.mHelper.getLayoutParams().topMargin;
                    ((ViewGroup.MarginLayoutParams)lp).rightMargin = this.mHelper.getLayoutParams().rightMargin;
                    ((ViewGroup.MarginLayoutParams)lp).bottomMargin = this.mHelper.getLayoutParams().bottomMargin;
                }
            }
            View parent = (View)contentView.getParent();
            if (PopupUiUtils.isPopupBackgroundView(parent)) {
                ViewGroup.LayoutParams p = parent.getLayoutParams();
                if (p == null) {
                    p = new ViewGroup.LayoutParams(lp);
                } else {
                    p.height = -1;
                    p.width = -1;
                }
                parent.setLayoutParams(p);
            }
            contentView.setLayoutParams(lp);
            if (contentView.isFocusable()) {
                if (contentView instanceof ViewGroup) {
                    ((ViewGroup)contentView).setDescendantFocusability(262144);
                }
                PopupUiUtils.requestFocus(contentView);
            }
            if (this.mHelper.isAutoShowInputMethod()) {
                EditText focusTarget = this.mHelper.mAutoShowInputEdittext;
                if (focusTarget == null) {
                    focusTarget = contentView.findFocus();
                }
                KeyboardUtils.open((View)(focusTarget == null ? contentView : focusTarget), this.mHelper.showKeybaordDelay);
            }
        }
        wp.width = this.mHelper.getLayoutParams().width;
        wp.height = this.mHelper.getLayoutParams().height;
        this.childLeftMargin = this.mHelper.getLayoutParams().leftMargin;
        this.childTopMargin = this.mHelper.getLayoutParams().topMargin;
        this.childRightMargin = this.mHelper.getLayoutParams().rightMargin;
        this.childBottomMargin = this.mHelper.getLayoutParams().bottomMargin;
        this.mHelper.refreshNavigationBarBounds();
        if (wp.width > 0) {
            wp.width += this.childLeftMargin + this.childRightMargin;
        }
        if (wp.height > 0) {
            wp.height += this.childTopMargin + this.childBottomMargin;
        }
        this.addView(target, (ViewGroup.LayoutParams)wp);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == this.mMaskLayout) {
                this.measureChild(child, this.adjustWidthMeasureSpec(widthMeasureSpec, 0x10000000), this.adjustHeightMeasureSpec(heightMeasureSpec, 0x10000000));
                continue;
            }
            this.measureWrappedDecorView(child, this.adjustWidthMeasureSpec(widthMeasureSpec, 0x20000000), this.adjustHeightMeasureSpec(heightMeasureSpec, 0x20000000));
        }
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    private int adjustWidthMeasureSpec(int widthMeasureSpec, int overlayTarget) {
        if ((overlayTarget & 0x30000000) == 0) {
            return widthMeasureSpec;
        }
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if ((this.mHelper.overlayNavigationBarMode & overlayTarget) == 0) {
            int navigationBarGravity = this.mHelper.getNavigationBarGravity();
            int navigationBarSize = this.mHelper.getNavigationBarSize();
            if (navigationBarGravity == 3 || navigationBarGravity == 5) {
                widthSize -= navigationBarSize;
            }
        }
        return View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode);
    }

    private int adjustHeightMeasureSpec(int heightMeasureSpec, int overlayTarget) {
        if ((overlayTarget & 0x30000000) == 0) {
            return heightMeasureSpec;
        }
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if ((this.mHelper.overlayStatusBarMode & overlayTarget) == 0 && this.isStatusBarVisible) {
            heightSize -= PopupUiUtils.getStatusBarHeight();
        }
        if ((this.mHelper.overlayNavigationBarMode & overlayTarget) == 0) {
            int navigationBarGravity = this.mHelper.getNavigationBarGravity();
            int navigationBarSize = this.mHelper.getNavigationBarSize();
            if (navigationBarGravity == 48 || navigationBarGravity == 80) {
                heightSize -= navigationBarSize;
            }
        }
        return View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
    }

    private void measureWrappedDecorView(View mTarget, int widthMeasureSpec, int heightMeasureSpec) {
        if (mTarget == null || mTarget.getVisibility() == 8) {
            return;
        }
        ViewGroup.LayoutParams lp = mTarget.getLayoutParams();
        widthMeasureSpec = PopupDecorViewProxy.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)lp.width);
        heightMeasureSpec = PopupDecorViewProxy.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)lp.height);
        int widthSize = Math.max(mTarget.getMeasuredWidth(), View.MeasureSpec.getSize((int)widthMeasureSpec));
        int heightSize = Math.max(mTarget.getMeasuredHeight(), View.MeasureSpec.getSize((int)heightMeasureSpec));
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int gravity = this.mHelper.getPopupGravity();
        if (this.mHelper.isWithAnchor()) {
            Rect anchorRect = this.mHelper.getAnchorViewBound();
            int rl = anchorRect.left;
            int rt = anchorRect.top;
            int rr = widthSize - anchorRect.right;
            int rb = heightSize - anchorRect.bottom;
            if (this.mHelper.horizontalGravityMode == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE) {
                rl = widthSize - anchorRect.left;
                rr = anchorRect.right;
            }
            if (this.mHelper.verticalGravityMode == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE) {
                rt = heightSize - anchorRect.top;
                rb = anchorRect.bottom;
            }
            switch (gravity & 7) {
                case 3: {
                    if (lp.width == -1) {
                        widthSize = rl;
                    }
                    if (!this.mHelper.isFitsizable()) break;
                    widthSize = Math.min(widthSize, rl);
                    break;
                }
                case 5: {
                    if (lp.width == -1) {
                        widthSize = rr;
                    }
                    if (!this.mHelper.isFitsizable()) break;
                    widthSize = Math.min(widthSize, rr);
                    break;
                }
            }
            switch (gravity & 0x70) {
                case 48: {
                    if (lp.height == -1) {
                        heightSize = rt;
                    }
                    if (!this.mHelper.isFitsizable()) break;
                    heightSize = Math.min(heightSize, rt);
                    break;
                }
                case 80: {
                    if (lp.height == -1) {
                        heightSize = rb;
                    }
                    if (!this.mHelper.isFitsizable()) break;
                    heightSize = Math.min(heightSize, rb);
                    break;
                }
            }
        }
        if (this.mHelper.isAlignAnchorWidth()) {
            widthSize = this.mHelper.getAnchorViewBound().width();
        }
        if (this.mHelper.isAlignAnchorHeight()) {
            heightSize = this.mHelper.getAnchorViewBound().height();
        }
        if (this.mHelper.getMinWidth() > 0 && widthSize < this.mHelper.getMinWidth()) {
            this.adjustContentViewMeasure(mTarget, this.mHelper.getMinWidth(), 0);
            widthSize = this.mHelper.getMinWidth();
            widthMode = 0x40000000;
        }
        if (this.mHelper.getMaxWidth() > 0 && widthSize > this.mHelper.getMaxWidth()) {
            widthSize = this.mHelper.getMaxWidth();
        }
        if (this.mHelper.getMinHeight() > 0 && heightSize < this.mHelper.getMinHeight()) {
            this.adjustContentViewMeasure(mTarget, 0, this.mHelper.getMinHeight());
            heightSize = this.mHelper.getMinHeight();
            heightMode = 0x40000000;
        }
        if (this.mHelper.getMaxHeight() > 0 && heightSize > this.mHelper.getMaxHeight()) {
            heightSize = this.mHelper.getMaxHeight();
        }
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
        mTarget.measure(widthMeasureSpec, heightMeasureSpec);
    }

    void adjustContentViewMeasure(View target, int width, int height) {
        ViewGroup.LayoutParams p;
        if (target == null) {
            return;
        }
        View contentView = this.mTarget.findViewById(this.mHelper.contentRootId);
        if (contentView != null && (p = contentView.getLayoutParams()) != null) {
            if (width != 0) {
                p.width = width;
            }
            if (height != 0) {
                p.height = height;
            }
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.getLocationOnScreen(this.location);
        this.layoutInternal(l, t, r, b);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void layoutInternal(int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            boolean isOutsideScreen;
            boolean isVerticalAlignAnchorSlide;
            boolean delayLayoutMask;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            t = (this.mHelper.overlayStatusBarMode & (child == this.mMaskLayout ? 0x10000000 : 0x20000000)) == 0 ? (t == 0 ? t + PopupUiUtils.getStatusBarHeight() : t) : 0;
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            this.contentBounds.set(l, t, r, b);
            int navigationBarGravity = this.mHelper.getNavigationBarGravity();
            int navigationBarSize = (this.mHelper.overlayNavigationBarMode & (child == this.mMaskLayout ? 0x10000000 : 0x20000000)) == 0 ? this.mHelper.getNavigationBarSize() : 0;
            switch (navigationBarGravity) {
                case 3: {
                    this.contentBounds.left += navigationBarSize;
                    break;
                }
                case 5: {
                    this.contentBounds.right -= navigationBarSize;
                    break;
                }
                case 48: {
                    this.contentBounds.top += navigationBarSize;
                    break;
                }
                case 80: {
                    this.contentBounds.bottom -= navigationBarSize;
                }
            }
            int gravity = this.mHelper.getPopupGravity();
            int offsetX = this.mHelper.getOffsetX();
            int offsetY = this.mHelper.getOffsetY();
            boolean bl = delayLayoutMask = this.mHelper.isAlignBackground() && this.mHelper.getAlignBackgroundGravity() != 0;
            if (child == this.mMaskLayout) {
                this.contentBounds.offset(this.mHelper.maskOffsetX, this.mHelper.maskOffsetY);
                child.layout(this.contentBounds.left, this.contentBounds.top, this.contentBounds.left + this.getMeasuredWidth(), this.contentBounds.top + this.getMeasuredHeight());
                continue;
            }
            this.anchorRect.set(this.mHelper.getAnchorViewBound());
            this.anchorRect.offset(-this.location[0], -this.location[1]);
            boolean isRelativeToAnchor = this.mHelper.isWithAnchor();
            boolean isHorizontalAlignAnchorSlide = this.mHelper.horizontalGravityMode == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE;
            boolean bl2 = isVerticalAlignAnchorSlide = this.mHelper.verticalGravityMode == BasePopupWindow.GravityMode.ALIGN_TO_ANCHOR_SIDE;
            if (this.mHelper.layoutDirection == 1) {
                offsetX = ~offsetX + 1;
            }
            switch (gravity & 7) {
                case 3: {
                    if (isRelativeToAnchor) {
                        this.contentRect.left = isHorizontalAlignAnchorSlide ? this.anchorRect.left : this.anchorRect.left - width;
                        break;
                    }
                    this.contentRect.left = this.contentBounds.left;
                    break;
                }
                case 5: {
                    if (isRelativeToAnchor) {
                        this.contentRect.left = isHorizontalAlignAnchorSlide ? this.anchorRect.right - width : this.anchorRect.right;
                        break;
                    }
                    this.contentRect.left = this.contentBounds.right - width;
                    break;
                }
                case 1: {
                    if (isRelativeToAnchor) {
                        this.contentRect.left = this.anchorRect.left;
                        offsetX += this.anchorRect.centerX() - (this.contentRect.left + (width >> 1));
                        break;
                    }
                    this.contentRect.left = this.contentBounds.left + (this.contentBounds.width() - width >> 1);
                    break;
                }
                default: {
                    this.contentRect.left = isRelativeToAnchor ? this.anchorRect.left : this.contentBounds.left;
                }
            }
            this.contentRect.left += this.childLeftMargin - this.childRightMargin;
            switch (gravity & 0x70) {
                case 48: {
                    if (isRelativeToAnchor) {
                        this.contentRect.top = isVerticalAlignAnchorSlide ? this.anchorRect.top : this.anchorRect.top - height;
                        break;
                    }
                    this.contentRect.top = this.contentBounds.top;
                    break;
                }
                case 80: {
                    if (isRelativeToAnchor) {
                        this.contentRect.top = isVerticalAlignAnchorSlide ? this.anchorRect.bottom - height : this.anchorRect.bottom;
                        break;
                    }
                    this.contentRect.top = this.contentBounds.bottom - height;
                    break;
                }
                case 16: {
                    if (isRelativeToAnchor) {
                        this.contentRect.top = this.anchorRect.bottom;
                        offsetY += this.anchorRect.centerY() - (this.contentRect.top + (height >> 1));
                        break;
                    }
                    this.contentRect.top = this.contentBounds.top + (this.contentBounds.height() - height >> 1);
                    break;
                }
                default: {
                    this.contentRect.top = isRelativeToAnchor ? this.anchorRect.bottom : this.contentBounds.top;
                }
            }
            this.contentRect.top = this.contentRect.top + this.childTopMargin - this.childBottomMargin;
            if (this.mHelper.isAutoLocatePopup() && this.mHelper.isWithAnchor()) {
                int tBottom = this.contentRect.top + height + offsetY;
                switch (gravity & 0x70) {
                    case 48: {
                        int restHeight;
                        int n = restHeight = isVerticalAlignAnchorSlide ? b - this.anchorRect.top : this.anchorRect.top;
                        if (height <= restHeight) break;
                        offsetY += isVerticalAlignAnchorSlide ? 0 : this.anchorRect.bottom - this.contentRect.top;
                        break;
                    }
                    default: {
                        int restHeight;
                        int n = restHeight = isVerticalAlignAnchorSlide ? this.anchorRect.bottom : this.contentBounds.height() - this.anchorRect.bottom;
                        if (height <= restHeight) break;
                        offsetY -= isVerticalAlignAnchorSlide ? 0 : tBottom - this.anchorRect.top;
                    }
                }
            }
            this.contentRect.set(this.contentRect.left, this.contentRect.top, this.contentRect.left + width, this.contentRect.top + height);
            this.contentRect.offset(offsetX, offsetY);
            boolean bl3 = isOutsideScreen = !this.contentBounds.contains(this.contentRect);
            if (isOutsideScreen) {
                if (this.contentRect.left < this.contentBounds.left) {
                    this.contentRect.offsetTo(this.contentBounds.left, this.contentRect.top);
                }
                if (this.contentRect.right > this.contentBounds.right) {
                    int subWidth = this.contentRect.right - this.contentBounds.right;
                    if (subWidth > this.contentRect.left - this.contentBounds.left) {
                        this.contentRect.offsetTo(this.contentBounds.left, this.contentRect.top);
                        this.contentRect.right = this.contentBounds.right;
                    } else {
                        this.contentRect.offset(-subWidth, 0);
                    }
                }
                if (this.contentRect.top < this.contentBounds.top) {
                    this.contentRect.offsetTo(this.contentRect.left, this.contentBounds.top);
                }
                if (this.contentRect.bottom > this.contentBounds.bottom) {
                    int subHeight = this.contentRect.bottom - this.contentBounds.bottom;
                    if (subHeight > this.contentRect.bottom - this.contentBounds.bottom) {
                        this.contentRect.offsetTo(this.contentRect.left, this.contentBounds.top);
                        this.contentRect.bottom = this.contentBounds.bottom;
                    } else {
                        this.contentRect.offset(0, -subHeight);
                    }
                }
            }
            this.touchableRect.set(this.contentRect);
            this.touchableRect.left += this.childLeftMargin;
            this.touchableRect.top += this.childTopMargin;
            this.touchableRect.right -= this.childRightMargin;
            this.touchableRect.bottom -= this.childBottomMargin;
            this.touchableRectOnNoKeyboard.set(this.touchableRect);
            if (this.lastKeyboardOffset != 0) {
                this.touchableRect.offset(0, this.lastKeyboardOffset);
            }
            child.layout(this.contentRect.left, this.contentRect.top, this.contentRect.right, this.contentRect.bottom);
            if (delayLayoutMask) {
                this.mMaskLayout.handleAlignBackground(this.mHelper.getAlignBackgroundGravity(), this.contentRect.left, this.contentRect.top, this.contentRect.right, this.contentRect.bottom);
            }
            if (!isRelativeToAnchor) continue;
            this.popupRect.set(this.contentRect);
            this.mHelper.onPopupLayout(this.popupRect, this.anchorRect);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mMaskLayout != null) {
            this.mMaskLayout.handleStart(-2L);
        }
        if (this.mHelper != null) {
            this.mHelper.onAttachToWindow();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean intercept;
        boolean bl = intercept = this.mHelper != null && this.mHelper.onInterceptTouchEvent(ev);
        if (intercept) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean intercept;
        boolean bl = intercept = this.mHelper != null && this.mHelper.onTouchEvent(event);
        if (intercept) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int y;
        if (this.mMaskLayout == null) {
            return super.dispatchTouchEvent(ev);
        }
        int x = (int)ev.getX();
        if (!this.touchableRect.contains(x, y = (int)ev.getY())) {
            return this.mMaskLayout.dispatchTouchEvent(ev);
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean intercept;
        boolean bl = intercept = this.mHelper != null && this.mHelper.onDispatchKeyEvent(event);
        if (intercept) {
            return true;
        }
        if (event.getKeyCode() == 4) {
            KeyEvent.DispatcherState state;
            if (this.getKeyDispatcherState() == null) {
                return super.dispatchKeyEvent(event);
            }
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                KeyEvent.DispatcherState state2 = this.getKeyDispatcherState();
                if (state2 != null) {
                    state2.startTracking(event, (Object)this);
                }
                return true;
            }
            if (event.getAction() == 1 && (state = this.getKeyDispatcherState()) != null && state.isTracking(event) && !event.isCanceled() && this.mHelper != null) {
                return this.mHelper.onBackPressed();
            }
            return super.dispatchKeyEvent(event);
        }
        return super.dispatchKeyEvent(event);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clear(true);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public void updateLayout() {
        if (this.mHelper != null) {
            this.mHelper.onUpdate();
        }
        if (this.mMaskLayout != null) {
            this.mMaskLayout.update();
        }
        this.requestLayout();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        PopupDecorViewProxy v = this;
        if (this.getContext() instanceof Activity) {
            v = ((Activity)this.getContext()).getWindow().getDecorView();
        }
        v.post(new Runnable(){

            @Override
            public void run() {
                PopupDecorViewProxy.this.updateLayout();
            }
        });
    }

    @Override
    public void onEvent(Message msg) {
        if (msg.what == 3 && this.keyboardBoundsCache != null) {
            this.onKeyboardChange(this.keyboardBoundsCache, this.keyboardVisibleCache);
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.mHelper != null && this.mHelper.mPopupWindow != null) {
            this.mHelper.mPopupWindow.onWindowFocusChanged((View)this, hasWindowFocus);
        }
    }

    @Override
    public void onKeyboardChange(Rect keyboardBounds, boolean isVisible) {
        boolean process;
        if (this.mHelper.isOutSideTouchable() && !this.mHelper.isOverlayStatusbar()) {
            return;
        }
        int offset = 0;
        boolean forceAdjust = (this.mHelper.flag & 0x100000) != 0;
        boolean bl = process = forceAdjust || PopupUiUtils.getScreenOrientation() != 2 && (this.mHelper.getSoftInputMode() == 32 || this.mHelper.getSoftInputMode() == 16);
        if (!process) {
            return;
        }
        if (this.keyboardBoundsCache == null) {
            this.keyboardBoundsCache = new Rect();
        }
        this.keyboardBoundsCache.set(keyboardBounds);
        this.keyboardVisibleCache = isVisible;
        View alignWhat = this.mHelper.keybaordAlignView;
        if ((this.mHelper.flag & 0x10000) != 0 && this.mHelper.keybaordAlignViewId != 0) {
            alignWhat = this.mTarget.findViewById(this.mHelper.keybaordAlignViewId);
        }
        if ((this.mHelper.flag & 0x20000) != 0 || alignWhat == null) {
            alignWhat = this.mTarget;
        }
        boolean animate = (this.mHelper.flag & 0x80000) != 0;
        alignWhat.getLocationOnScreen(this.location);
        int bottom = this.location[1] + alignWhat.getHeight();
        if (isVisible && keyboardBounds.height() > 0) {
            int gravity;
            offset = keyboardBounds.top - bottom;
            if (bottom <= keyboardBounds.top && (this.mHelper.flag & 0x40000) != 0 && this.lastKeyboardBounds.isEmpty()) {
                offset = 0;
            } else if (this.mHelper.isWithAnchor() && ((gravity = PopupUiUtils.computeGravity(this.popupRect, this.anchorRect)) & 0x70) == 48) {
                offset -= this.mHelper.getAnchorViewBound().height();
            }
        }
        if (animate) {
            this.animateTranslate(this.mTarget, isVisible, offset);
        } else {
            this.mTarget.setTranslationY(isVisible ? this.mTarget.getTranslationY() + (float)offset : 0.0f);
        }
        if (isVisible) {
            this.touchableRectOnNoKeyboard.set(this.touchableRect);
            this.lastKeyboardOffset = offset;
            this.touchableRect.offset(0, offset);
            this.lastKeyboardBounds.set(keyboardBounds);
        } else {
            this.lastKeyboardOffset = 0;
            this.touchableRect.set(this.touchableRectOnNoKeyboard);
            this.lastKeyboardBounds.setEmpty();
        }
    }

    private void animateTranslate(View target, boolean isVisible, int offset) {
        target.animate().cancel();
        if (isVisible) {
            target.animate().translationYBy((float)offset).setDuration(300L).start();
        } else {
            target.animate().translationY(0.0f).setDuration(200L).start();
        }
    }

    @Override
    public void clear(boolean destroy) {
        if (this.mHelper != null) {
            this.mHelper.mKeyboardStateChangeListener = null;
            this.mHelper.removeEventObserver(this);
        }
        if (this.mMaskLayout != null) {
            this.mMaskLayout.clear(destroy);
        }
        if (this.mTarget != null) {
            this.mTarget.setOnClickListener(null);
        }
        this.mHelper = null;
        this.mTarget = null;
    }
}

