/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.LinkedList;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.basepopup.PopupDecorViewProxy;
import razerdp.util.PopupUiUtils;
import razerdp.util.log.PopupLog;

final class WindowManagerProxy
implements WindowManager,
ClearMemoryObject {
    private static final String TAG = "WindowManagerProxy";
    private WindowManager mWindowManager;
    PopupDecorViewProxy mPopupDecorViewProxy;
    BasePopupHelper mPopupHelper;
    boolean isAddedToQueue;
    static final WindowFlagCompat FLAG_COMPAT = Build.VERSION.SDK_INT >= 30 ? new WindowFlagCompat.Api30Impl() : new WindowFlagCompat.BeforeApi30Impl();

    WindowManagerProxy(WindowManager windowManager, BasePopupHelper helper) {
        this.mWindowManager = windowManager;
        this.mPopupHelper = helper;
    }

    public Display getDefaultDisplay() {
        return this.mWindowManager == null ? null : this.mWindowManager.getDefaultDisplay();
    }

    public void removeViewImmediate(View view) {
        PopupLog.i(TAG, "WindowManager.removeViewImmediate  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        PopupWindowQueueManager.getInstance().remove(this);
        if (this.mWindowManager == null || view == null) {
            return;
        }
        if (this.isPopupInnerDecorView(view) && this.mPopupDecorViewProxy != null) {
            PopupDecorViewProxy popupDecorViewProxy = this.mPopupDecorViewProxy;
            if (Build.VERSION.SDK_INT >= 19 && !popupDecorViewProxy.isAttachedToWindow()) {
                return;
            }
            this.mWindowManager.removeViewImmediate((View)popupDecorViewProxy);
            this.mPopupDecorViewProxy.clear(true);
            this.mPopupDecorViewProxy = null;
        } else {
            this.mWindowManager.removeViewImmediate(view);
        }
    }

    public void addView(View view, ViewGroup.LayoutParams params) {
        PopupLog.i(TAG, "WindowManager.addView  >>>  " + (view == null ? null : view.getClass().getName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        if (this.isPopupInnerDecorView(view)) {
            FLAG_COMPAT.setupFlag(params, this.mPopupHelper);
            this.mPopupDecorViewProxy = new PopupDecorViewProxy(view.getContext(), this.mPopupHelper);
            this.mPopupDecorViewProxy.wrapPopupDecorView(view, (WindowManager.LayoutParams)params);
            this.mWindowManager.addView((View)this.mPopupDecorViewProxy, this.fitLayoutParamsPosition(params));
        } else {
            this.mWindowManager.addView(view, params);
        }
        PopupWindowQueueManager.getInstance().put(this);
    }

    private ViewGroup.LayoutParams fitLayoutParamsPosition(ViewGroup.LayoutParams params) {
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams p = (WindowManager.LayoutParams)params;
            if (this.mPopupHelper != null) {
                if (this.mPopupHelper.getShowCount() > 1) {
                    p.type = 1002;
                }
                p.y = 0;
                p.x = 0;
                p.width = -1;
                p.height = -1;
            }
            FLAG_COMPAT.setupFlag((ViewGroup.LayoutParams)p, this.mPopupHelper);
            if (this.mPopupHelper.mOnFitWindowManagerLayoutParamsCallback != null) {
                this.mPopupHelper.mOnFitWindowManagerLayoutParamsCallback.onFitLayoutParams(p);
            }
        }
        return params;
    }

    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        PopupLog.i(TAG, "WindowManager.updateViewLayout  >>>  " + (view == null ? null : view.getClass().getName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        if (this.isPopupInnerDecorView(view) && this.mPopupDecorViewProxy != null || view == this.mPopupDecorViewProxy) {
            this.mWindowManager.updateViewLayout((View)this.mPopupDecorViewProxy, this.fitLayoutParamsPosition(params));
        } else {
            this.mWindowManager.updateViewLayout(view, params);
        }
    }

    void updateFocus(boolean focus) {
        if (this.mWindowManager != null && this.mPopupDecorViewProxy != null) {
            PopupDecorViewProxy popupDecorViewProxy = this.mPopupDecorViewProxy;
            ViewGroup.LayoutParams params = popupDecorViewProxy.getLayoutParams();
            if (params instanceof WindowManager.LayoutParams) {
                ((WindowManager.LayoutParams)params).flags = focus ? (((WindowManager.LayoutParams)params).flags &= 0xFFFDFFF7) : (((WindowManager.LayoutParams)params).flags |= 8);
            }
            this.mWindowManager.updateViewLayout((View)popupDecorViewProxy, params);
        }
    }

    void updateFlag(int mode, boolean updateImmediately, int ... flags) {
        if (flags == null || flags.length == 0) {
            return;
        }
        if (this.mWindowManager != null && this.mPopupDecorViewProxy != null) {
            PopupDecorViewProxy popupDecorViewProxy = this.mPopupDecorViewProxy;
            ViewGroup.LayoutParams params = popupDecorViewProxy.getLayoutParams();
            if (params instanceof WindowManager.LayoutParams) {
                for (int flag : flags) {
                    if (mode == -1) {
                        ((WindowManager.LayoutParams)params).flags |= flag;
                        continue;
                    }
                    if (mode != -2) continue;
                    ((WindowManager.LayoutParams)params).flags &= ~flag;
                }
            }
            if (updateImmediately) {
                this.mWindowManager.updateViewLayout((View)popupDecorViewProxy, params);
            }
        }
    }

    public void update() {
        if (this.mWindowManager == null) {
            return;
        }
        if (this.mPopupDecorViewProxy != null) {
            this.mPopupDecorViewProxy.updateLayout();
        }
    }

    public void removeView(View view) {
        PopupLog.i(TAG, "WindowManager.removeView  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        PopupWindowQueueManager.getInstance().remove(this);
        if (this.mWindowManager == null || view == null) {
            return;
        }
        if (this.isPopupInnerDecorView(view) && this.mPopupDecorViewProxy != null) {
            this.mWindowManager.removeView((View)this.mPopupDecorViewProxy);
            if (this.mPopupDecorViewProxy.mHelper != null) {
                this.mPopupDecorViewProxy.mHelper.showFlag &= 0xFFFFFFFD;
            }
            this.mPopupDecorViewProxy = null;
        } else {
            this.mWindowManager.removeView(view);
        }
    }

    private boolean isPopupInnerDecorView(View v) {
        return PopupUiUtils.isPopupDecorView(v) || PopupUiUtils.isPopupViewContainer(v);
    }

    @Override
    public void clear(boolean destroy) {
        try {
            if (this.mPopupDecorViewProxy != null) {
                this.removeViewImmediate((View)this.mPopupDecorViewProxy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (destroy) {
            String key = PopupWindowQueueManager.getInstance().getKey(this);
            PopupWindowQueueManager.getInstance().clear(key);
            this.mWindowManager = null;
            this.mPopupDecorViewProxy = null;
            this.mPopupHelper = null;
        }
    }

    @Nullable
    WindowManagerProxy preWindow() {
        return PopupWindowQueueManager.getInstance().preWindow(this);
    }

    void dispatchToDecorProxy(MotionEvent ev) {
        if (this.mPopupDecorViewProxy != null) {
            this.mPopupDecorViewProxy.dispatchTouchEvent(ev);
        }
    }

    static interface WindowFlagCompat {
        public void setupFlag(ViewGroup.LayoutParams var1, BasePopupHelper var2);

        public static class Api30Impl
        implements WindowFlagCompat {
            @Override
            public void setupFlag(ViewGroup.LayoutParams params, BasePopupHelper helper) {
                if (params instanceof WindowManager.LayoutParams && helper != null) {
                    Activity decorAct;
                    WindowManager.LayoutParams p = (WindowManager.LayoutParams)params;
                    if (Build.VERSION.SDK_INT >= 28 && (decorAct = helper.mPopupWindow.getContext()) != null) {
                        WindowManager.LayoutParams lp = decorAct.getWindow().getAttributes();
                        p.layoutInDisplayCutoutMode = lp.layoutInDisplayCutoutMode;
                    }
                    int insetsType = p.getFitInsetsTypes();
                    if (helper.isOverlayStatusbar()) {
                        int cutoutGravity;
                        PopupLog.i(WindowManagerProxy.TAG, "applyHelper  >>>  \u8986\u76d6\u72b6\u6001\u680f");
                        if (Build.VERSION.SDK_INT >= 28 && ((cutoutGravity = helper.getCutoutGravity()) == 48 || cutoutGravity == 80)) {
                            p.layoutInDisplayCutoutMode = 1;
                        }
                    }
                    insetsType &= ~WindowInsets.Type.statusBars();
                    p.setFitInsetsTypes(insetsType &= ~WindowInsets.Type.navigationBars());
                }
            }
        }

        public static class BeforeApi30Impl
        implements WindowFlagCompat {
            @Override
            public void setupFlag(ViewGroup.LayoutParams params, BasePopupHelper helper) {
                if (params instanceof WindowManager.LayoutParams && helper != null) {
                    Activity decorAct;
                    WindowManager.LayoutParams p = (WindowManager.LayoutParams)params;
                    if (Build.VERSION.SDK_INT >= 28 && (decorAct = helper.mPopupWindow.getContext()) != null) {
                        WindowManager.LayoutParams lp = decorAct.getWindow().getAttributes();
                        p.layoutInDisplayCutoutMode = lp.layoutInDisplayCutoutMode;
                    }
                    if (helper.isOverlayStatusbar()) {
                        int cutoutGravity;
                        PopupLog.i(WindowManagerProxy.TAG, "applyHelper  >>>  \u8986\u76d6\u72b6\u6001\u680f");
                        if (Build.VERSION.SDK_INT >= 28 && ((cutoutGravity = helper.getCutoutGravity()) == 48 || cutoutGravity == 80)) {
                            p.layoutInDisplayCutoutMode = 1;
                        }
                    }
                    p.flags |= 0x100;
                    p.flags |= 0x200;
                    if (Build.VERSION.SDK_INT >= 18) {
                        p.flags |= 0x2000000;
                    }
                }
            }
        }
    }

    static class PopupWindowQueueManager {
        static final HashMap<String, LinkedList<WindowManagerProxy>> sQueueMap = new HashMap();

        private PopupWindowQueueManager() {
        }

        static PopupWindowQueueManager getInstance() {
            return SingleTonHolder.INSTANCE;
        }

        String getKey(WindowManagerProxy managerProxy) {
            if (managerProxy == null || managerProxy.mPopupHelper == null || managerProxy.mPopupHelper.mPopupWindow == null) {
                return null;
            }
            return String.valueOf(managerProxy.mPopupHelper.mPopupWindow.getContext());
        }

        @Nullable
        LinkedList<WindowManagerProxy> getPopupList(Context context) {
            if (sQueueMap == null || sQueueMap.isEmpty()) {
                return null;
            }
            return sQueueMap.get(String.valueOf(context));
        }

        void put(WindowManagerProxy managerProxy) {
            if (managerProxy == null || managerProxy.isAddedToQueue) {
                return;
            }
            String key = this.getKey(managerProxy);
            if (TextUtils.isEmpty((CharSequence)key)) {
                return;
            }
            LinkedList<WindowManagerProxy> queue = sQueueMap.get(key);
            if (queue == null) {
                queue = new LinkedList();
                sQueueMap.put(key, queue);
            }
            queue.addLast(managerProxy);
            managerProxy.isAddedToQueue = true;
            PopupLog.d(WindowManagerProxy.TAG, queue);
        }

        void remove(WindowManagerProxy managerProxy) {
            if (managerProxy == null || !managerProxy.isAddedToQueue) {
                return;
            }
            String key = this.getKey(managerProxy);
            if (TextUtils.isEmpty((CharSequence)key)) {
                return;
            }
            LinkedList<WindowManagerProxy> queue = sQueueMap.get(key);
            if (queue != null) {
                queue.remove(managerProxy);
            }
            managerProxy.isAddedToQueue = false;
            PopupLog.d(WindowManagerProxy.TAG, queue);
        }

        void clear(String key) {
            LinkedList<WindowManagerProxy> queue = sQueueMap.get(key);
            if (queue != null) {
                queue.clear();
            }
            sQueueMap.remove(key);
            PopupLog.d(WindowManagerProxy.TAG, queue, sQueueMap);
        }

        @Nullable
        WindowManagerProxy preWindow(WindowManagerProxy managerProxy) {
            if (managerProxy == null) {
                return null;
            }
            String key = this.getKey(managerProxy);
            if (TextUtils.isEmpty((CharSequence)key)) {
                return null;
            }
            LinkedList<WindowManagerProxy> queue = sQueueMap.get(key);
            if (queue == null) {
                return null;
            }
            int index = queue.indexOf(managerProxy) - 1;
            if (index >= 0 && index < queue.size()) {
                return queue.get(index);
            }
            return null;
        }

        private static class SingleTonHolder {
            private static PopupWindowQueueManager INSTANCE = new PopupWindowQueueManager();

            private SingleTonHolder() {
            }
        }
    }
}

