/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.QuickPopupConfig;
import razerdp.widget.QuickPopup;

public class QuickPopupBuilder
implements LifecycleObserver {
    private QuickPopupConfig mConfig;
    private WeakReference<Object> ownerAnchorParent;
    private int width = 0;
    private int height = 0;

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    void onDestroy() {
        this.ownerAnchorParent = null;
    }

    private QuickPopupBuilder(Object obj) {
        this.ownerAnchorParent = new WeakReference<Object>(obj);
        this.mConfig = QuickPopupConfig.generateDefault();
        Activity activity = BasePopupHelper.findActivity(obj, false);
        if (activity instanceof LifecycleOwner) {
            ((LifecycleOwner)activity).getLifecycle().addObserver((LifecycleObserver)this);
        } else if (activity != null) {
            activity.getWindow().getDecorView().addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                }

                public void onViewDetachedFromWindow(View v) {
                    v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    QuickPopupBuilder.this.onDestroy();
                }
            });
        }
    }

    public static QuickPopupBuilder with(Context context) {
        return new QuickPopupBuilder(context);
    }

    public static QuickPopupBuilder with(Fragment fragment) {
        return new QuickPopupBuilder(fragment);
    }

    public static QuickPopupBuilder with(Dialog dialog) {
        return new QuickPopupBuilder(dialog);
    }

    public QuickPopupBuilder contentView(int resId) {
        this.mConfig.contentViewLayoutid(resId);
        return this;
    }

    public QuickPopupBuilder width(int width) {
        this.width = width;
        return this;
    }

    public QuickPopupBuilder height(int height) {
        this.height = height;
        return this;
    }

    @Deprecated
    public QuickPopupBuilder wrapContentMode() {
        return this.width(-2).height(-2);
    }

    public final QuickPopupConfig getConfig() {
        return this.mConfig;
    }

    public QuickPopupBuilder config(QuickPopupConfig quickPopupConfig) {
        if (quickPopupConfig == null) {
            return this;
        }
        if (quickPopupConfig != this.mConfig) {
            quickPopupConfig.contentViewLayoutid(this.mConfig.contentViewLayoutid);
        }
        this.mConfig = quickPopupConfig;
        return this;
    }

    public QuickPopup build() {
        Object anchor;
        Object v0 = anchor = this.ownerAnchorParent == null ? null : this.ownerAnchorParent.get();
        if (anchor instanceof Context) {
            return new QuickPopup(anchor, this.width, this.height, this.mConfig);
        }
        if (anchor instanceof Fragment) {
            return new QuickPopup(anchor, this.width, this.height, this.mConfig);
        }
        if (anchor instanceof Dialog) {
            return new QuickPopup(anchor, this.width, this.height, this.mConfig);
        }
        throw new NullPointerException("\u5bbf\u4e3b\u5df2\u7ecf\u88ab\u9500\u6bc1");
    }

    public QuickPopup show() {
        return this.show(null);
    }

    public QuickPopup show(View anchorView) {
        QuickPopup quickPopup = this.build();
        quickPopup.showPopupWindow(anchorView);
        return quickPopup;
    }

    public QuickPopup show(int x, int y) {
        QuickPopup quickPopup = this.build();
        quickPopup.showPopupWindow(x, y);
        return quickPopup;
    }
}

